/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.workspace;

import org.eclipse.swt.graphics.Device;
import org.eurocarbdb.application.glycanbuilder.CompositionOptions;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.FileHistory;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.ResidueHistory;
import org.grits.toolbox.tools.glycanbuilder.core.config.GraphicOptionsSWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.GlycanRendererSWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.GlycanRendererAWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.SVGUtils;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.style.LinkageStyleDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.style.ResiduePlacementDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.style.ResidueStyleDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.CoreDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.CrossRingFragmentDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.ResidueDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.TerminalDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.document.GlycanDocument;

public class BuilderWorkspaceSWT {
    protected static boolean loaded = false;
    protected boolean autosave;
    private Device device;
    protected ResiduePlacementDictionary theResiduePlacementDictionary;
    protected ResidueStyleDictionary theResidueStyleDictionary;
    protected LinkageStyleDictionary theLinkageStyleDictionary;
    protected Configuration theConfiguration;
    protected FileHistory theFileHistory;
    protected ResidueHistory theResidueHistory;
    protected MassOptions theMassOptions;
    protected GraphicOptionsSWT theGraphicOptions;
    protected CompositionOptions theCompositionOptions;
    protected GlycanDocument theGlycanDoc;
    protected GlycanRendererSWT theGlycanRenderer;

    public BuilderWorkspaceSWT(Device device) {
        this(device, null, false);
    }

    public BuilderWorkspaceSWT(Device device, String config_file, boolean create) {
        this.device = device;
        this.init(config_file, create, false);
    }

    public Device getParentDevice() {
        return this.device;
    }

    protected void createConfiguration() {
        this.theConfiguration = new Configuration();
        this.theFileHistory = new FileHistory();
        this.theResidueHistory = new ResidueHistory();
        this.theMassOptions = new MassOptions();
        this.theGraphicOptions = new GraphicOptionsSWT();
        this.theCompositionOptions = new CompositionOptions();
    }

    public void init(String config_file, boolean create, boolean keep_configuration) {
        if (!keep_configuration || this.theConfiguration == null) {
            this.createConfiguration();
            if (config_file != null && this.theConfiguration.open(config_file)) {
                this.retrieveFromConfiguration();
            } else {
                this.storeToConfiguration(true);
                if (config_file != null && create) {
                    this.theConfiguration.save(config_file);
                }
            }
            if (!loaded) {
                org.eurocarbdb.application.glycanbuilder.ResidueDictionary.loadDictionary((String)"/conf/residue_types");
                ResidueDictionary.loadDictionary("/conf/residue_types");
                TerminalDictionary.loadDictionary("/conf/terminal_types");
                CoreDictionary.loadDictionary("/conf/core_types");
                CrossRingFragmentDictionary.loadDictionary("/conf/cross_ring_fragment_types");
                loaded = true;
            }
            this.theResiduePlacementDictionary = new ResiduePlacementDictionary();
            this.theResidueStyleDictionary = new ResidueStyleDictionary();
            this.theLinkageStyleDictionary = new LinkageStyleDictionary();
            this.loadStyles(this.theGraphicOptions.NOTATION);
            this.setDisplay(this.theGraphicOptions.DISPLAY);
        }
        this.theGlycanDoc = new GlycanDocument();
        this.theGlycanDoc.setDefaultMassOptions(this.theMassOptions);
        this.theGlycanRenderer = new GlycanRendererSWT(this.device);
        this.theGlycanRenderer.setGraphicOptions(this.theGraphicOptions);
        this.theGlycanRenderer.setResiduePlacementDictionary(this.theResiduePlacementDictionary);
        this.theGlycanRenderer.setResidueStyleDictionary(this.theResidueStyleDictionary);
        this.theGlycanRenderer.setLinkageStyleDictionary(this.theLinkageStyleDictionary);
    }

    protected void retrieveFromConfiguration() {
        this.theFileHistory.retrieve(this.theConfiguration);
        this.theResidueHistory.retrieve(this.theConfiguration);
        this.theMassOptions.retrieve(this.theConfiguration);
        this.theGraphicOptions.retrieve(this.theConfiguration);
        this.theCompositionOptions.retrieve(this.theConfiguration);
    }

    protected void storeToConfiguration(boolean save_options) {
        this.theFileHistory.store(this.theConfiguration);
        this.theResidueHistory.store(this.theConfiguration);
        if (save_options) {
            this.theMassOptions.store(this.theConfiguration);
            this.theGraphicOptions.store(this.theConfiguration);
            this.theCompositionOptions.store(this.theConfiguration);
        }
    }

    public void exit(String config_file) {
        if (config_file != null) {
            this.storeToConfiguration(this.autosave);
            this.theConfiguration.save(config_file);
        }
    }

    public boolean getAutoSave() {
        return this.autosave;
    }

    public void setAutoSave(boolean flag) {
        this.autosave = flag;
    }

    public Configuration getConfiguration() {
        return this.theConfiguration;
    }

    public FileHistory getFileHistory() {
        return this.theFileHistory;
    }

    public void storeFileHistory() {
        this.theFileHistory.store(this.theConfiguration);
    }

    public ResidueHistory getResidueHistory() {
        return this.theResidueHistory;
    }

    public void storeResidueHistory() {
        this.theResidueHistory.store(this.theConfiguration);
    }

    public MassOptions getDefaultMassOptions() {
        return this.theMassOptions;
    }

    public void setDefaultMassOptions(MassOptions mass_opt) {
        if (mass_opt == null) {
            return;
        }
        this.theMassOptions = mass_opt;
        this.theGlycanDoc.setDefaultMassOptions(this.theMassOptions);
    }

    public void storeDefaultMassOptions() {
        this.theMassOptions.store(this.theConfiguration);
    }

    public GraphicOptionsSWT getGraphicOptions() {
        return this.theGraphicOptions;
    }

    public void storeGraphicOptions() {
        this.theGraphicOptions.store(this.theConfiguration);
    }

    public CompositionOptions getCompositionOptions() {
        return this.theCompositionOptions;
    }

    public void storeCompositionOptions() {
        this.theCompositionOptions.store(this.theConfiguration);
    }

    public GlycanDocument getGlycanDocument() {
        return this.theGlycanDoc;
    }

    public GlycanRendererSWT getGlycanRenderer() {
        return this.theGlycanRenderer;
    }

    public GlycanRendererAWT getGlycanRendererAWT() {
        return SVGUtils.convertRenderer(this.theGlycanRenderer);
    }

    public void setNotation(String notation) {
        this.theGraphicOptions.NOTATION = notation;
        this.loadStyles(notation);
    }

    public void setDisplay(String display) {
        this.theGraphicOptions.setDisplay(display);
    }

    protected void loadStyles(String notation) {
        if (notation.equals("uoxf")) {
            this.theResiduePlacementDictionary.loadPlacements("/conf/residue_placements_uoxf");
            this.theResidueStyleDictionary.loadStyles("/conf/residue_styles_uoxf");
            this.theLinkageStyleDictionary.loadStyles("/conf/linkage_styles_uoxf");
        } else if (notation.equals("uoxfcol")) {
            this.theResiduePlacementDictionary.loadPlacements("/conf/residue_placements_uoxf");
            this.theResidueStyleDictionary.loadStyles("/conf/residue_styles_uoxfcol");
            this.theLinkageStyleDictionary.loadStyles("/conf/linkage_styles_uoxf");
        } else if (notation.equals("text")) {
            this.theResiduePlacementDictionary.loadPlacements("/conf/residue_placements_cfg");
            this.theResidueStyleDictionary.loadStyles("/conf/residue_styles_text");
            this.theLinkageStyleDictionary.loadStyles("/conf/linkage_styles_cfg");
        } else if (notation.equals("cfglink")) {
            this.theResiduePlacementDictionary.loadPlacements("/conf/residue_placements_uoxf");
            this.theResidueStyleDictionary.loadStyles("/conf/residue_styles_cfg");
            this.theLinkageStyleDictionary.loadStyles("/conf/linkage_styles_cfglink");
        } else if (notation.equals("cfgbw")) {
            this.theResiduePlacementDictionary.loadPlacements("/conf/residue_placements_cfg");
            this.theResidueStyleDictionary.loadStyles("/conf/residue_styles_cfgbw");
            this.theLinkageStyleDictionary.loadStyles("/conf/linkage_styles_cfg");
        } else if (notation.equals("cfg")) {
            this.theResiduePlacementDictionary.loadPlacements("/conf/residue_placements_cfg");
            this.theResidueStyleDictionary.loadStyles("/conf/residue_styles_cfg");
            this.theLinkageStyleDictionary.loadStyles("/conf/linkage_styles_cfg");
        } else {
            this.theResiduePlacementDictionary.loadPlacements("/conf/residue_placements_snfg");
            this.theResidueStyleDictionary.loadStyles("/conf/residue_styles_snfg");
            this.theLinkageStyleDictionary.loadStyles("/conf/linkage_styles_snfg");
        }
    }
}

