/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptorgroups;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.forms.widgets.Section;
import org.grits.toolbox.editor.samplemanager.input.TemplateWithFeatures;
import org.grits.toolbox.entry.sample.model.Category;

public class TemplateCategoryDescriptorGroupListener
implements ISelectionChangedListener {
    private CheckboxTableViewer tableViewer;
    private TemplateWithFeatures selectedTemplate;

    public TemplateCategoryDescriptorGroupListener(CheckboxTableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.setSelectedTemplate(this.selectedTemplate);
    }

    public void setSelectedTemplate(TemplateWithFeatures selectedTemplate) {
        this.selectedTemplate = selectedTemplate;
        this.tableViewer.refresh();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ComboViewer cViewer = (ComboViewer)event.getSource();
        Category selectedCategory = (Category)cViewer.getElementAt(cViewer.getCombo().getSelectionIndex());
        this.setCategoryTemplate(selectedCategory, this.tableViewer);
        this.tableViewer.refresh();
    }

    private void setCategoryTemplate(Category selectedCategory, CheckboxTableViewer tableViewer) {
        Section tableViewerSection = (Section)tableViewer.getTable().getParent().getParent();
        tableViewerSection.getTextClient().setEnabled(true);
        switch (selectedCategory.getUri()) {
            case "http://www.grits-toolbox.org/ontology/sample#category_amount": {
                tableViewer.setInput((Object)this.selectedTemplate.getTemplate().getAmountTemplate());
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_qc": {
                tableViewer.setInput((Object)this.selectedTemplate.getTemplate().getPurityQCTemplate());
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_sample": {
                tableViewer.setInput((Object)this.selectedTemplate.getTemplate().getSampleInformationTemplate());
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_sample_tracking": {
                tableViewer.setInput((Object)this.selectedTemplate.getTemplate().getTrackingTemplate());
                break;
            }
            default: {
                tableViewerSection.getTextClient().setEnabled(false);
            }
        }
    }
}

