/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.actions.pages.rightside;

import com.hp.hpl.jena.ontology.OntModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.editor.samplemanager.ManagementEditor;
import org.grits.toolbox.editor.samplemanager.ontology.GritsOntologyManagerApi;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;

public abstract class AbstractDeleteAction
extends Action {
    protected AbstractManagementPage page = null;
    protected TableViewer tableViewer = null;
    protected GritsOntologyManagerApi ontologyManagerApi = null;
    protected OntModel standardOntology;
    protected OntModel localOntology;
    protected int selectionIndex;

    public AbstractDeleteAction(AbstractManagementPage page, TableViewer tableViewer) {
        this.page = page;
        this.tableViewer = tableViewer;
        this.initDataSource();
        this.setupUI();
    }

    protected void initDataSource() {
        ManagementEditor editor = (ManagementEditor)this.page.getEditor();
        this.ontologyManagerApi = editor.getOntologyManagerApi();
        this.standardOntology = editor.getStandardOntologyModel();
        this.localOntology = editor.getLocalOntologyModel();
    }

    protected void setupUI() {
        this.setToolTipText("Delete from the list");
        ImageDescriptor imageDesc = ImageShare.DELETE_ICON;
        Image image = imageDesc.createImage();
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
    }

    public abstract void run();

    protected void removeTripleFromOntology(String subjectURI, String propertyURI, String objectURI) {
        this.ontologyManagerApi.removeTriple(subjectURI, propertyURI, objectURI);
        this.refreshModifed();
    }

    public void refreshModifed() {
        this.tableViewer.refresh();
        if (this.selectionIndex != -1) {
            this.tableViewer.getTable().setSelection(Math.min(this.tableViewer.getTable().getItemCount() - 1, this.selectionIndex));
        }
        ((ManagementEditor)this.page.getEditor()).markDirty();
    }
}

