/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.AbstractGlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.Geometry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.GraphicUtils;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LinkageRendererAWT;
import org.eurocarbdb.application.glycanbuilder.Paintable;
import org.eurocarbdb.application.glycanbuilder.PositionManager;
import org.eurocarbdb.application.glycanbuilder.ResAngle;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueRendererAWT;
import org.eurocarbdb.application.glycanbuilder.SVGUtils;
import org.eurocarbdb.application.glycanbuilder.StyledTextCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlycanRendererAWT
extends AbstractGlycanRenderer {
    public GlycanRendererAWT() {
    }

    public GlycanRendererAWT(AbstractGlycanRenderer src) {
        super(src);
    }

    public GlycanRendererAWT(GlycanRendererAWT src) {
        super(src);
    }

    @Override
    protected void initialiseRenderers() {
        this.theResidueRenderer = new ResidueRendererAWT(this);
        this.theLinkageRenderer = new LinkageRendererAWT(this);
    }

    @Override
    public void paint(Paintable paintable, Glycan structure, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, Collection<Residue> active_residues, boolean show_mass, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        if (structure == null || structure.isEmpty()) {
            return;
        }
        selected_residues = selected_residues != null ? selected_residues : new HashSet<Residue>();
        HashSet<Linkage> hashSet = selected_linkages = selected_linkages != null ? selected_linkages : new HashSet<Linkage>();
        if (structure.isComposition()) {
            this.paintComposition(paintable, structure.getRoot(), structure.getBracket(), selected_residues, posManager, bboxManager);
        } else {
            this.paintResidue(paintable, structure.getRoot(show_redend), selected_residues, selected_linkages, active_residues, posManager, bboxManager);
            this.paintBracket(paintable, structure.getBracket(), selected_residues, selected_linkages, active_residues, posManager, bboxManager);
        }
        if (show_mass) {
            this.displayMass(paintable, structure, show_redend, bboxManager);
        }
    }

    @Override
    protected void displayMass(Paintable paintable, Glycan structure, boolean show_redend, BBoxManager bboxManager) {
        Graphics2D g2d = paintable.getGraphics2D();
        Rectangle structure_all_bbox = bboxManager.getComplete(structure.getRoot(show_redend));
        g2d.setColor(Color.black);
        g2d.setFont(new Font(this.theGraphicOptions.MASS_TEXT_FONT_FACE, 0, this.theGraphicOptions.MASS_TEXT_SIZE));
        String text = this.getMassText(structure);
        g2d.drawString(text, Geometry.left(structure_all_bbox), Geometry.bottom(structure_all_bbox) + this.theGraphicOptions.MASS_TEXT_SPACE + this.theGraphicOptions.MASS_TEXT_SIZE);
    }

    @Override
    protected void paintComposition(Paintable paintable, Residue root, Residue bracket, HashSet<Residue> selected_residues, PositionManager posManager, BBoxManager bboxManager) {
        Graphics2D g2d = paintable.getGraphics2D();
        ResAngle orientation = posManager.getOrientation(root);
        String text = GlycanRendererAWT.makeCompositionText(root, bracket, orientation, true);
        Rectangle text_rect = bboxManager.getCurrent(bracket);
        if (selected_residues.contains(bracket)) {
            float[] dashes = new float[]{5.0f, 5.0f};
            g2d.setStroke(new BasicStroke(2.0f, 0, 1, 1.0f, dashes, 0.0f));
            g2d.setColor(Color.black);
            g2d.draw(text_rect);
            g2d.setStroke(new BasicStroke(1.0f));
        }
        Font font = new Font(this.theGraphicOptions.COMPOSITION_FONT_FACE, 0, this.theGraphicOptions.COMPOSITION_FONT_SIZE);
        StyledTextCellRenderer stcr = new StyledTextCellRenderer(false);
        stcr.getRendererComponent(font, Color.black, Color.white, text);
        BufferedImage img = SVGUtils.getImage(stcr, false);
        if (orientation.equals(0) || orientation.equals(180)) {
            g2d.drawImage(img, null, text_rect.x, text_rect.y);
        } else {
            g2d.rotate(-1.5707963267948966);
            g2d.drawImage(img, null, -text_rect.y - text_rect.height, text_rect.x);
            g2d.rotate(1.5707963267948966);
        }
    }

    @Override
    protected void paintQuantity(Paintable paintable, Residue antenna, int quantity, BBoxManager bboxManager) {
        ResAngle orientation = this.theGraphicOptions.getOrientationAngle();
        Graphics2D g2d = paintable.getGraphics2D();
        String text = orientation.equals(0) || orientation.equals(-90) ? "x" + quantity : quantity + "x";
        Dimension text_dim = Geometry.textBounds(text, this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
        Rectangle text_rect = null;
        Rectangle antenna_bbox = bboxManager.getComplete(antenna);
        text_rect = orientation.equals(0) ? new Rectangle(Geometry.right(antenna_bbox) + 3, Geometry.midy(antenna_bbox) - 1 - text_dim.height / 2, text_dim.width, text_dim.height) : (orientation.equals(180) ? new Rectangle(Geometry.left(antenna_bbox) - 3 - text_dim.width, Geometry.midy(antenna_bbox) - 1 - text_dim.height / 2, text_dim.width, text_dim.height) : (orientation.equals(90) ? new Rectangle(Geometry.midx(antenna_bbox) - text_dim.height / 2, Geometry.bottom(antenna_bbox) + 3, text_dim.height, text_dim.width) : new Rectangle(Geometry.midx(antenna_bbox) - text_dim.height / 2, Geometry.top(antenna_bbox) - 3 - text_dim.width, text_dim.height, text_dim.width)));
        g2d.setColor(Color.black);
        g2d.setFont(new Font(this.theGraphicOptions.NODE_FONT_FACE, 0, this.theGraphicOptions.NODE_FONT_SIZE));
        if (orientation.equals(0) || orientation.equals(180)) {
            g2d.drawString(text, Geometry.left(text_rect), Geometry.bottom(text_rect));
        } else {
            g2d.rotate(-1.5707963267948966);
            g2d.drawString(text, -Geometry.bottom(text_rect), Geometry.right(text_rect));
            g2d.rotate(1.5707963267948966);
        }
    }

    @Override
    public BufferedImage getImage(Collection<Glycan> structures, boolean opaque, boolean show_masses, boolean show_redend, double scale, PositionManager posManager, BBoxManager bboxManager) {
        if (structures == null) {
            structures = new Vector<Glycan>();
        }
        GraphicOptions view_opt = this.theGraphicOptions;
        boolean old_flag = view_opt.SHOW_INFO;
        view_opt.SHOW_INFO = old_flag && scale == 1.0;
        view_opt.setScale(scale * view_opt.SCALE_CANVAS);
        Rectangle all_bbox = this.computeBoundingBoxes(structures, show_masses, show_redend, posManager, bboxManager);
        Dimension d = this.computeSize(all_bbox);
        BufferedImage img = GraphicUtils.createCompatibleImage(d.width, d.height, opaque);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (opaque) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2d.setBackground(Color.white);
            g2d.clearRect(0, 0, d.width, d.height);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2d.setBackground(new Color(255, 255, 255, 0));
        }
        for (Glycan s : structures) {
            this.paint(new DefaultPaintable(g2d), s, null, null, show_masses, show_redend, posManager, bboxManager);
        }
        view_opt.setScale(1.0);
        view_opt.SHOW_INFO = old_flag;
        img.flush();
        return img;
    }
}

