/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ImageRegistry {
    private static Logger logger = Logger.getLogger(ImageRegistry.class);
    private static final String IMAGE_PATH = "icons" + File.separator;
    private static Map<QrtPCRImage, ImageDescriptor> imageCache = new HashMap<QrtPCRImage, ImageDescriptor>();

    public static ImageDescriptor getImageDescriptor(QrtPCRImage image) {
        logger.info((Object)("Get image from qrtpcr plugin : " + (Object)((Object)image)));
        ImageDescriptor imageDescriptor = null;
        if (image != null) {
            imageDescriptor = imageCache.get((Object)image);
            if (imageDescriptor == null) {
                logger.info((Object)"ImageDescriptor not found in cache");
                URL fullPathString = FileLocator.find((Bundle)Platform.getBundle((String)"org.grits.toolbox.entry.qrtpcr"), (IPath)new Path(String.valueOf(IMAGE_PATH) + image.iconName), null);
                logger.info((Object)("Loading image from url : " + fullPathString));
                if (fullPathString != null) {
                    imageDescriptor = ImageDescriptor.createFromURL((URL)fullPathString);
                    imageCache.put(image, imageDescriptor);
                }
            }
        } else {
            logger.error((Object)"Cannot load image from qrtpcr plugin (image name is null)");
        }
        return imageDescriptor;
    }

    public static enum QrtPCRImage {
        PLUGIN_ICON("qrtPCR.png"),
        ADD_ICON("circle-add-icon.png"),
        DELETE_ICON("red-cross-icon.png"),
        DOWNLOAD_ICON("download-arrow.png"),
        SAVE_ICON("save-16.png"),
        UP_ICON("uparrow.png"),
        DOWN_ICON("downarrow.png"),
        FORWARD_ICON("double-arrow-down.png"),
        EXPORT_ICON("excel.png"),
        IMPORT_ICON("import.png"),
        SELECT_ICON("selectall.png"),
        HISTOGRAM_ICON("chart.png"),
        FOLDCHANGE_ICON("statistics.png"),
        SHOW_SELECTED_ICON("search.png"),
        UPDATE_ICON("refresh-icon.png"),
        TICK_ICON("tick.png");

        private String iconName = null;

        private QrtPCRImage(String iconName) {
            this.iconName = iconName;
        }
    }
}

