/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.dialog;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.annotation.dialog.FilterDialog;
import org.grits.toolbox.entry.ms.annotation.glycan.adaptor.MSGlycanAnnotationExportFileAdapter;
import org.grits.toolbox.entry.ms.annotation.glycan.filter.MSGlycanAnnotationFilterSetup;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.FilterSettingLibrary;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterCateogoryPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterPreference;
import org.grits.toolbox.util.structure.glycan.filter.om.Category;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.gui.FilterChangedListener;
import org.grits.toolbox.util.structure.glycan.gui.FilterTableSetup;

public class GlycanFilterDialog
extends FilterDialog
implements FilterChangedListener {
    private static final Logger logger = Logger.getLogger(GlycanFilterDialog.class);
    private List<Filter> preFilters = null;
    FilterTableSetup filterTableSetup;
    FilterSetting filterSetting;
    private Combo cmbSelectFilter;
    private FilterSettingLibrary library;
    private List<Category> filterCategories;
    private Category preferredCategory;

    public GlycanFilterDialog(Shell parentShell) {
        super(parentShell);
        this.loadFilterPreferences();
    }

    protected boolean isResizable() {
        return true;
    }

    private void loadFilterPreferences() {
        try {
            MSGlycanFilterPreference preferences = MSGlycanFilterPreference.getMSGlycanFilterPreferences(MSGlycanFilterPreference.getPreferenceEntity());
            MSGlycanFilterCateogoryPreference categoryPreferences = MSGlycanFilterCateogoryPreference.getMSGlycanFilterCategoryPreferences(MSGlycanFilterCateogoryPreference.getPreferenceEntity());
            if (preferences != null) {
                this.library = preferences.getFilterSettings();
            }
            if (categoryPreferences != null) {
                this.preferredCategory = categoryPreferences.getCategoryPreference();
            }
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            logger.error((Object)"Cannot load filter preference");
        }
    }

    public void setPreFilters(List<Filter> preFilters) {
        this.preFilters = preFilters;
    }

    public void filterChanged() {
        if (this.filterTableSetup != null) {
            this.filterSetting = this.filterTableSetup.getFilterSetting();
        }
    }

    public FilterSetting getFilterSetting() {
        return this.filterSetting;
    }

    public void setFilterSetting(FilterSetting filterSetting) {
        this.filterSetting = filterSetting;
    }

    protected void createFilterTable(Composite parent) {
        this.addSelectFilterItem(parent);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        GridData gd_container = new GridData(16384, 128, true, true, 4, 4);
        gd_container.minimumHeight = 150;
        container.setLayoutData((Object)gd_container);
        this.filterTableSetup = this.filterCategories != null ? new MSGlycanAnnotationFilterSetup(this.filterCategories) : new MSGlycanAnnotationFilterSetup();
        this.filterTableSetup.setFilterList(this.preFilters);
        if (this.preferredCategory != null) {
            ((MSGlycanAnnotationFilterSetup)this.filterTableSetup).setSelectedCategory(this.preferredCategory);
        }
        try {
            this.filterTableSetup.createFilterTableSection(container);
            if (this.filterSetting != null) {
                this.filterTableSetup.setExistingFilters(this.filterSetting);
            }
            this.filterTableSetup.addFilterChangedListener((FilterChangedListener)this);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating the filter table", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error creating the filter table!");
        }
    }

    protected void addSelectFilterItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        Label lblSelectFilter = new Label(parent, 0);
        lblSelectFilter.setText("Current Filters");
        lblSelectFilter.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 3, 1);
        this.cmbSelectFilter = new Combo(parent, 0);
        this.cmbSelectFilter.setLayoutData((Object)gd2);
        this.initStoredFiltersList();
        this.cmbSelectFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GlycanFilterDialog.this.processSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void initStoredFiltersList() {
        this.cmbSelectFilter.removeAll();
        if (this.library != null && this.library.getFilterSettings() != null) {
            for (FilterSetting filter : this.library.getFilterSettings()) {
                this.cmbSelectFilter.add(filter.getName());
            }
        }
    }

    protected void processSelection() {
        if (!this.cmbSelectFilter.getText().trim().equals("")) {
            this.setCurrentFilterValues(this.cmbSelectFilter.getText().trim());
            this.filterSetting = this.filterTableSetup.getFilterSetting();
        }
    }

    protected void setCurrentFilterValues(String selFilterName) {
        if (selFilterName == null) {
            return;
        }
        FilterSetting selFilter = this.getCurrentFilter(selFilterName);
        if (selFilter == null) {
            return;
        }
        if (this.filterTableSetup != null) {
            this.filterTableSetup.setExistingFilters(selFilter);
        }
    }

    protected FilterSetting getCurrentFilter(String selFilter) {
        if (this.library != null && this.library.getFilterSettings() != null) {
            int i = 0;
            while (i < this.library.getFilterSettings().size()) {
                FilterSetting curFilter = this.library.getFilterSettings().get(i);
                if (curFilter.getName().equals(selFilter)) {
                    return curFilter;
                }
                ++i;
            }
        }
        return null;
    }

    protected void okPressed() {
        if (this.exportFileAdapter != null) {
            ((MSGlycanAnnotationExportFileAdapter)this.exportFileAdapter).setFilterSetting(this.getFilterSetting());
            this.exportFileAdapter.setFilterColumn(this.getFilterKey());
            this.exportFileAdapter.setTopHits(this.getNumTopHits());
            this.exportFileAdapter.setThresholdValue(this.getThresholdValue());
        }
        super.okPressed();
    }

    public void setCategories(List<Category> categories) {
        this.filterCategories = categories;
    }
}

