/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LinkageMatcher;
import org.eurocarbdb.application.glycanbuilder.ResAngle;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class ResiduePlacement {
    private String rule;
    private LinkageMatcher matcher;
    private ResAngle[] positions;
    private boolean on_border;
    private boolean sticky;

    public ResiduePlacement() {
        this.rule = "";
        this.matcher = LinkageMatcher.parse(this.rule);
        this.positions = new ResAngle[1];
        this.on_border = false;
        this.sticky = false;
    }

    public ResiduePlacement(ResAngle _position, boolean _on_border, boolean _sticky) {
        this.rule = "";
        this.matcher = LinkageMatcher.parse(this.rule);
        this.positions = new ResAngle[1];
        this.positions[0] = _position;
        this.on_border = _on_border;
        this.sticky = _sticky;
    }

    public ResiduePlacement(String init) throws Exception {
        Vector<String> tokens = TextUtils.tokenize(init, "\t");
        if (tokens.size() != 4) {
            throw new Exception("Invalid string format: " + init);
        }
        this.rule = tokens.elementAt(0);
        this.matcher = LinkageMatcher.parse(this.rule);
        this.positions = ResiduePlacement.parsePositions(tokens.elementAt(1));
        this.on_border = ResiduePlacement.parseBoolean(tokens.elementAt(2));
        this.sticky = ResiduePlacement.parseBoolean(tokens.elementAt(3));
    }

    private static boolean parseBoolean(String str) {
        return str.equals("true") || str.equals("yes");
    }

    private static ResAngle[] parsePositions(String init) throws Exception {
        Vector<String> tokens = TextUtils.tokenize(init, ",");
        ResAngle[] ret = new ResAngle[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            ret[i] = new ResAngle(tokens.elementAt(i));
        }
        return ret;
    }

    public ResiduePlacement clone() {
        ResiduePlacement ret = new ResiduePlacement();
        ret.rule = this.rule;
        ret.matcher = LinkageMatcher.parse(this.rule);
        ret.positions = this.positions;
        ret.on_border = this.on_border;
        ret.sticky = this.sticky;
        return ret;
    }

    public ResiduePlacement getIfSticky() {
        ResiduePlacement ret = new ResiduePlacement();
        ret.rule = this.rule;
        ret.matcher = this.matcher;
        if (this.on_border) {
            ret.on_border = true;
            ret.positions = this.positions;
        } else {
            ret.on_border = false;
            ret.positions = new ResAngle[]{new ResAngle(0)};
        }
        ret.sticky = true;
        return ret;
    }

    public String getRule() {
        return this.rule;
    }

    public LinkageMatcher getMatcher() {
        return this.matcher;
    }

    public boolean matches(Residue parent, Linkage link, Residue child) {
        return this.matcher.matches(parent, link, child);
    }

    public ResAngle[] getPositions() {
        return this.positions;
    }

    public String getStringPositions() {
        StringBuilder ss = new StringBuilder();
        for (int i = 0; i < this.positions.length; ++i) {
            if (i > 0) {
                ss.append(",");
            }
            ss.append(this.positions[i]);
        }
        return ss.toString();
    }

    public boolean hasPosition(ResAngle pos) {
        for (int i = 0; i < this.positions.length; ++i) {
            if (!this.positions[i].equals(pos)) continue;
            return true;
        }
        return false;
    }

    public boolean isOnBorder() {
        return this.on_border;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public String toString() {
        return this.rule + " " + this.getStringPositions() + " " + this.on_border + " " + this.sticky;
    }
}

