/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.handler;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.entry.ms.adaptor.MassSpecExportFileAdapter;
import org.grits.toolbox.entry.ms.dialog.MassSpecExportDialog;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecExportCommand {
    private static final Logger logger = Logger.getLogger(MassSpecExportCommand.class);
    private Entry entry = null;
    private MassSpecTableDataObject tableDataObject = null;
    @Inject
    static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;
    @Inject
    IEclipseContext context;

    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, @Named(value="activeShell") @Named(value="activeShell") Shell shell) {
        if (this.checkIfCorrectEntryChosen(object)) {
            this.createSimianExportDialog(shell);
        } else {
            ErrorUtils.createWarningMessageBox((Shell)shell, (String)"Invalid Entry", (String)"An MS entry must be open and active in order to export.");
        }
        return null;
    }

    private void createSimianExportDialog(Shell activeShell) {
        MassSpecExportFileAdapter adapter = new MassSpecExportFileAdapter();
        MassSpecExportDialog dialog = new MassSpecExportDialog(PropertyHandler.getModalDialog((Shell)activeShell), adapter);
        dialog.setMassSpecEntry(this.entry);
        dialog.setTableDataObject(this.tableDataObject);
        dialog.open();
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object) {
        return this.checkIfCorrectEntryChosen(object);
    }

    private boolean checkIfCorrectEntryChosen(Object selection) {
        Entry selectedEntry = null;
        if (selection instanceof Entry) {
            selectedEntry = (Entry)selection;
        } else if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)((StructuredSelection)selection).getFirstElement();
        }
        if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
        }
        if (selectedEntry == null) {
            return false;
        }
        this.entry = selectedEntry;
        if (this.entry.getProperty().getType().equals("org.grits.toolbox.property.ms")) {
            MassSpecTableDataObject data;
            MassSpecMultiPageViewer viewer;
            block9: {
                try {
                    viewer = MassSpecMultiPageViewer.getActiveViewerForEntry(this.context, this.entry);
                    if (viewer != null) break block9;
                    return false;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            this.tableDataObject = data = (MassSpecTableDataObject)viewer.getScansView().getViewBase().getNatTable().getGRITSTableDataObject();
            return true;
        }
        return false;
    }
}

