/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.GeneralSettings;

public class SettingsHandler {
    public static final String settingsFile = "settings.xml";

    public static void writeSettings(GeneralSettings settings) throws Exception {
        String file = String.valueOf(PropertyHandler.getVariable("configuration_location")) + File.separator + settingsFile;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GeneralSettings.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)settings, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
    }

    public static GeneralSettings readSettings() throws Exception {
        GeneralSettings settings = null;
        String file = String.valueOf(PropertyHandler.getVariable("configuration_location")) + File.separator + settingsFile;
        FileInputStream inputStream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GeneralSettings.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        settings = (GeneralSettings)unmarshaller.unmarshal((Reader)reader);
        return settings;
    }
}

