/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.part;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectDetailsHandler;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.property.WorkspaceProperty;
import org.grits.toolbox.core.datamodel.property.project.ProjectDetails;
import org.grits.toolbox.core.projectexplorer.filter.ClosedProjectsFilter;
import org.grits.toolbox.core.projectexplorer.filter.KeywordFilter;
import org.grits.toolbox.core.projectexplorer.filter.ProjectFilter;
import org.grits.toolbox.core.projectexplorer.part.ProjectExplorerLabelProvider;
import org.grits.toolbox.core.projectexplorer.part.ProjectExplorerViewContentProvider;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.utilShare.sort.EntryComparator;

public class ProjectExplorerPart {
    private static final Logger logger = Logger.getLogger(ProjectExplorerPart.class);
    public static final String PART_ID = "org.grits.toolbox.core.part.projectexplorer";
    public static final String POPUP_MENU_ID = "org.grits.toolbox.core.popupmenu.projectexplorer";
    private TreeViewer treeViewer = null;
    List<ProjectFilter> currentFilters = new ArrayList<ProjectFilter>();
    @Inject
    private ESelectionService selectionService = null;
    @Inject
    private EHandlerService eHandlerService = null;
    @Inject
    private ECommandService eCommandService = null;
    @Inject
    private IGritsDataModelService dataModelService = null;
    @Inject
    @Named(value="grits_workspace_entry")
    private Entry workspaceEntry = null;

    @Inject
    public ProjectExplorerPart() {
    }

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService, MPart part) {
        logger.info((Object)"Creating Project Explorer part");
        List items = part.getToolbar().getChildren();
        for (MToolBarElement mToolBarElement : items) {
            if (!(mToolBarElement instanceof MToolItem)) continue;
            ((MToolItem)mToolBarElement).setSelected(false);
        }
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        FilteredTree tree = new FilteredTree(parent, 770, filter, true, true);
        this.treeViewer = tree.getViewer();
        this.treeViewer.setContentProvider((IContentProvider)new ProjectExplorerViewContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProjectExplorerLabelProvider());
        this.treeViewer.setInput((Object)this.workspaceEntry);
        this.treeViewer.setComparator((ViewerComparator)new EntryComparator());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectExplorerPart.this.setSelection((StructuredSelection)event.getSelection());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                ProjectExplorerPart.this.setSelection(selection);
                String commandId = "org.grits.toolbox.core.command.projectexplorer.entry.view";
                if (selection.size() == 1 && selection.getFirstElement() instanceof Entry && ((Entry)selection.getFirstElement()).getProperty() instanceof ProjectProperty && !((ProjectProperty)((Entry)selection.getFirstElement()).getProperty()).isOpen()) {
                    commandId = "org.grits.toolbox.core.command.projectexplorer.open.project";
                }
                ProjectExplorerPart.this.eHandlerService.executeHandler(ProjectExplorerPart.this.eCommandService.createCommand(commandId, null));
            }
        });
        menuService.registerContextMenu((Object)this.treeViewer.getControl(), POPUP_MENU_ID);
        logger.info((Object)"Creating Project Explorer part");
    }

    protected void setSelection(StructuredSelection structuredSelection) {
        if (structuredSelection != null) {
            if (structuredSelection.size() == 1) {
                this.selectionService.setSelection(structuredSelection.getFirstElement());
            } else {
                this.selectionService.setSelection((Object)structuredSelection);
            }
        }
        this.dataModelService.setLastSelection(structuredSelection);
    }

    @PreDestroy
    public void preDestroy() {
    }

    @Focus
    public void onFocus() {
        this.treeViewer.getControl().setFocus();
    }

    @Optional
    @Inject
    public void refresh(@UIEventTopic(value="grits_data_model_changed") Entry entry) {
        if (entry != null) {
            if ("org.grits.toolbox.property.project".equals(entry.getProperty().getType()) && !((ProjectProperty)entry.getProperty()).getOpen()) {
                this.treeViewer.collapseToLevel((Object)entry, 1);
            }
            Object[] expandedElements = this.treeViewer.getExpandedElements();
            this.treeViewer.refresh((Object)entry);
            this.treeViewer.setExpandedElements(expandedElements);
        } else {
            this.treeViewer.refresh();
        }
    }

    @Optional
    @Inject
    public void resetSelection(@UIEventTopic(value="grits_entry_selected") Object object) {
        if (object instanceof Entry) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(object));
        } else if (object instanceof StructuredSelection) {
            this.treeViewer.setSelection((ISelection)((StructuredSelection)object));
        }
    }

    public void filter(ProjectFilter filter, boolean apply) {
        if (apply) {
            class FilterProcess
            implements IRunnableWithProgress {
                Entry filteredEntry;
                private final /* synthetic */ ProjectFilter val$filter;

                FilterProcess(ProjectFilter projectFilter) {
                    this.val$filter = projectFilter;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Entry currentInput = (Entry)ProjectExplorerPart.this.treeViewer.getInput();
                    int totalWork = 1;
                    if (currentInput != null && currentInput.getChildren() != null) {
                        totalWork = currentInput.getChildren().size();
                    }
                    monitor.beginTask("Filtering...", totalWork);
                    if (this.val$filter instanceof ClosedProjectsFilter) {
                        this.filteredEntry = ProjectExplorerPart.this.filterChildrenForOpen(currentInput, monitor);
                    } else if (this.val$filter instanceof KeywordFilter) {
                        this.filteredEntry = ProjectExplorerPart.this.filterChildrenByKeyword(currentInput, ((KeywordFilter)this.val$filter).getKeywords(), monitor);
                    }
                    monitor.done();
                }

                Entry getFilteredEntry() {
                    return this.filteredEntry;
                }
            }
            FilterProcess p = new FilterProcess(filter);
            try {
                new ProgressMonitorDialog(new Shell()).run(true, false, (IRunnableWithProgress)p);
                this.treeViewer.setInput((Object)p.getFilteredEntry());
                this.treeViewer.refresh();
                filter.setApplied(true);
                if (!this.currentFilters.contains(filter)) {
                    this.currentFilters.add(filter);
                }
            }
            catch (InvocationTargetException e) {
                logger.error((Object)"Error while filtering", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error((Object)"Error while filtering", (Throwable)e);
            }
        } else {
            this.treeViewer.setInput((Object)this.workspaceEntry);
            filter.setApplied(false);
            for (ProjectFilter f : this.currentFilters) {
                if (f == filter || !f.isApplied()) continue;
                this.filter(f, true);
            }
            this.treeViewer.refresh();
        }
    }

    public Entry filterChildrenForOpen(Entry workspaceEntry, IProgressMonitor monitor) {
        Entry newEntry = new Entry();
        WorkspaceProperty prop = new WorkspaceProperty();
        newEntry.setProperty(prop);
        if (workspaceEntry != null && workspaceEntry.getChildren() != null) {
            for (Entry childEntry : workspaceEntry.getChildren()) {
                if (childEntry.getProperty() != null && childEntry.getProperty().getType().equals("org.grits.toolbox.property.project") && ((ProjectProperty)childEntry.getProperty()).isOpen()) {
                    newEntry.addChild(childEntry);
                }
                monitor.worked(1);
            }
        }
        return newEntry;
    }

    public Entry filterChildrenByKeyword(Entry workspaceEntry, List<String> keywords, IProgressMonitor monitor) {
        Entry newEntry = new Entry();
        WorkspaceProperty prop = new WorkspaceProperty();
        newEntry.setProperty(prop);
        if (workspaceEntry != null && workspaceEntry.getChildren() != null) {
            for (Entry childEntry : workspaceEntry.getChildren()) {
                if (childEntry.getProperty() != null && childEntry.getProperty().getType().equals("org.grits.toolbox.property.project")) {
                    try {
                        ProjectDetails projectDetails = ProjectDetailsHandler.getProjectDetails(childEntry);
                        boolean keyWordMatch = false;
                        for (String keyword : keywords) {
                            for (String projectKeyword : projectDetails.getKeywords()) {
                                if (!keyword.equals(projectKeyword)) continue;
                                keyWordMatch = true;
                                break;
                            }
                            if (!keyWordMatch) continue;
                            newEntry.addChild(childEntry);
                            break;
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("Cannot load project details for project: " + childEntry.getDisplayName()), (Throwable)e);
                    }
                }
                monitor.worked(1);
            }
        }
        return newEntry;
    }
}

