/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.jdom.Element;

public class UtilityPreferenceValue {
    private static final String VALUE_SEPERATOR = "||||";
    private static final String SELECTION_INDICATOR = "~~";
    private static final String PREVIOUS_VALUE_SEPERATOR = "|";

    public static Set<String> getPreferenceValues(PreferenceEntity preferenceEntity) {
        HashSet<String> valueSet = new HashSet<String>();
        if (preferenceEntity.getValue() != null && !preferenceEntity.getValue().isEmpty()) {
            String[] writtenValues;
            String[] stringArray = writtenValues = preferenceEntity.getValue().split(Pattern.quote(VALUE_SEPERATOR));
            int n = writtenValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                valueSet.add(value);
                ++n2;
            }
        }
        return valueSet;
    }

    public static Map<String, Boolean> getPreferenceValuesWithSelection(PreferenceEntity preferenceEntity) {
        HashMap<String, Boolean> valueSelectionMap = new HashMap<String, Boolean>();
        if (preferenceEntity.getValue() != null && !preferenceEntity.getValue().isEmpty()) {
            String[] writtenValues;
            String[] stringArray = writtenValues = preferenceEntity.getValue().split(Pattern.quote(VALUE_SEPERATOR));
            int n = writtenValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value.startsWith(SELECTION_INDICATOR) && value.endsWith(SELECTION_INDICATOR) && value.length() > 2 * SELECTION_INDICATOR.length()) {
                    valueSelectionMap.put(value.substring(SELECTION_INDICATOR.length(), value.lastIndexOf(SELECTION_INDICATOR)), true);
                } else {
                    valueSelectionMap.put(value, false);
                }
                ++n2;
            }
        }
        return valueSelectionMap;
    }

    public static String getPreferenceValueString(Set<String> allValues, String selectedValue) {
        String value = "";
        for (String v : allValues) {
            if (v.isEmpty()) continue;
            value = String.valueOf(value) + VALUE_SEPERATOR;
            value = String.valueOf(value) + (v.equals(selectedValue) ? SELECTION_INDICATOR + v + SELECTION_INDICATOR : v);
        }
        value = value.isEmpty() ? value : value.substring(VALUE_SEPERATOR.length());
        return value;
    }

    public static String getPreferenceValueString(Set<String> selectedValues, Set<String> unselectedValues) {
        String value = "";
        for (String v : selectedValues) {
            value = String.valueOf(value) + (v.isEmpty() ? "" : "||||~~" + v + SELECTION_INDICATOR);
        }
        for (String v : unselectedValues) {
            value = String.valueOf(value) + (v.isEmpty() ? "" : VALUE_SEPERATOR + v);
        }
        value = value.isEmpty() ? value : value.substring(VALUE_SEPERATOR.length());
        return value;
    }

    public static Set<String> getPreversioningValues(Element preferenceElement) {
        String value;
        HashSet<String> values = new HashSet<String>();
        if (preferenceElement != null && preferenceElement.getAttribute("values") != null && (value = preferenceElement.getAttributeValue("values")) != null && !value.isEmpty()) {
            String[] valueArray;
            String[] stringArray = valueArray = value.split(Pattern.quote(PREVIOUS_VALUE_SEPERATOR));
            int n = valueArray.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                values.add(v);
                ++n2;
            }
        }
        return values;
    }

    public static String getPreversioningSelected(Element preferenceElement) {
        return preferenceElement != null && preferenceElement.getAttribute("selected") != null ? preferenceElement.getAttributeValue("selected") : null;
    }

    public static String getPreversioningValue(Element preferenceElement) {
        return preferenceElement != null && preferenceElement.getAttribute("value") != null ? preferenceElement.getAttributeValue("value") : null;
    }
}

