/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.grits.toolbox.editor.samplemanager.ManagementEditor;
import org.grits.toolbox.editor.samplemanager.input.DescriptorTypeClassesWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.general.SectionUtility;
import org.grits.toolbox.editor.samplemanager.pages.rightside.RightSideSection;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.listeners.AbundanceListener;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.listeners.CheckboxSelectionListener;
import org.grits.toolbox.editor.samplemanager.util.CategoryURIComparator;

public abstract class RightSideDescriptorTypeSection
extends RightSideSection {
    private Logger logger = Logger.getLogger(RightSideDescriptorTypeSection.class);
    private Label abundanceLabel = null;
    private Spinner abundanceSpinner = null;
    private AbundanceListener abundanceModifyListener = null;
    private List<Button> categoriesCheckboxes = null;
    private HashMap<String, String> categories;
    private HashMap<String, String> categoriesCheckBoxToURI;
    private Composite categorySectionComposite;

    public RightSideDescriptorTypeSection(AbstractManagementPage page) {
        super(page);
    }

    @Override
    protected void createSpecificPart() {
        this.logger.debug((Object)"- START : Creating specific part in abstract Descriptor type section.");
        try {
            this.abundanceLabel = this.toolkit.createLabel(this.rightSideComposite, "Default Max Occurrence");
            this.abundanceLabel.setFont(this.boldFont);
            this.abundanceSpinner = new Spinner(this.rightSideComposite, 2056);
            this.abundanceModifyListener = new AbundanceListener(this.page);
            this.abundanceSpinner.addModifyListener((ModifyListener)this.abundanceModifyListener);
            GridData labelGridData = new GridData();
            labelGridData.grabExcessHorizontalSpace = false;
            labelGridData.horizontalSpan = 2;
            this.abundanceSpinner.setLayoutData((Object)labelGridData);
            this.toolkit.createLabel(this.rightSideComposite, "( Select 0 for unbounded/infinite maxOccurence )");
            Section categorySection = SectionUtility.createSectionForCategory(this.toolkit, this.page.getRightComposite(), "Categories");
            this.categorySectionComposite = this.toolkit.createComposite((Composite)categorySection, 4);
            this.categorySectionComposite.setLayoutData((Object)new TableWrapData(256));
            GridLayout compositeLayout = new GridLayout(2, true);
            compositeLayout.marginLeft = 10;
            compositeLayout.marginBottom = 5;
            compositeLayout.marginRight = 10;
            this.categorySectionComposite.setLayout((Layout)compositeLayout);
            categorySection.setClient((Control)this.categorySectionComposite);
            this.categoriesCheckboxes = new ArrayList<Button>();
            this.categories = ((ManagementEditor)this.page.getEditor()).getAllCategoriesURILabelMap();
            this.categoriesCheckBoxToURI = new HashMap();
            ArrayList<String> sortedCategory = new ArrayList<String>(this.categories.keySet());
            Collections.sort(sortedCategory, new CategoryURIComparator());
            for (String category : sortedCategory) {
                Button categoriesCheckbox = this.toolkit.createButton(this.categorySectionComposite, this.categories.get(category), 32);
                categoriesCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener(this.page, category));
                this.categoriesCheckboxes.add(categoriesCheckbox);
                this.categoriesCheckBoxToURI.put(categoriesCheckbox.toString(), category);
                GridData layoutData = new GridData(32);
                layoutData.horizontalSpan = 1;
                layoutData.widthHint = 360;
                categoriesCheckbox.setLayoutData((Object)layoutData);
            }
            this.createMoreSpecificPart();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.logger.debug((Object)"- END   : Creating specific part in abstract Descriptor type section.");
    }

    protected abstract void createMoreSpecificPart();

    @Override
    protected void resetSpecificPart() {
        this.logger.debug((Object)"- START : Resetting right side abstract Descriptor type section for the selection.");
        try {
            DescriptorTypeClassesWithFeatures selectedDescriptorTypeObject = (DescriptorTypeClassesWithFeatures)this.selectedObject;
            this.abundanceSpinner.setEnabled(this.editable);
            this.abundanceModifyListener.setSelectedObject(selectedDescriptorTypeObject);
            if (selectedDescriptorTypeObject.getMaxOccurrence() != null) {
                this.abundanceSpinner.setSelection(selectedDescriptorTypeObject.getMaxOccurrence().intValue());
            } else {
                this.abundanceSpinner.setSelection(0);
            }
            boolean selected = false;
            Listener[] listeners = null;
            TypedListener typedListener = null;
            CheckboxSelectionListener checkboxListener = null;
            for (Button checkbox : this.categoriesCheckboxes) {
                listeners = checkbox.getListeners(13);
                typedListener = (TypedListener)listeners[0];
                checkboxListener = (CheckboxSelectionListener)typedListener.getEventListener();
                checkboxListener.setSelectedObject(selectedDescriptorTypeObject);
                for (String category : this.categories.keySet()) {
                    selected = false;
                    if (!this.categoriesCheckBoxToURI.get(checkbox.toString()).equals(category) || selectedDescriptorTypeObject.getCategories() == null || !selectedDescriptorTypeObject.getCategories().contains(category)) continue;
                    selected = true;
                    break;
                }
                checkbox.setSelection(selected);
                checkbox.setEnabled(this.editable);
            }
            this.resetMoreSpecificPart();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.logger.debug((Object)"- END   : Resetting right side abstract Descriptor type section for the selection.");
    }

    protected abstract void resetMoreSpecificPart();
}

