/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.dialogs.addunit;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.grits.toolbox.editor.samplemanager.dialogs.addunit.MeasurementUnitContentProvider;
import org.grits.toolbox.editor.samplemanager.dialogs.addunit.MeasurementUnitLabelProvider;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;

public class AddMeasurementUnitDialog
extends Dialog {
    private OntModel unitOntologyModel;
    private Text searchFieldText;
    private TreeViewer treeViewer;
    private Text descriptionText;
    private List<OntClass> searchResults = new ArrayList<OntClass>();
    private MeasurementUnit selectedMeasurementUnit = null;
    private List<String> existingURIs;

    public AddMeasurementUnitDialog(Shell parentShell, OntModel unitOntologyModel) {
        super(parentShell);
        this.unitOntologyModel = unitOntologyModel;
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    public MeasurementUnit getSelectedMeasurementUnit() {
        return this.selectedMeasurementUnit;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 0);
        container.getShell().setText("Measurement Unit");
        container.getShell().setImage(ImageRegistry.getImageDescriptor((ImageRegistry.SampleImage)ImageRegistry.SampleImage.EDIT_NAME_ICON).createImage());
        GridData containerData = new GridData(4, 4, false, false);
        containerData.widthHint = 500;
        container.setLayoutData((Object)containerData);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Search an Item");
        label.setLayoutData((Object)new GridData(32));
        this.searchFieldText = new Text(container, 2052);
        GridData searchFieldTextGridData = new GridData(256);
        searchFieldTextGridData.grabExcessHorizontalSpace = true;
        this.searchFieldText.setLayoutData((Object)searchFieldTextGridData);
        Label label2 = new Label(container, 0);
        label2.setText("Matching Items");
        label2.setLayoutData((Object)new GridData(32));
        this.treeViewer = new TreeViewer(container, 2816);
        GridData treeViewertGridData = new GridData(256);
        treeViewertGridData.grabExcessHorizontalSpace = true;
        treeViewertGridData.heightHint = 150;
        this.treeViewer.getTree().setLayoutData((Object)treeViewertGridData);
        this.descriptionText = new Text(container, 2632);
        GridData descriptionTextGridData = new GridData(256);
        descriptionTextGridData.grabExcessHorizontalSpace = true;
        descriptionTextGridData.heightHint = 50;
        this.descriptionText.setLayoutData((Object)descriptionTextGridData);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MeasurementUnitLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new MeasurementUnitContentProvider());
        ViewerFilter searchFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String searchText = AddMeasurementUnitDialog.this.searchFieldText.getText();
                boolean show = false;
                if (element instanceof OntClass) {
                    OntClass ontClass = (OntClass)element;
                    if (!AddMeasurementUnitDialog.this.existingURIs.contains(ontClass.getURI())) {
                        if (searchText.equals("*")) {
                            show = true;
                        } else if (ontClass.getLabel(null).contains(searchText)) {
                            show = true;
                            AddMeasurementUnitDialog.this.searchResults.add(ontClass);
                        } else if (!ontClass.listSubClasses(true).toList().isEmpty()) {
                            for (OntClass subClass : ontClass.listSubClasses(true).toList()) {
                                if (!subClass.getLabel(null).contains(searchText)) continue;
                                show = true;
                                AddMeasurementUnitDialog.this.searchResults.add(subClass);
                            }
                        }
                    }
                }
                return show;
            }
        };
        ViewerFilter[] filters = new ViewerFilter[]{searchFilter};
        this.treeViewer.setFilters(filters);
        List classes = this.unitOntologyModel.listClasses().toList();
        OntClass unitClass = null;
        for (OntClass ontClass : classes) {
            if (!ontClass.getURI().equals("http://purl.obolibrary.org/obo/UO_0000000")) continue;
            unitClass = ontClass;
            break;
        }
        this.treeViewer.setInput(unitClass);
        this.treeViewer.expandAll();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeItem firstSelectedItem;
                if (!AddMeasurementUnitDialog.this.treeViewer.getSelection().isEmpty() && (firstSelectedItem = AddMeasurementUnitDialog.this.treeViewer.getTree().getSelection()[0]).getData() instanceof OntClass) {
                    OntClass ontClass = (OntClass)firstSelectedItem.getData();
                    OntProperty definition = AddMeasurementUnitDialog.this.unitOntologyModel.getOntProperty("http://purl.obolibrary.org/obo/IAO_0000115");
                    List results = AddMeasurementUnitDialog.this.unitOntologyModel.listObjectsOfProperty(ontClass.asResource(), (Property)definition).toList();
                    String comment = "";
                    if (!results.isEmpty()) {
                        comment = ((RDFNode)results.iterator().next()).toString();
                        comment = comment == null ? "" : comment;
                        int index = comment.lastIndexOf("^^http://www.w3.org/2001/XMLSchema");
                        comment = comment.substring(0, index);
                    }
                    AddMeasurementUnitDialog.this.descriptionText.setText(comment);
                    boolean enable = ontClass.listSubClasses(true).toList().isEmpty();
                    AddMeasurementUnitDialog.this.getButton(0).setEnabled(enable);
                }
            }
        });
        this.searchFieldText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddMeasurementUnitDialog.this.getButton(0).setEnabled(false);
                AddMeasurementUnitDialog.this.treeViewer.refresh();
                AddMeasurementUnitDialog.this.treeViewer.expandAll();
                AddMeasurementUnitDialog.this.descriptionText.setText("");
            }
        });
        return comp;
    }

    protected void okPressed() {
        TreeItem firstSelectedItem = this.treeViewer.getTree().getSelection()[0];
        if (firstSelectedItem.getData() instanceof OntClass) {
            OntClass selectedUnit = (OntClass)firstSelectedItem.getData();
            this.selectedMeasurementUnit = new MeasurementUnit();
            this.selectedMeasurementUnit.setUri(selectedUnit.getURI());
            this.selectedMeasurementUnit.setLabel(selectedUnit.getLabel(null));
            super.okPressed();
        } else {
            super.cancelPressed();
        }
    }

    public void setExistingURIs(List<String> existingURIs) {
        this.existingURIs = existingURIs;
    }
}

