/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.databasebot.wizards.createnew;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.tools.databasebot.om.DatabaseBotSettings;
import org.grits.toolbox.tools.databasebot.utils.FileUtils;

public class SourcePage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(SourcePage.class);
    private Button m_radioNoNewStructures = null;
    private Button m_radioFiles = null;
    private Button m_buttonAdd = null;
    private Button m_buttonRemove = null;
    private List m_listFiles = null;

    public SourcePage(ImageDescriptor a_titleImage) {
        super("Structure source", "Source for new structures", a_titleImage);
        this.setDescription("Select the source for the glycan structures that are added to the database.");
    }

    public void createControl(final Composite a_parent) {
        Composite t_container = new Composite(a_parent, 0);
        t_container.setLayout((Layout)new GridLayout(3, false));
        this.m_radioNoNewStructures = new Button(t_container, 16);
        this.m_radioNoNewStructures.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.m_radioNoNewStructures.setText("No new structures");
        this.m_radioFiles = new Button(t_container, 16);
        this.m_radioFiles.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.m_radioFiles.setText("Structures from GWS files");
        Label t_placeholder = new Label(t_container, 0);
        GridData t_gridDataLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        t_gridDataLabel.widthHint = 15;
        t_placeholder.setLayoutData((Object)t_gridDataLabel);
        this.m_listFiles = new List(t_container, 2818);
        this.m_listFiles.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.m_buttonAdd = new Button(t_container, 0);
        this.m_buttonAdd.setText("Browse");
        GridData t_gridButton = new GridData(131072, 128, false, false, 1, 1);
        t_gridButton.widthHint = 100;
        this.m_buttonAdd.setLayoutData((Object)t_gridButton);
        new Label(t_container, 0);
        this.m_buttonRemove = new Button(t_container, 0);
        this.m_buttonRemove.setText("Remove");
        t_gridButton = new GridData(131072, 128, false, false, 1, 1);
        t_gridButton.widthHint = 100;
        this.m_buttonRemove.setLayoutData((Object)t_gridButton);
        this.m_radioNoNewStructures.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent a_event) {
                Button t_button = (Button)a_event.widget;
                if (t_button.getSelection()) {
                    SourcePage.this.m_listFiles.setEnabled(false);
                    SourcePage.this.m_buttonAdd.setEnabled(false);
                    SourcePage.this.m_buttonRemove.setEnabled(false);
                }
            }
        });
        this.m_radioFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent a_event) {
                Button t_button = (Button)a_event.widget;
                if (t_button.getSelection()) {
                    SourcePage.this.m_listFiles.setEnabled(true);
                    SourcePage.this.m_buttonAdd.setEnabled(true);
                    SourcePage.this.m_buttonRemove.setEnabled(true);
                }
            }
        });
        this.m_buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent a_event) {
                SourcePage.this.removeFromList();
            }
        });
        this.m_buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent a_event) {
                try {
                    FileDialog t_dialogOpen = new FileDialog(a_parent.getShell(), 4098);
                    t_dialogOpen.setFilterNames(new String[]{"GlycoWorkbench structure (.gws)", "All files"});
                    t_dialogOpen.setFilterExtensions(new String[]{"*.gws", "*.*"});
                    t_dialogOpen.open();
                    String t_path = t_dialogOpen.getFilterPath();
                    String[] t_files = t_dialogOpen.getFileNames();
                    ArrayList<String> t_invalidFiles = new ArrayList<String>();
                    if (t_files.length > 0 && t_path != null) {
                        String[] stringArray = t_files;
                        int n = t_files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String t_fileName = stringArray[n2];
                            String t_fullFileName = String.valueOf(t_path) + File.separator + t_fileName;
                            if (SourcePage.this.isValidFileGWS(t_fullFileName)) {
                                SourcePage.this.m_listFiles.add(t_fullFileName);
                            } else {
                                t_invalidFiles.add(t_fileName);
                            }
                            ++n2;
                        }
                        if (t_invalidFiles.size() > 0) {
                            StringBuffer t_message = new StringBuffer("The following files are not valid GWS files or contain glycans that can not be loaded:\n");
                            for (String t_string : t_invalidFiles) {
                                t_message.append("\t" + t_string + "\n");
                            }
                            ErrorUtils.createErrorMessageBox((Shell)a_parent.getShell(), (String)"Error loading GWS files", (String)t_message.toString());
                        }
                    }
                }
                catch (Exception e) {
                    logger.fatal((Object)"Unable to add files to the list of GWS files.", (Throwable)e);
                }
            }
        });
        this.m_radioNoNewStructures.setSelection(true);
        this.m_listFiles.setEnabled(false);
        this.m_buttonAdd.setEnabled(false);
        this.m_buttonRemove.setEnabled(false);
        this.setPageComplete(true);
        this.setControl((Control)t_container);
    }

    private void removeFromList() {
        int[] t_indices = this.m_listFiles.getSelectionIndices();
        if (t_indices.length > 0) {
            try {
                this.m_listFiles.remove(t_indices);
            }
            catch (Exception e) {
                logger.error((Object)"Trying to remove from list of files", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidFileGWS(String a_fileName) {
        try {
            String[] t_gwsList;
            String t_gwsMulti = FileUtils.readFile(a_fileName);
            String[] stringArray = t_gwsList = t_gwsMulti.split(";");
            int n = t_gwsList.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String t_gws = stringArray[n2];
                Glycan t_glycan = Glycan.fromString((String)t_gws);
                if (t_glycan == null) {
                    logger.info((Object)("Invalid GWS sequence in file (" + a_fileName + "): " + t_gws));
                    return false;
                }
                t_glycan.computeMass();
                ++n2;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Problem loading GWS file", (Throwable)e);
            return false;
        }
    }

    public void fillCreateDatabaseSettings(DatabaseBotSettings a_settings) {
        if (this.m_radioFiles.getSelection()) {
            a_settings.setGwsFiles(Arrays.asList(this.m_listFiles.getItems()));
        }
    }
}

