/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.io.om;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.file.reader.impl.MzXmlReader;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class MSDataModelFileHandlar {
    private static final Logger logger = Logger.getLogger(MSDataModelFileHandlar.class);

    public static void serializeMethod(Method method, String filename) {
        try {
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(Method.class);
            JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)method, new File(filename));
        }
        catch (JAXBException e) {
            logger.error((Object)"An error during serializing method object.", (Throwable)e);
        }
    }

    public static Method readMethodXML(String filename) {
        try {
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(Method.class);
            JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Unmarshaller um = context.createUnmarshaller();
            Method method = (Method)um.unmarshal((Reader)new FileReader(filename));
            return method;
        }
        catch (JAXBException e) {
            logger.error((Object)"An error during deserializing Method object.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Not found Method XML file .", (Throwable)e);
        }
        return null;
    }

    public static Map<Integer, List<Integer>> getScanNumberToSubscanNumbersFromMzXML(String a_strFilename) {
        TreeMap<Integer, List<Integer>> t_mapScanToSubscans = new TreeMap<Integer, List<Integer>>();
        MzXmlReader t_mzXMLParser = new MzXmlReader();
        int t_nMaxScan = MzXmlReader.getMaxScanNumber((String)a_strFilename);
        int t_iScanNum = 0;
        while (t_iScanNum < t_nMaxScan) {
            List t_lPreScans = t_mzXMLParser.readMzXmlFile(a_strFilename, -1, -1, t_iScanNum);
            if (!t_lPreScans.isEmpty()) {
                Scan t_scan = null;
                for (Scan t_scan0 : t_lPreScans) {
                    if (t_scan0.getScanNo() != t_iScanNum) continue;
                    t_scan = t_scan0;
                    break;
                }
                if (!t_mapScanToSubscans.containsKey(t_iScanNum)) {
                    t_mapScanToSubscans.put(t_iScanNum, new ArrayList());
                }
                if (t_scan.getSubScans() != null && !t_scan.getSubScans().isEmpty()) {
                    ((List)t_mapScanToSubscans.get(t_iScanNum)).addAll(t_scan.getSubScans());
                }
            }
            ++t_iScanNum;
        }
        return t_mapScanToSubscans;
    }

    public static List<Scan> readAllScansFromMzXML(String a_strFilename) {
        List t_lMSnScans;
        ArrayList<Scan> t_lScans = new ArrayList<Scan>();
        MzXmlReader t_mzXMLParser = new MzXmlReader();
        int t_nMS = 1;
        while (!(t_lMSnScans = t_mzXMLParser.readMzXmlFile(a_strFilename, t_nMS, -1, -1)).isEmpty()) {
            t_lScans.addAll(t_lMSnScans);
            ++t_nMS;
        }
        Collections.sort(t_lScans, new Comparator<Scan>(){

            @Override
            public int compare(Scan o1, Scan o2) {
                if (o1.getScanNo() < o2.getScanNo()) {
                    return -1;
                }
                if (o1.getScanNo() > o2.getScanNo()) {
                    return 1;
                }
                return 0;
            }
        });
        return t_lScans;
    }

    public static List<Scan> readNumberedScansFromMzXML(String a_strFilename) {
        ArrayList<Scan> t_lScans = new ArrayList<Scan>();
        MzXmlReader t_mzXMLparser = new MzXmlReader();
        int t_nMaxScanNum = MzXmlReader.getMaxScanNumber((String)a_strFilename);
        System.out.println("Total scan number: " + t_nMaxScanNum);
        int t_iScanNum = 1;
        while (t_iScanNum <= t_nMaxScanNum) {
            List t_lPreScans = t_mzXMLparser.readMzXmlFile(a_strFilename, -1, -1, t_iScanNum);
            if (t_lPreScans.isEmpty()) {
                System.out.println("Empty!!");
            } else {
                for (Scan t_scan : t_lPreScans) {
                    if (t_scan.getScanNo() != t_iScanNum) {
                        System.out.println("Scan numbers are not match: " + t_scan.getScanNo() + " vs " + t_iScanNum);
                        continue;
                    }
                    t_lScans.add(t_scan);
                    System.out.println("Scan number: " + t_scan.getScanNo());
                    System.out.println("Number of peaks: " + t_scan.getPeaklist().size());
                    if (t_scan.getPrecursor() != null) {
                        System.out.println("Precursor mz: " + t_scan.getPrecursor().getMz());
                    }
                    System.out.println("MS level: " + t_scan.getMsLevel());
                    System.out.println("Most abundant peak: " + t_scan.getMostAbundantPeak());
                    System.out.println("Is there parent scan: " + t_scan.getParentScan());
                    System.out.println();
                }
            }
            ++t_iScanNum;
        }
        return t_lScans;
    }

    private static void checkPeaks(Scan a_scan) {
        List t_lPeak = a_scan.getPeaklist();
        Collections.sort(t_lPeak, new Comparator<Peak>(){

            @Override
            public int compare(Peak o1, Peak o2) {
                if (o1.getIntensity() > o2.getIntensity()) {
                    return -1;
                }
                if (o1.getIntensity() < o2.getIntensity()) {
                    return 1;
                }
                return 0;
            }
        });
        Peak t_peak = (Peak)t_lPeak.get(0);
        double t_dMaxIntensity = t_peak.getIntensity();
        int i = 0;
        while (t_peak.getIntensity() / t_dMaxIntensity > 0.01) {
            System.out.println(" -> " + t_peak.getMz() + "\t" + t_peak.getIntensity() / t_dMaxIntensity);
            t_peak = (Peak)t_lPeak.get(++i);
        }
    }
}

