/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.annotation.process;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.tools.gsl.dango.DANGOAnnotation;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressHandler;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class DANGOWorker
extends GRITSWorker {
    private static final Logger logger = Logger.getLogger(DANGOWorker.class);
    private DANGOAnnotation m_dango;
    protected IProgressThreadHandler m_progressThreadHandler;
    protected IProgressHandler m_progressHandler;

    public DANGOWorker(DANGOAnnotation dango, IProgressHandler progressHandler, IProgressThreadHandler progressThreadHandler, List<IProgressListener> progressMajors, List<IProgressListener> progressDANGOAnnotationMinors) {
        this.m_dango = dango;
        this.m_progressThreadHandler = progressThreadHandler;
        this.setProgressListeners(progressMajors);
        this.m_progressHandler = progressHandler;
        dango.setProgressListeners(progressDANGOAnnotationMinors);
    }

    public int doWork() {
        try {
            this.setMaxValue(3);
            this.updateListeners("Initializing...", 0);
            CancelableThread s1 = this.getInitializeProcess();
            int iRes = this.runProcess(s1);
            if (s1.isCanceled()) {
                return GRITSProcessStatus.CANCEL;
            }
            if (iRes != GRITSProcessStatus.OK) {
                return iRes;
            }
            this.updateListeners("Performing DANGO annotation...", 1);
            CancelableThread s3 = this.getProcessScansProcess();
            iRes = this.runProcess(s3);
            if (s3.isCanceled()) {
                return GRITSProcessStatus.CANCEL;
            }
            this.updateListeners("Archiving annotation results...", 2);
            CancelableThread s4 = this.getArchiveProcess();
            iRes = this.runProcess(s4);
            if (s4.isCanceled()) {
                return GRITSProcessStatus.CANCEL;
            }
            this.updateListeners("Done!", 3);
            return iRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error in annotateGlycanStructure", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected int runProcess(CancelableThread cp) {
        try {
            cp.setProgressThreadHandler(this.m_progressThreadHandler);
            this.m_progressHandler.setThread(cp);
            cp.start();
            while (!cp.isCanceled() && !cp.isFinished() && cp.isAlive()) {
                Display.getDefault().readAndDispatch();
            }
            if (cp.isCanceled()) {
                this.m_dango.setCanceled(true);
                cp.interrupt();
                return GRITSProcessStatus.CANCEL;
            }
            return GRITSProcessStatus.OK;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in runProcess", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected CancelableThread getInitializeProcess() {
        try {
            CancelableThread cp = new CancelableThread(){

                public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                    logger.debug((Object)"Starting job: getInitializeProcess");
                    try {
                        DANGOWorker.this.m_dango.initialize();
                        return true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            };
            return cp;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in getInitializeProcess", (Throwable)ex);
            return null;
        }
    }

    protected CancelableThread getProcessScansProcess() {
        try {
            CancelableThread cp = new CancelableThread(){

                public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                    logger.debug((Object)"Starting job: processScans");
                    try {
                        int iRes = DANGOWorker.this.m_dango.processAnnotation();
                        if (iRes == GRITSProcessStatus.ERROR) {
                            logger.info((Object)"An error has occurred during processing scans");
                        }
                        return true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            };
            return cp;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in getProcessScansProcess", (Throwable)ex);
            return null;
        }
    }

    private CancelableThread getArchiveProcess() {
        try {
            CancelableThread cp = new CancelableThread(){

                public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                    logger.debug((Object)"Starting job: getArchiveProcess");
                    try {
                        if (!DANGOWorker.this.m_dango.archiveData()) {
                            logger.info((Object)"An error has occurred during archiving data");
                        }
                        return true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            };
            return cp;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in getArchiveProcess", (Throwable)ex);
            return null;
        }
    }
}

