/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.io;

import java.io.IOException;
import java.util.ArrayList;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.archive.property.ArchiveProperty;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class ArchivePropertyWriter
implements PropertyWriter {
    public void write(Property property, Element propertyElement) throws IOException {
        ArchiveProperty archiveProperty;
        if (property instanceof ArchiveProperty) {
            archiveProperty = (ArchiveProperty)property;
            if (archiveProperty.getArchiveFile() == null || archiveProperty.getArchiveFile().getName() == null) {
                throw new IOException("Archive property could not be added as its archive file is missing.");
            }
        } else {
            throw new IOException("This property is not a Archive Property");
        }
        Element fileElement = new Element("file");
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("name", archiveProperty.getArchiveFile().getName()));
        attributes.add(new Attribute("version", "1.0"));
        attributes.add(new Attribute("type", "archive_folder"));
        fileElement.setAttributes(attributes);
        propertyElement.setContent((Content)fileElement);
    }
}

