/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.grits.toolbox.tools.glycanbuilder.core.io.parser.GWSParser;
import org.grits.toolbox.tools.glycanbuilder.core.workspace.BuilderWorkspaceSWT;

public class ClipUtils {
    private static String strGWS = null;

    public static void copyImageToClipboad(Image img) {
        if (img == null || img.isDisposed()) {
            return;
        }
        Clipboard cb = new Clipboard(Display.getCurrent());
        cb.setContents(new Object[]{img.getImageData()}, new Transfer[]{ImageTransfer.getInstance()});
        cb.dispose();
    }

    public static ImageData getImageDataFromClipboard() {
        Clipboard cb = new Clipboard(Display.getCurrent());
        ImageData data = (ImageData)cb.getContents((Transfer)ImageTransfer.getInstance());
        cb.dispose();
        return data;
    }

    public static Image getImageFromClipboard() {
        ImageData data = ClipUtils.getImageDataFromClipboard();
        Image img = new Image((Device)Display.getCurrent(), data);
        return img;
    }

    public static void copyTextToClipboad(String txt) {
        if (txt == null || txt.isEmpty()) {
            return;
        }
        if (txt.contains("\r\n")) {
            txt = txt.replace("\r\n", "\n");
        }
        String txtNew = "";
        String[] stringArray = txt.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!txtNew.isEmpty()) {
                txtNew = String.valueOf(txtNew) + System.lineSeparator();
            }
            txtNew = String.valueOf(txtNew) + line;
            ++n2;
        }
        txt = txtNew;
        Clipboard cb = new Clipboard(Display.getCurrent());
        cb.setContents(new Object[]{txt}, new Transfer[]{TextTransfer.getInstance()});
        cb.dispose();
    }

    public static String getTextFromClipboad() {
        Clipboard cb = new Clipboard(Display.getCurrent());
        String txt = (String)cb.getContents((Transfer)TextTransfer.getInstance());
        cb.dispose();
        return txt;
    }

    public static void copyToClipboard(List<Glycan> lGlycans, BuilderWorkspaceSWT bws) {
        strGWS = "";
        for (Glycan g : lGlycans) {
            if (!strGWS.isEmpty()) {
                strGWS = String.valueOf(strGWS) + ";";
            }
            strGWS = String.valueOf(strGWS) + GWSParser.toString(g);
        }
        ArrayList<Glycan> lClones = new ArrayList<Glycan>();
        for (Glycan g : lGlycans) {
            lClones.add(g.clone(true));
        }
        Color bgColorOld = bws.getGlycanRenderer().getBackgroundColor();
        bws.getGlycanRenderer().setBackgroundColor(Display.getCurrent().getSystemColor(1));
        Image img = bws.getGlycanRenderer().getImage(lClones, true, bws.getGraphicOptions().SHOW_MASSES, bws.getGraphicOptions().SHOW_REDEND);
        bws.getGlycanRenderer().setBackgroundColor(bgColorOld);
        ClipUtils.copyImageToClipboad(img);
        img.dispose();
    }

    public static boolean copyGWSToClipboard() {
        if (strGWS == null || strGWS.isEmpty()) {
            return false;
        }
        ClipUtils.copyTextToClipboad(strGWS);
        return true;
    }

    public static String getGWSFromClipboard() {
        return strGWS;
    }

    public static boolean canGetGlycanFromClipboard() {
        String strGWSs = ClipUtils.getGWSFromClipboard();
        if (strGWSs == null) {
            return false;
        }
        String[] stringArray = strGWSs.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String strGWS = stringArray[n2];
            if (strGWS != null && !strGWS.isEmpty()) {
                try {
                    GWSParser.fromString(strGWS, new MassOptions());
                }
                catch (Exception exception) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static List<Glycan> getGlycansFromClipboard(MassOptions defaultMassOptions) {
        MassOptions massOptions = defaultMassOptions == null ? new MassOptions() : defaultMassOptions;
        ArrayList<Glycan> lGlycans = new ArrayList<Glycan>();
        String strGWSs = ClipUtils.getGWSFromClipboard();
        if (strGWSs == null) {
            return lGlycans;
        }
        String[] stringArray = strGWSs.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String strGWS = stringArray[n2];
            if (strGWS != null && !strGWS.isEmpty()) {
                try {
                    Glycan g = GWSParser.fromString(strGWS, massOptions);
                    lGlycans.add(g);
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return lGlycans;
    }
}

