/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.structure.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class CrossRingFragmentType
extends ResidueType {
    private String str_residues;
    private List<String> residues;
    private char fragment_type;
    private int first_pos;
    private int last_pos;

    public CrossRingFragmentType() {
        this.str_residues = "";
        this.residues = new ArrayList<String>();
        this.anomeric_carbon = (char)63;
        this.ring_size = (char)63;
        this.fragment_type = (char)45;
        this.first_pos = 0;
        this.last_pos = 0;
    }

    public CrossRingFragmentType(String init) throws Exception {
        Vector tokens = TextUtils.tokenize((String)init, (String)"\t");
        if (tokens.size() != 12) {
            throw new Exception("Invalid string format: " + init);
        }
        this.str_residues = (String)tokens.elementAt(0);
        this.residues = this.parseArray((String)tokens.elementAt(0));
        this.anomeric_carbon = ((String)tokens.elementAt(1)).charAt(0);
        this.ring_size = Character.toLowerCase(((String)tokens.elementAt(2)).charAt(0));
        this.fragment_type = Character.toUpperCase(((String)tokens.elementAt(3)).charAt(0));
        this.first_pos = Integer.parseInt((String)tokens.elementAt(4));
        this.last_pos = Integer.parseInt((String)tokens.elementAt(5));
        this.nmethyls = Integer.parseInt((String)tokens.elementAt(6));
        this.nacetyls = Integer.parseInt((String)tokens.elementAt(7));
        this.nlinkages = Integer.parseInt((String)tokens.elementAt(8));
        this.linkage_pos = this.parseCharArray((String)tokens.elementAt(9));
        this.charges_pos = this.parseCharArray((String)tokens.elementAt(10));
        this.composition = (String)tokens.elementAt(11);
        this.name = "#" + Character.toLowerCase(this.fragment_type) + "cleavage_" + this.first_pos + "_" + this.last_pos;
        this.superclass = "cleavage";
        this.is_saccharide = false;
        this.is_cleavable = false;
        this.is_labile = false;
        this.bar_order = 0;
        this.drop_methylated = false;
        this.drop_acetylated = false;
        this.can_redend = this.fragment_type == 'A';
        this.can_parent = !this.can_redend;
        this.description = String.valueOf(this.fragment_type) + "_" + this.first_pos + "_" + this.last_pos + " cleavage of C" + this.anomeric_carbon + " " + this.str_residues;
        this.updateMolecule();
    }

    private Vector<String> parseArray(String str) throws Exception {
        if (str.equals("-") || str.equals("none") || str.equals("empty")) {
            return new Vector<String>();
        }
        return TextUtils.tokenize((String)str, (String)",");
    }

    public boolean matches(Residue r) {
        return this.residues.contains(r.getTypeName()) && r.getAnomericCarbon() == this.anomeric_carbon && r.getRingSize() == this.ring_size;
    }

    public boolean matches(char _fragment_type, int _first_pos, int _last_pos, Residue r) {
        return this.fragment_type == (_fragment_type = Character.toUpperCase(_fragment_type)) && this.first_pos == _first_pos && this.last_pos == _last_pos && this.matches(r);
    }

    public Collection<String> getResidues() {
        return this.residues;
    }

    public boolean isAFragmentType() {
        return this.fragment_type == 'A';
    }

    public boolean isXFragmentType() {
        return this.fragment_type == 'X';
    }

    public String getRingFragmentType() {
        return "" + this.fragment_type;
    }

    public String getCleavageType() {
        return "^{" + this.first_pos + "," + this.last_pos + "}" + this.fragment_type;
    }

    public int getFirstPos() {
        return this.first_pos;
    }

    public int getLastPos() {
        return this.last_pos;
    }

    public int getStartPos() {
        int anom = this.anomeric_carbon - 48;
        if (this.fragment_type == 'A') {
            return this.first_pos >= anom ? this.first_pos : this.last_pos;
        }
        return this.first_pos >= anom ? this.last_pos : this.first_pos;
    }

    public int getEndPos() {
        int anom = this.anomeric_carbon - 48;
        if (this.fragment_type == 'A') {
            return this.first_pos >= anom ? this.last_pos : this.first_pos;
        }
        return this.first_pos >= anom ? this.first_pos : this.last_pos;
    }
}

