/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LinkageStyle;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.grits.toolbox.tools.glycanbuilder.core.config.GraphicOptionsSWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.SWTRenderer;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.style.LinkageStyleDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.utils.Geometry;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.utils.TextShapeUtils;

public class LinkageRendererSWT
extends SWTRenderer {
    protected Composite parentComposite;
    protected LinkageStyleDictionary theLinkageStyleDictionary = new LinkageStyleDictionary();
    protected GraphicOptionsSWT theGraphicOptions = new GraphicOptionsSWT();

    public LinkageRendererSWT(Device device) {
        super(device);
    }

    public GraphicOptionsSWT getGraphicOptions() {
        return this.theGraphicOptions;
    }

    public void setGraphicOptions(GraphicOptionsSWT opt) {
        this.theGraphicOptions = opt;
    }

    public LinkageStyleDictionary getLinkageStyleDictionary() {
        return this.theLinkageStyleDictionary;
    }

    public void setLinkageStyleDictionary(LinkageStyleDictionary linkageStyleDictionary) {
        this.theLinkageStyleDictionary = linkageStyleDictionary;
    }

    public void paintEdge(GC gc, Linkage link, boolean selected, Rectangle parent_bbox, Rectangle parent_border_bbox, Rectangle child_bbox, Rectangle child_border_bbox) {
        if (link == null) {
            return;
        }
        LineAttributes edge_stroke = this.createStroke(link, selected);
        Path edge_shape = this.createShape(gc.getDevice(), link, parent_bbox, child_bbox);
        if (edge_shape != null) {
            gc.setLineAttributes(edge_stroke);
            gc.setForeground(this.getColorBlack());
            gc.drawPath(edge_shape);
            gc.setLineAttributes(new LineAttributes(1.0f));
            edge_shape.dispose();
        }
    }

    public void paintInfo(GC gc, Linkage link, Rectangle parent_bbox, Rectangle parent_border_bbox, Rectangle child_bbox, Rectangle child_border_bbox) {
        if (link == null || !this.theGraphicOptions.SHOW_INFO) {
            return;
        }
        LinkageStyle style = this.theLinkageStyleDictionary.getStyle(link);
        Font old_font = gc.getFont();
        Font new_font = new Font(gc.getDevice(), this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE, 0);
        gc.setFont(new_font);
        Residue child = link.getChildResidue();
        if (style.showParentLinkage(link)) {
            this.paintInfo(gc, link.getParentPositionsString(), parent_bbox, parent_border_bbox, child_bbox, child_border_bbox, true, false, link.hasMultipleBonds());
        }
        if (style.showAnomericCarbon(link)) {
            this.paintInfo(gc, link.getChildPositionsString(), parent_bbox, parent_border_bbox, child_bbox, child_border_bbox, false, true, link.hasMultipleBonds());
        }
        if (style.showAnomericState(link, child.getAnomericState())) {
            this.paintInfo(gc, TextUtils.toGreek((char)child.getAnomericState()), parent_bbox, parent_border_bbox, child_bbox, child_border_bbox, false, false, link.hasMultipleBonds());
        }
        gc.setFont(old_font);
        new_font.dispose();
    }

    private void paintInfo(GC gc, String text, Rectangle p, Rectangle pb, Rectangle c, Rectangle cb, boolean toparent, boolean above, boolean multiple) {
        Font font = new Font(gc.getDevice(), this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE, 0);
        Rectangle tb = TextShapeUtils.textBounds(font, text);
        Point pos = this.computePosition(tb, p, pb, c, cb, toparent, above, multiple);
        Font oldFont = gc.getFont();
        gc.setFont(font);
        gc.drawString(text, pos.x, pos.y - tb.height, true);
        gc.setFont(oldFont);
        font.dispose();
    }

    private Point computePosition(Rectangle tb, Rectangle p, Rectangle pb, Rectangle c, Rectangle cb, boolean toparent, boolean above, boolean multiple) {
        Point cp = Geometry.center(p);
        Point cc = Geometry.center(c);
        double r = 0.5 * TextShapeUtils.getFontSizePixel(this.theGraphicOptions.LINKAGE_INFO_SIZE);
        double cx = 0.0;
        double cy = 0.0;
        double R = 0.0;
        double angle = 0.0;
        if (toparent) {
            cx = cp.x;
            cy = cp.y;
            angle = Geometry.angle(cc, cp);
            R = Geometry.getExclusionRadius(cp, angle, pb) + 2.0;
        } else {
            cx = c.x + c.width / 2;
            cy = c.y + c.height / 2;
            angle = Geometry.angle(cp, cc);
            R = Geometry.getExclusionRadius(cc, angle, cb) + 2.0;
        }
        double space = multiple ? 4.0 : 2.0;
        boolean add = above;
        if (toparent) {
            add = !add;
        }
        double tx = 0.0;
        double ty = 0.0;
        if (add) {
            tx = cx + (R + r) * Math.cos(angle) + (r + space) * Math.cos(angle - 1.5707963267948966);
            ty = cy + (R + r) * Math.sin(angle) + (r + space) * Math.sin(angle - 1.5707963267948966);
        } else {
            tx = cx + (R + r) * Math.cos(angle) + (r + space) * Math.cos(angle + 1.5707963267948966);
            ty = cy + (R + r) * Math.sin(angle) + (r + space) * Math.sin(angle + 1.5707963267948966);
        }
        return new Point((int)(tx -= (double)(tb.width / 2)), (int)(ty += (double)(tb.height / 2)));
    }

    private LineAttributes createStroke(Linkage link, boolean selected) {
        LinkageStyle style = this.theLinkageStyleDictionary.getStyle(link);
        float fPattern = (float)(5.0 * this.theGraphicOptions.SCALE);
        if (style.isDashed()) {
            return new LineAttributes(selected ? 2.0f : 1.0f, 1, 2, 6, new float[]{fPattern, fPattern}, 0.0f, 1.0f);
        }
        return new LineAttributes(selected ? 2.0f : 1.0f);
    }

    private static Path createLine(Device device, Point p1, Point p2, boolean multiple) {
        if (!multiple) {
            return LinkageRendererSWT.createLine(device, p1, p2);
        }
        Path gp = new Path(device);
        double a = Geometry.angle(p1, p2);
        double tx = 2.0 * Math.cos(a + 1.5707963267948966);
        double ty = 2.0 * Math.sin(a + 1.5707963267948966);
        Path line1 = LinkageRendererSWT.createLine(device, Geometry.translate(p1, tx, ty), Geometry.translate(p2, tx, ty), false);
        gp.addPath(line1);
        line1.dispose();
        tx = 2.0 * Math.cos(a - 1.5707963267948966);
        ty = 2.0 * Math.sin(a - 1.5707963267948966);
        Path line2 = LinkageRendererSWT.createLine(device, Geometry.translate(p1, tx, ty), Geometry.translate(p2, tx, ty), false);
        gp.addPath(line2);
        line2.dispose();
        return gp;
    }

    private static Path createLine(Device device, Point p1, Point p2) {
        Path l = new Path(device);
        l.moveTo((float)p1.x, (float)p1.y);
        l.lineTo((float)p2.x, (float)p2.y);
        return l;
    }

    private static Path createCurve(Device device, Point p1, Point p2) {
        double cx = (double)(p1.x + p2.x) / 2.0;
        double cy = (double)(p1.y + p2.y) / 2.0;
        double r = Geometry.distance(p1, p2) / 2.0;
        double angle = Geometry.angle(p1, p2);
        double x1 = cx + r * Math.cos(angle);
        double y1 = cy + r * Math.sin(angle);
        double x2 = cx + r * Math.cos(angle + Math.PI);
        double y2 = cy + r * Math.sin(angle + Math.PI);
        double cx1 = cx + 0.1 * r * Math.cos(angle);
        double cy1 = cy + 0.1 * r * Math.sin(angle);
        double tx1 = cx1 + r * Math.cos(angle + 1.5707963267948966);
        double ty1 = cy1 + r * Math.sin(angle + 1.5707963267948966);
        double cx2 = cx + 0.1 * r * Math.cos(angle + Math.PI);
        double cy2 = cy + 0.1 * r * Math.sin(angle + Math.PI);
        double tx2 = cx2 + r * Math.cos(angle - 1.5707963267948966);
        double ty2 = cy2 + r * Math.sin(angle - 1.5707963267948966);
        Path p = new Path(device);
        p.moveTo((float)x1, (float)y1);
        p.cubicTo((float)tx1, (float)ty1, (float)tx2, (float)ty2, (float)x2, (float)y2);
        return p;
    }

    private static Path createCurve(Device device, Point p1, Point p2, boolean multiple) {
        if (!multiple) {
            return LinkageRendererSWT.createCurve(device, p1, p2);
        }
        Path gp = new Path(device);
        double a = Geometry.angle(p1, p2);
        double tx = 2.0 * Math.cos(a + 1.5707963267948966);
        double ty = 2.0 * Math.sin(a + 1.5707963267948966);
        Path curve1 = LinkageRendererSWT.createCurve(device, Geometry.translate(p1, tx, ty), Geometry.translate(p2, tx, ty), false);
        gp.addPath(curve1);
        curve1.dispose();
        tx = 2.0 * Math.cos(a - 1.5707963267948966);
        ty = 2.0 * Math.sin(a - 1.5707963267948966);
        Path curve2 = LinkageRendererSWT.createCurve(device, Geometry.translate(p1, tx, ty), Geometry.translate(p2, tx, ty), false);
        gp.addPath(curve2);
        curve2.dispose();
        return gp;
    }

    private Path createShape(Device device, Linkage link, Rectangle parent_bbox, Rectangle child_bbox) {
        LinkageStyle style = this.theLinkageStyleDictionary.getStyle(link);
        String edge_style = style.getShape();
        Point parent_center = Geometry.center(parent_bbox);
        Point child_center = Geometry.center(child_bbox);
        if (edge_style.equals("none")) {
            return null;
        }
        if (edge_style.equals("empty")) {
            return null;
        }
        if (edge_style.equals("line")) {
            return LinkageRendererSWT.createLine(device, parent_center, child_center, link.hasMultipleBonds());
        }
        if (edge_style.equals("curve")) {
            return LinkageRendererSWT.createCurve(device, parent_center, child_center, link.hasMultipleBonds());
        }
        return LinkageRendererSWT.createLine(device, parent_center, child_center);
    }
}

