/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.command;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.archive.dialog.newentry.NewArchiveDialog;
import org.grits.toolbox.entry.archive.model.Archive;
import org.grits.toolbox.entry.archive.property.ArchiveProperty;

public class NewArchive {
    private static final Logger logger = Logger.getLogger(NewArchive.class);
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") @Named(value="activeShell") Shell shell) {
        logger.info((Object)"- START COMMAND : Create a new Archive. ");
        try {
            Entry selectedEntry = null;
            if (object instanceof Entry) {
                selectedEntry = (Entry)object;
            } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
            }
            if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
            }
            this.createNewArchiveEntry(eventBroker, shell, selectedEntry);
        }
        catch (Exception ex) {
            logger.fatal((Object)("Error creating a new Archive : " + ex.getMessage()), (Throwable)ex);
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Unable to create an Archive. ");
        }
        logger.info((Object)"- END   COMMAND : Create a new Archive. ");
    }

    private void createNewArchiveEntry(IEventBroker eventBroker, Shell shell, Entry parent) {
        NewArchiveDialog dialog = new NewArchiveDialog(shell);
        dialog.setParentEntry(parent);
        if (dialog.open() == 0) {
            Entry parentEntry = dialog.getParentEntry();
            Entry selectedProjectEntry = DataModelSearch.findParentByType((Entry)parentEntry, (String)"org.grits.toolbox.property.project");
            File archiveFolder = NewArchive.getArchiveDirectory(selectedProjectEntry);
            String newArchivefolderName = NewArchive.generateFolderName(archiveFolder.list());
            try {
                Entry archiveEntry = NewArchive.createEntry(parentEntry, newArchivefolderName);
                try {
                    gritsDataModelService.addEntry(parentEntry, archiveEntry);
                    ProjectFileHandler.saveProject((Entry)selectedProjectEntry);
                }
                catch (IOException e) {
                    archiveEntry.delete();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)e.getMessage(), (Exception)e);
                    logger.error((Object)("Something went wrong while saving project entry \n" + e.getMessage()), (Throwable)e);
                    logger.fatal((Object)("Closing project entry \"" + selectedProjectEntry.getDisplayName() + "\""));
                    gritsDataModelService.closeProject(selectedProjectEntry);
                }
                if (archiveEntry != null) {
                    new File(archiveFolder + File.separator + newArchivefolderName).mkdir();
                    Archive archive = new Archive();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Archive.class});
                    Marshaller marshaller = context.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)true);
                    marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                    marshaller.marshal((Object)archive, (OutputStream)os);
                    FileWriter fileWriter = new FileWriter(String.valueOf(archiveFolder.getAbsolutePath()) + File.separator + newArchivefolderName + File.separator + "archive.xml");
                    fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
                    fileWriter.close();
                    os.close();
                    eventBroker.send("grits_entry_selected", (Object)archiveEntry);
                    gritsUIService.openEntryInPart(archiveEntry);
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error", (Exception)e);
            }
            catch (JAXBException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Entry createEntry(Entry parentEntry, String newArchivefolderName) {
        Entry newEntry = new Entry();
        newEntry.setDisplayName("Archive");
        ArchiveProperty property = new ArchiveProperty();
        ArrayList<PropertyDataFile> dataFiles = new ArrayList<PropertyDataFile>();
        PropertyDataFile propertyDataFile = new PropertyDataFile(newArchivefolderName, "1.0", "archive_folder");
        dataFiles.add(propertyDataFile);
        property.setDataFiles(dataFiles);
        newEntry.setProperty((Property)property);
        return newEntry;
    }

    public static String generateFolderName(String[] existingNames) {
        String folderName = "";
        int randomLength = 0;
        do {
            folderName = "Archive_";
            while (randomLength < 5) {
                int randomcharacter = (int)(Math.random() * 10.0);
                ++randomLength;
                folderName = String.valueOf(folderName) + randomcharacter;
            }
        } while (Arrays.asList(existingNames).contains(folderName));
        return folderName;
    }

    public static File getArchiveDirectory(Entry selectedProjectEntry) {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + selectedProjectEntry.getDisplayName();
        String archiveFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "Archive";
        File archiveFolder = new File(archiveFolderLocation);
        if (!archiveFolder.exists() || !archiveFolder.isDirectory()) {
            archiveFolder.mkdir();
        }
        return archiveFolder;
    }
}

