/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.property.datamodel.MSGlycanAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.handler.NewGelatoHandlerDirectInfusion;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.handler.NewGelatoHandlerLCMSMS;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.handler.NewGelatoHandlerMSProfile;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.handler.NewGelatoHandlerTIM;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.DatabaseUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.annotation.gelato.AnalyteStructureAnnotation;
import org.grits.toolbox.ms.annotation.process.GelatoWorker;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.GlycanFilter;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.processDialog.ProgressBarWithErrorListener;
import org.grits.toolbox.widgets.progress.IProgressHandler;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;
import org.grits.toolbox.widgets.tools.INotifyingProcess;
import org.grits.toolbox.widgets.tools.NotifyingProcessUtil;

public class NewGelatoHandler
extends GRITSWorker
implements INotifyingProcess {
    private static final Logger logger = Logger.getLogger(NewGelatoHandler.class);
    protected MSGlycanAnnotationWizard wizard = null;
    protected List<Entry> msEntries = null;
    protected List<IProgressListener> myProgressListeners = null;
    protected List<Entry[]> returnList = new ArrayList<Entry[]>();
    protected GRITSProgressDialog gpd = null;
    protected Shell shell = null;
    protected AnalyteStructureAnnotation gsa = null;

    protected Data getNewDataObject(MSGlycanAnnotationWizard wizard) {
        Data data = new Data();
        DataHeader dHeader = new DataHeader();
        data.setDataHeader(dHeader);
        data.getDataHeader().setMethod(wizard.getMethod());
        return data;
    }

    public List<Entry> getMsEntries() {
        return this.msEntries;
    }

    public void setMsEntries(List<Entry> msEntries) {
        this.msEntries = msEntries;
    }

    public void setWizard(MSGlycanAnnotationWizard wizard) {
        this.wizard = wizard;
    }

    public MSGlycanAnnotationWizard getWizard() {
        return this.wizard;
    }

    private String getWorkspaceLocation() {
        return PropertyHandler.getVariable((String)"workspace_location");
    }

    protected File getTempFolder() {
        String workspaceLocation = this.getWorkspaceLocation();
        String t_tempFolder = String.valueOf(workspaceLocation) + ".temp" + File.separator + "GELATO_" + Long.toString(System.currentTimeMillis()) + File.separator;
        File t_tempFolderFile = new File(t_tempFolder);
        t_tempFolderFile.mkdirs();
        return t_tempFolderFile;
    }

    protected File getAnnotationFolder(Entry msEntry) {
        String workspaceLocation = this.getWorkspaceLocation();
        MSGlycanAnnotationProperty t_property = new MSGlycanAnnotationProperty();
        Entry projectEntry = DataModelSearch.findParentByType((Entry)msEntry, (String)"org.grits.toolbox.property.project");
        String projectName = projectEntry.getDisplayName();
        String msAnnotationFolder = String.valueOf(workspaceLocation) + projectName + File.separator + t_property.getArchiveFolder();
        File msAnnotationFolderFile = new File(msAnnotationFolder);
        msAnnotationFolderFile.mkdirs();
        return msAnnotationFolderFile;
    }

    protected MSAnnotationProperty getMSAnnotationProperty(Shell shell, MSGlycanAnnotationWizard wizard, String msAnnotationFolder) {
        MSGlycanAnnotationProperty t_property = new MSGlycanAnnotationProperty();
        MSGlycanAnnotationMetaData metaData = new MSGlycanAnnotationMetaData();
        t_property.setMSAnnotationMetaData((MSAnnotationMetaData)metaData);
        try {
            metaData.setAnnotationId(this.createRandomId(msAnnotationFolder));
            metaData.setDescription(wizard.getInitial().getMSDescription());
            metaData.setVersion("1.0");
            metaData.setName(t_property.getMetaDataFileName());
        }
        catch (IOException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Exception", (Exception)e2);
            return null;
        }
        return t_property;
    }

    protected String createRandomId(String msAnnotation) throws IOException {
        return MSAnnotationProperty.createRandomId((String)msAnnotation);
    }

    public List<Entry[]> process(Shell shell) throws ExecutionException {
        try {
            this.gpd = new GRITSProgressDialog(shell, AnalyteStructureAnnotation.getNumListenersNeeded() + 1, false);
            this.gpd.open();
            this.gpd.setGritsWorker((GRITSWorker)this);
            ArrayList<IProgressListener> majorListeners = new ArrayList<IProgressListener>();
            this.setProgressListeners(majorListeners);
            int iRes = this.gpd.startWorker();
            if (iRes != GRITSProcessStatus.OK && this.returnList != null && !this.returnList.isEmpty()) {
                String sMessage = null;
                sMessage = iRes == GRITSProcessStatus.ERROR ? "An error occurred during processing. Save completed results?" : "Processing canceled. Save completed results?";
                int iYesNo = ErrorUtils.createSingleConfirmationMessageBoxReturn((Shell)shell, (String)"Process did not complete", (String)sMessage);
                if (iYesNo != 64) {
                    this.returnList.clear();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.updateListeners("Done!", this.getMsEntries().size());
        return this.returnList;
    }

    private void updateDatabaseReferences(Method method) {
        for (AnalyteSettings aSettings : method.getAnalyteSettings()) {
            GlycanFilter filter = aSettings.getGlycanSettings().getFilter();
            if (filter.getDatabase().indexOf(File.separator) != -1) continue;
            try {
                filter.setDatabase(String.valueOf(DatabaseUtils.getDatabasePath()) + File.separator + filter.getDatabase());
            }
            catch (IOException e) {
                logger.error((Object)"Database path cannot be determined", (Throwable)e);
            }
        }
    }

    protected AnalyteStructureAnnotation getAnnotationStructure(Data data, String t_tempFolder, String msAnnotationFolder, MSGlycanAnnotationProperty t_property, MSFile msFile) {
        String sMSType = msFile.getExperimentType();
        AnalyteStructureAnnotation newGSA = null;
        if (sMSType.equals("Direct Infusion")) {
            if (msFile.getReader() != null && msFile.getReader() instanceof IMSAnnotationFileReader) {
                newGSA = ((IMSAnnotationFileReader)msFile.getReader()).hasMS1Scan(msFile) ? NewGelatoHandlerDirectInfusion.getNewStructureAnnotationObject(data, t_tempFolder, msAnnotationFolder, t_property, msFile) : NewGelatoHandlerTIM.getNewStructureAnnotationObject(data, t_tempFolder, msAnnotationFolder, t_property, msFile);
            }
        } else if (sMSType.equals("Total Ion Mapping (TIM)")) {
            newGSA = NewGelatoHandlerTIM.getNewStructureAnnotationObject(data, t_tempFolder, msAnnotationFolder, t_property, msFile);
        } else if (sMSType.equals("LC-MS/MS")) {
            newGSA = NewGelatoHandlerLCMSMS.getNewStructureAnnotationObject(data, t_tempFolder, msAnnotationFolder, t_property, msFile);
        } else if (sMSType.equals("MS Profile")) {
            newGSA = NewGelatoHandlerMSProfile.getNewStructureAnnotationObject(data, t_tempFolder, msAnnotationFolder, t_property, msFile);
        } else {
            int iNumMS1 = ((IMSAnnotationFileReader)msFile.getReader()).getNumMS1Scans(msFile);
            int iNumMS2 = ((IMSAnnotationFileReader)msFile.getReader()).getNumMS2Scans(msFile);
            double dRatio = (double)iNumMS1 / (double)iNumMS2;
            if (iNumMS1 == 0 && iNumMS2 > 0) {
                newGSA = NewGelatoHandlerTIM.getNewStructureAnnotationObject(data, t_tempFolder, msAnnotationFolder, t_property, msFile);
            } else if (iNumMS1 > 0 && iNumMS2 == 0) {
                newGSA = NewGelatoHandlerMSProfile.getNewStructureAnnotationObject(data, t_tempFolder, msAnnotationFolder, t_property, msFile);
            } else if (iNumMS1 > 0 && iNumMS2 > 0) {
                newGSA = dRatio < 0.1 ? NewGelatoHandlerDirectInfusion.getNewStructureAnnotationObject(data, t_tempFolder, msAnnotationFolder, t_property, msFile) : NewGelatoHandlerLCMSMS.getNewStructureAnnotationObject(data, t_tempFolder, msAnnotationFolder, t_property, msFile);
            }
        }
        return newGSA;
    }

    private int performAnnotation(GRITSProgressDialog gpd, Data data, String t_tempFolder, String msAnnotationFolder, MSGlycanAnnotationProperty t_property, MSFile msFile) {
        logger.debug((Object)"Starting job: determineScanBounds");
        try {
            this.updateDatabaseReferences(data.getDataHeader().getMethod());
            this.gsa = this.getAnnotationStructure(data, t_tempFolder, msAnnotationFolder, t_property, msFile);
            if (this.gsa == null) {
                return GRITSProcessStatus.ERROR;
            }
            String sMSType = msFile.getExperimentType();
            this.wizard.getMethod().setMsType(sMSType);
            ArrayList<ProgressBarWithErrorListener> workerListeners = new ArrayList<ProgressBarWithErrorListener>();
            workerListeners.add(gpd.getMinorProgressBarListeners()[0]);
            ArrayList<ProgressBarWithErrorListener> annotationListeners = new ArrayList<ProgressBarWithErrorListener>();
            annotationListeners.add(gpd.getMinorProgressBarListeners()[1]);
            GelatoWorker gw = new GelatoWorker(this.gsa, (IProgressHandler)gpd, (IProgressThreadHandler)gpd, workerListeners, annotationListeners, null);
            int iRes = gw.doWork();
            return iRes;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    public void updateListeners(String _sMsg, int _iVal) {
        NotifyingProcessUtil.updateListeners(this.getProgressListeners(), (String)_sMsg, (int)_iVal);
    }

    public void updateErrorListener(String _sMsg) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg);
    }

    public void updateErrorListener(String _sMsg, Throwable t) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg, (Throwable)t);
    }

    public void setMaxValue(int _iVal) {
        NotifyingProcessUtil.setMaxValue(this.getProgressListeners(), (int)_iVal);
    }

    public void addProgressListeners(IProgressListener lProgressListener) {
        this.myProgressListeners.add(lProgressListener);
    }

    public List<IProgressListener> getProgressListeners() {
        return this.myProgressListeners;
    }

    public void setProgressListeners(List<IProgressListener> lProgressListeners) {
        this.myProgressListeners = lProgressListeners;
    }

    public void setProgressType(IProgressListener.ProgressType progressType) {
        NotifyingProcessUtil.setProgressType(this.getProgressListeners(), (IProgressListener.ProgressType)progressType);
    }

    public int doWork() {
        File fWorkspaceFolderFile = this.getTempFolder();
        int iStatus = GRITSProcessStatus.OK;
        try {
            this.setMaxValue(this.wizard.getInitial().getMsEntryList().size());
            int i = 0;
            while (i < this.wizard.getInitial().getMsEntryList().size() && iStatus == GRITSProcessStatus.OK) {
                Entry msEntry = this.wizard.getInitial().getMsEntryList().get(i);
                this.updateListeners("Processing entry: " + msEntry.getDisplayName(), i);
                MassSpecProperty prop = (MassSpecProperty)msEntry.getProperty();
                Entry msAnnotationEntry = new Entry();
                String sWorkspaceFolder = fWorkspaceFolderFile.getAbsolutePath();
                File msAnnFile = this.getAnnotationFolder(msEntry);
                String msAnnotationFolder = msAnnFile.getAbsolutePath();
                MSGlycanAnnotationProperty msAnnotProperty = (MSGlycanAnnotationProperty)this.getMSAnnotationProperty(this.shell, this.wizard, msAnnotationFolder);
                String msEntryDisplayName = msEntry.getDisplayName();
                String msAnnotName = this.wizard.getInitial().getListEntries().get(msEntryDisplayName);
                msAnnotationEntry.setDisplayName(msAnnotName);
                msAnnotationEntry.setProperty((Property)msAnnotProperty);
                Data data = this.getNewDataObject(this.wizard);
                DataHeader dHeader = data.getDataHeader();
                MSPropertyDataFile dataFile = this.wizard.getInitial().getFileMap().get(msEntry.getDisplayName());
                String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
                String projectName = DataModelSearch.findParentByType((Entry)msEntry, (String)"org.grits.toolbox.property.project").getDisplayName();
                String pathToFile = String.valueOf(workspaceLocation) + projectName + File.separator + MassSpecProperty.getFoldername();
                iStatus = this.performAnnotation(this.gpd, data, sWorkspaceFolder, msAnnotationFolder, msAnnotProperty, dataFile.getMSFileWithReader(pathToFile, prop.getMassSpecMetaData().getMsExperimentType()));
                if (iStatus == GRITSProcessStatus.OK) {
                    msAnnotProperty.getMSAnnotationMetaData().addAnnotationFile(dataFile);
                    PropertyDataFile msMetaData = MSAnnotationProperty.getNewSettingsFile((String)msAnnotProperty.getMetaDataFileName(), (MSAnnotationMetaData)msAnnotProperty.getMSAnnotationMetaData());
                    msAnnotProperty.getDataFiles().add(msMetaData);
                    this.addResultFileToMetaData(dHeader.getMethod().getMsType(), (MSAnnotationProperty)msAnnotProperty);
                    MSAnnotationProperty.marshallSettingsFile((String)(String.valueOf(msAnnotProperty.getAnnotationFolder(msEntry)) + File.separator + msAnnotProperty.getMetaDataFileName()), (MSAnnotationMetaData)msAnnotProperty.getMSAnnotationMetaData());
                    Entry[] entries = new Entry[]{msEntry, msAnnotationEntry};
                    logger.debug((Object)"Finished creating the annotation archive");
                    this.returnList.add(entries);
                } else if (iStatus == GRITSProcessStatus.CANCEL) {
                    this.deleteResultFiles(dHeader.getMethod().getMsType());
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            iStatus = GRITSProcessStatus.ERROR;
        }
        File[] fileArray = fWorkspaceFolderFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        fWorkspaceFolderFile.delete();
        this.updateListeners("Done!", this.getMsEntries().size());
        return iStatus;
    }

    protected void deleteResultFiles(String msType) {
        if (msType.equals("LC-MS/MS")) {
            NewGelatoHandlerLCMSMS.deleteResultFiles(this.gsa);
        } else {
            NewGelatoHandler.deleteResultFiles(this.gsa);
        }
    }

    private static void deleteResultFiles(AnalyteStructureAnnotation gsa) {
        try {
            String sAnnotationFile = gsa.getFinalArchiveName();
            File annotationFile = new File(sAnnotationFile);
            if (annotationFile.exists()) {
                annotationFile.delete();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not delete generated files", (Throwable)e);
        }
    }

    protected void addResultFileToMetaData(String sMSType, MSAnnotationProperty msAnnotProperty) {
        if (sMSType.equals("LC-MS/MS")) {
            NewGelatoHandlerLCMSMS.addResultFileToMetaData(this.gsa, (MSGlycanAnnotationProperty)msAnnotProperty);
        } else {
            NewGelatoHandler.addResultFileToMetaData(this.gsa, msAnnotProperty);
        }
    }

    private static void addResultFileToMetaData(AnalyteStructureAnnotation gsa, MSAnnotationProperty msAnnotProperty) {
        String sAnnotationFile = gsa.getFinalArchiveName();
        File annotationFile = new File(sAnnotationFile);
        MSPropertyDataFile pdfFolder = new MSPropertyDataFile(annotationFile.getName(), "1.0", "file", FileCategory.ANNOTATION_CATEGORY, "GELATO", annotationFile.getPath(), new ArrayList());
        msAnnotProperty.getMSAnnotationMetaData().addFile(pdfFolder);
    }
}

