/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.RepeatInterface;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.GlycanFormatconverter.util.exchange.GlyContainerToWURCSGraph.GlyContainerEdgeAnalyzer;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSEdgeComparatorSimple;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class WURCSEdgeToLinkage {
    private LinkedList<Backbone> nodeLists = new LinkedList();
    private HashMap<WURCSComponent, Node> backbone2node = new HashMap();
    private GlycanUndefinedUnit und;
    private ArrayList<Backbone> antennae;
    private Backbone root;

    public WURCSEdgeToLinkage(LinkedList<Backbone> _nodes, HashMap<WURCSComponent, Node> _nodeMap) {
        this.nodeLists = _nodes;
        this.backbone2node = _nodeMap;
        this.antennae = new ArrayList();
    }

    public void start(GlyContainer _glyCo) throws GlycanException, ConverterExchangeException, WURCSFormatException {
        Backbone root = this.nodeLists.getFirst();
        if (_glyCo.getNodes().isEmpty()) {
            _glyCo.addNode(this.backbone2node.get(root));
        }
        for (Backbone bb : this.nodeLists) {
            this.WURCSEdgeAnalyzer(bb);
        }
        GlyContainerEdgeAnalyzer gcEdgeAnalyzer = new GlyContainerEdgeAnalyzer(_glyCo);
        gcEdgeAnalyzer.start(this.backbone2node, root);
    }

    private void WURCSEdgeAnalyzer(Backbone _backbone) throws GlycanException, ConverterExchangeException, WURCSFormatException {
        if (this.und != null) {
            this.und = null;
        }
        for (Backbone unit : this.antennae) {
            if (!unit.equals(_backbone)) continue;
            this.backboneToUndefinedUnit(_backbone);
        }
        for (WURCSEdge cEdge : _backbone.getChildEdges()) {
            Modification mod = cEdge.getModification();
            if (mod.isRing() || this.isSubstituentEdge(cEdge)) continue;
            if (!(mod instanceof ModificationRepeat)) {
                this.extractSimpleLinkage(_backbone, cEdge, mod);
            }
            if (mod instanceof ModificationRepeat) {
                this.extractRpeatingUnit(_backbone, mod);
            }
            if (!this.isCyclicNodeByEdge(cEdge)) continue;
            this.extractCyclicUnit(_backbone, cEdge, mod);
        }
    }

    private void extractSimpleLinkage(Backbone _backbone, WURCSEdge _c, Modification _mod) throws GlycanException {
        Backbone ccBackbone = null;
        Backbone cpBackbone = null;
        LinkedList donor = null;
        LinkedList acceptor = null;
        for (WURCSEdge cc : _c.getNextComponent().getChildEdges()) {
            if (_backbone.equals(cc.getBackbone())) continue;
            ccBackbone = cc.getBackbone();
            acceptor = cc.getLinkages();
        }
        for (WURCSEdge cp : _c.getNextComponent().getParentEdges()) {
            if (_backbone.equals(cp.getBackbone())) continue;
            cpBackbone = cp.getBackbone();
            donor = cp.getLinkages();
        }
        if (ccBackbone == null && cpBackbone == null) {
            return;
        }
        if (cpBackbone != null) {
            if (this.isCyclicNode(_backbone) || this.isCyclicNode(cpBackbone)) {
                return;
            }
            if (this.antennae.contains(_backbone)) {
                return;
            }
            if (this.isAntennaeAnchor(cpBackbone)) {
                return;
            }
            acceptor = _c.getLinkages();
        }
        if (ccBackbone != null) {
            donor = _c.getLinkages();
        }
        if (this.isFlipFlop(_backbone, (Backbone)(ccBackbone != null ? ccBackbone : (cpBackbone != null ? cpBackbone : null)))) {
            Backbone tmp = _backbone;
            LinkedList temp = acceptor;
            if (cpBackbone != null) {
                _backbone = cpBackbone;
                cpBackbone = tmp;
                acceptor = donor;
                donor = temp;
            }
            if (ccBackbone != null) {
                _backbone = ccBackbone;
                ccBackbone = tmp;
                acceptor = donor;
                donor = temp;
            }
        }
        Edge edge = null;
        if (ccBackbone != null) {
            edge = this.WURCSEdgeToEdge(donor, acceptor);
        }
        if (cpBackbone != null) {
            edge = this.WURCSEdgeToEdge(acceptor, donor);
        }
    }

    private boolean isSubstituentEdge(WURCSEdge _wedge) {
        Modification mod = _wedge.getModification();
        if (mod.isGlycosidic() || mod.isRing() || mod instanceof ModificationRepeat) {
            return false;
        }
        if (!_wedge.getModification().getMAPCode().equals("")) {
            return _wedge.getNextComponent().getChildEdges().isEmpty() && !_wedge.getNextComponent().getParentEdges().isEmpty();
        }
        return _wedge.getNextComponent().getChildEdges().isEmpty() && _wedge.getNextComponent().getParentEdges().size() == 2;
    }

    private void extractRpeatingUnit(Backbone _backbone, Modification _mod) throws GlycanException, WURCSFormatException {
        Node current = this.backbone2node.get(_backbone);
        LinkedList donor = ((WURCSEdge)_mod.getParentEdges().getLast()).getLinkages();
        LinkedList acceptor = ((WURCSEdge)_mod.getParentEdges().getFirst()).getLinkages();
        Node end = this.backbone2node.get(((WURCSEdge)_mod.getParentEdges().getLast()).getBackbone());
        Node start = this.backbone2node.get(((WURCSEdge)_mod.getParentEdges().getFirst()).getBackbone());
        if (!current.equals(end)) {
            return;
        }
        if (!this.isStandardRepeatEdgeOrder((ModificationRepeat)_mod)) {
            LinkedList linkTemp = donor;
            donor = acceptor;
            acceptor = linkTemp;
            Node temp = end;
            end = start;
            start = temp;
        }
        Edge parentEdge = this.WURCSEdgeToEdge(donor, acceptor);
        parentEdge.setSubstituent(this.makeSubstituentWithRepeat(_mod));
        for (Edge edge : end.getChildEdges()) {
            if (!start.equals(edge.getChild())) continue;
            return;
        }
    }

    private void extractCyclicUnit(Backbone _backbone, WURCSEdge _cEdge, Modification _mod) throws GlycanException, WURCSFormatException {
        if (!_cEdge.getNextComponent().getChildEdges().isEmpty()) {
            return;
        }
        if (_mod instanceof ModificationRepeat) {
            return;
        }
        Node start = this.backbone2node.get(_backbone);
        Object end = null;
        Edge cyclicEdge = new Edge();
        Linkage lin = new Linkage();
        block0: for (WURCSEdge edge : _backbone.getChildEdges()) {
            if (edge.getModification().isRing() || edge.getModification() instanceof ModificationRepeat) continue;
            if (!edge.getModification().getMAPCode().equals("")) break;
            for (WURCSEdge cp : edge.getNextComponent().getParentEdges()) {
                if (_backbone.equals(cp.getBackbone())) continue;
                end = this.backbone2node.get(cp.getBackbone());
            }
            if (end == null) continue;
            for (WURCSEdge cc : edge.getNextComponent().getChildEdges()) {
                if (!end.equals(this.backbone2node.get(cc.getBackbone()))) continue;
                end = null;
                continue block0;
            }
        }
        if (end == null) {
            return;
        }
        for (WURCSEdge cpEdge : _cEdge.getNextComponent().getParentEdges()) {
            if (_cEdge.getNextComponent().getParentEdges().indexOf(cpEdge) == 0) {
                lin.addChildLinkage(((LinkagePosition)cpEdge.getLinkages().getFirst()).getBackbonePosition());
            }
            if (_cEdge.getNextComponent().getParentEdges().indexOf(cpEdge) != 1) continue;
            lin.addParentLinkage(((LinkagePosition)cpEdge.getLinkages().getFirst()).getBackbonePosition());
        }
        if (lin.getChildLinkages().isEmpty() || lin.getParentLinkages().isEmpty()) {
            return;
        }
        cyclicEdge.addGlycosidicLinkage(lin);
        cyclicEdge.setSubstituent(this.makeSubstituentWithRepeat(_mod));
        if (end == null || !end.equals(start)) {
            // empty if block
        }
    }

    private void backboneToUndefinedUnit(Backbone _backbone) throws GlycanException, WURCSFormatException {
        Node current = this.backbone2node.get(_backbone);
        GlycanUndefinedUnit fragment = new GlycanUndefinedUnit();
        LinkedList acceptor = null;
        LinkedList donor = null;
        ArrayList<WURCSEdge> fragments = new ArrayList<WURCSEdge>();
        for (WURCSEdge cEdge : _backbone.getChildEdges()) {
            if (!(cEdge.getNextComponent() instanceof ModificationAlternative)) continue;
            fragments.add(cEdge);
        }
        Iterator iterWG = fragments.iterator();
        while (iterWG.hasNext()) {
            WURCSEdge modAlt = (WURCSEdge)iterWG.next();
            for (WURCSEdge cpEdge : modAlt.getNextComponent().getParentEdges()) {
                if (_backbone.equals(cpEdge.getBackbone()) && (cpEdge.getModification().getMAPCode().equals("") || cpEdge.getModification().getParentEdges().size() < 2)) continue;
                if (!cpEdge.getModification().getMAPCode().equals("")) {
                    current = SubstituentUtility.MAPToSubstituent(cpEdge.getModification());
                    acceptor = donor = cpEdge.getLinkages();
                }
                if (donor == null) {
                    donor = cpEdge.getLinkages();
                }
                fragment.addParentNode(this.backbone2node.get(cpEdge.getBackbone()));
            }
            if (acceptor == null && !this.isSubstituentEdge(modAlt)) {
                acceptor = modAlt.getLinkages();
            }
            if (!iterWG.hasNext()) continue;
            fragment = new GlycanUndefinedUnit();
        }
        Edge parentEdge = this.WURCSEdgeToEdge(donor, acceptor);
        parentEdge.setChild(current);
        current.addParentEdge(parentEdge);
        fragment.setConnection(parentEdge);
        fragment.addNode(current);
    }

    private Edge WURCSEdgeToEdge(LinkedList<LinkagePosition> _donor, LinkedList<LinkagePosition> _acceptor) throws GlycanException {
        Edge edge = new Edge();
        Linkage lin = new Linkage();
        for (LinkagePosition lp : _acceptor) {
            lin.addChildLinkage(lp.getBackbonePosition());
        }
        for (LinkagePosition lp : _donor) {
            lin.addParentLinkage(lp.getBackbonePosition());
        }
        lin.setProbabilityLower(_donor.getFirst().getProbabilityLower());
        lin.setProbabilityUpper(_donor.getFirst().getProbabilityUpper());
        lin.setChildProbabilityLower(_acceptor.getFirst().getProbabilityLower());
        lin.setChildProbabilityUpper(_acceptor.getFirst().getProbabilityUpper());
        edge.addGlycosidicLinkage(lin);
        return edge;
    }

    private Substituent makeSubstituentWithRepeat(Modification _mod) throws GlycanException, WURCSFormatException {
        BaseCrossLinkedTemplate bcT = (BaseCrossLinkedTemplate)SubstituentUtility.MAPToInterface(_mod.getMAPCode());
        GlycanRepeatModification ret = new GlycanRepeatModification(bcT);
        ModificationRepeat repMod = _mod instanceof ModificationRepeat ? (ModificationRepeat)_mod : null;
        ret.setMinRepeatCount(repMod == null ? 0 : repMod.getMinRepeatCount());
        ret.setMaxRepeatCount(repMod == null ? 0 : repMod.getMaxRepeatCount());
        return ret;
    }

    private boolean isStandardRepeatEdgeOrder(ModificationRepeat _rep) throws GlycanException {
        WURCSEdgeComparatorSimple t_comp;
        int t_iComp;
        Boolean t_bLastIsAnom;
        boolean t_bLastIsParent;
        boolean t_bFirstIsParent;
        Backbone t_bbLast;
        if (_rep.getParentEdges().size() != 2) {
            throw new GlycanException("Illegal repeat connections.");
        }
        WURCSEdge t_edgeFirst = (WURCSEdge)_rep.getParentEdges().getFirst();
        WURCSEdge t_edgeLast = (WURCSEdge)_rep.getParentEdges().getLast();
        Backbone t_bbFirst = t_edgeFirst.getBackbone();
        if (!t_bbFirst.equals(t_bbLast = t_edgeLast.getBackbone()) && (t_bFirstIsParent = this.checkParentToChild(t_bbFirst, t_bbLast)) != (t_bLastIsParent = this.checkParentToChild(t_bbLast, t_bbFirst))) {
            return t_bFirstIsParent;
        }
        Boolean t_bFirstIsAnom = this.isAnomericEdge(t_edgeFirst);
        if (t_bFirstIsAnom != (t_bLastIsAnom = this.isAnomericEdge(t_edgeLast))) {
            if (t_bFirstIsAnom != null && t_bFirstIsAnom.booleanValue()) {
                return true;
            }
            if (t_bLastIsAnom != null && t_bLastIsAnom.booleanValue()) {
                return false;
            }
            if (t_bFirstIsAnom == null) {
                return true;
            }
            if (t_bLastIsAnom == null) {
                return false;
            }
        }
        if ((t_iComp = (t_comp = new WURCSEdgeComparatorSimple()).compare(t_edgeFirst, t_edgeLast)) != 0) {
            return t_iComp < 0;
        }
        return true;
    }

    private boolean checkParentToChild(Backbone _bb1, Backbone _bb2) {
        LinkedList<Backbone> t_lChildrenQueue = new LinkedList<Backbone>();
        t_lChildrenQueue.add(_bb1);
        while (!t_lChildrenQueue.isEmpty()) {
            Backbone t_bb = (Backbone)t_lChildrenQueue.removeFirst();
            for (WURCSEdge t_edgeChild : t_bb.getChildEdges()) {
                Modification t_mod = t_edgeChild.getModification();
                if (t_mod instanceof RepeatInterface) continue;
                for (WURCSEdge t_edgeChildChild : t_mod.getChildEdges()) {
                    Backbone t_bbChild = t_edgeChildChild.getBackbone();
                    if (!_bb2.equals(t_bbChild)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Boolean isAnomericEdge(WURCSEdge _oEdge) {
        if (_oEdge.getLinkages().size() > 1) {
            return false;
        }
        int t_iAnomPos = _oEdge.getBackbone().getAnomericPosition();
        if (t_iAnomPos == 0 || t_iAnomPos == -1) {
            return null;
        }
        if (((LinkagePosition)_oEdge.getLinkages().getFirst()).getBackbonePosition() != t_iAnomPos) {
            return false;
        }
        return true;
    }

    private boolean isDefinedLinkage(Backbone _acceptor, Edge _edge, Backbone _donor) {
        Node donor = this.backbone2node.get(_donor);
        Node acceptor = this.backbone2node.get(_acceptor);
        if (donor == null || acceptor == null) {
            return false;
        }
        boolean isDefined = false;
        int currentDonorPos = -1;
        int currentAcceptorPos = -1;
        for (Linkage lin : _edge.getGlycosidicLinkages()) {
            if (lin.getChildLinkages().size() > 1 || lin.getParentLinkages().size() > 1) continue;
            currentDonorPos = lin.getChildLinkages().get(0);
            currentAcceptorPos = lin.getParentLinkages().get(0);
        }
        for (Edge edge : acceptor.getChildEdges()) {
            if (edge.getChild() == null || edge.getParent() == null || !edge.getChild().equals(donor) || !edge.getParent().equals(acceptor)) continue;
            for (Linkage lin : edge.getGlycosidicLinkages()) {
                if (lin.getChildLinkages().size() > 1 || lin.getParentLinkages().size() > 1 || lin.getChildLinkages().indexOf(currentDonorPos) == -1 || lin.getParentLinkages().indexOf(currentAcceptorPos) == -1) continue;
                isDefined = true;
            }
        }
        return isDefined;
    }

    private boolean isCrossLinkedSubstituent(Modification _mod) throws GlycanException, WURCSFormatException {
        if (_mod.getMAPCode().equals("")) {
            return false;
        }
        return SubstituentUtility.MAPToInterface(_mod.getMAPCode()) instanceof BaseCrossLinkedTemplate;
    }

    private boolean isFlipFlop(Backbone _parent, Backbone _child) {
        if (!_parent.isRoot() || this.root.equals(_parent) || this.antennae.contains(_parent)) {
            return false;
        }
        return this.backbone2node.get(_parent).getParentEdges().isEmpty();
    }

    private boolean isAntennaeAnchor(Backbone _backbone) {
        boolean ret = false;
        for (Backbone bb : this.antennae) {
            block1: for (WURCSEdge edge : bb.getChildEdges()) {
                if (edge.getModification().isRing()) continue;
                for (WURCSEdge pp : edge.getNextComponent().getParentEdges()) {
                    if (!_backbone.equals(pp.getBackbone())) continue;
                    ret = true;
                    continue block1;
                }
            }
        }
        return ret;
    }

    private boolean isCyclicNodeByEdge(WURCSEdge _edge) {
        if (_edge.getModification() instanceof ModificationRepeat) {
            return false;
        }
        if (this.isSubstituentEdge(_edge)) {
            return false;
        }
        if (_edge.getModification().isRing()) {
            return false;
        }
        if (_edge.getModification().isGlycosidic() && !_edge.getModification().getMAPCode().equals("")) {
            return false;
        }
        return this.isCyclicNode(_edge.getBackbone());
    }

    private boolean isCyclicNode(Backbone _backbone) {
        if (!this.root.equals(_backbone)) {
            return false;
        }
        boolean isCyclic = false;
        Backbone end = null;
        block0: for (WURCSEdge edge : _backbone.getChildEdges()) {
            if (edge.getModification().isRing()) continue;
            if (this.isSubstituentEdge(edge) || edge.getModification() instanceof ModificationRepeat) break;
            if (edge.getModification().isGlycosidic() && !edge.getModification().getMAPCode().equals("")) continue;
            for (WURCSEdge cp : edge.getNextComponent().getParentEdges()) {
                if (cp.getNextComponent() instanceof ModificationAlternative || _backbone.equals(cp.getBackbone()) || cp.getBackbone().getParentEdges().isEmpty()) continue;
                end = cp.getBackbone();
            }
            for (WURCSEdge cc : edge.getNextComponent().getChildEdges()) {
                if (!(cc.getNextComponent() instanceof ModificationAlternative)) continue;
            }
            if (end == null) continue;
            for (WURCSEdge cc : edge.getNextComponent().getChildEdges()) {
                if (!end.equals(cc.getBackbone())) continue;
                end = null;
                continue block0;
            }
        }
        isCyclic = end != null;
        return isCyclic;
    }

    private boolean haveChild(Node _parent, Node _child, Node _sub) {
        if (_parent.getParentEdges().isEmpty()) {
            return false;
        }
        boolean ret = false;
        for (Edge edge : _parent.getParentEdges()) {
            if (edge.getParent() == null || edge.getChild() == null || edge.getSubstituent() == null && _sub != null || edge.getSubstituent() != null && _sub == null || !edge.getParent().equals(_child) || !edge.getChild().equals(_parent)) continue;
            ret = true;
        }
        return ret;
    }
}

