/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.JSON.JSONParamAnalyzer;
import org.json.JSONArray;
import org.json.JSONObject;

public class GCJSONModificationParser {
    public ArrayList<Edge> parseSubstituents(JSONArray _subs) throws GlycanException {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        for (Object key : _subs) {
            ret.add(this.parseSubstituent((JSONObject)key));
        }
        return ret;
    }

    private Edge parseSubstituent(JSONObject _sub) throws GlycanException {
        Edge subEdge = new Edge();
        BaseSubstituentTemplate subFace = null;
        Linkage positionOne = new Linkage();
        Iterator iterator = _sub.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "Status": {
                    break;
                }
                case "Acceptor": {
                    JSONObject acceptor = (JSONObject)_sub.get(key);
                    positionOne.setParentLinkages(JSONParamAnalyzer.parsePosition(acceptor.getJSONArray("Position")));
                    positionOne.setParentLinkageType(JSONParamAnalyzer.parseLinkageType(acceptor.get("LinkageType")));
                    break;
                }
                case "Donor": {
                    JSONObject donor = (JSONObject)_sub.get(key);
                    positionOne.setChildLinkages(JSONParamAnalyzer.parsePosition(donor.getJSONArray("Position")));
                    positionOne.setChildLinkageType(JSONParamAnalyzer.parseLinkageType(donor.get("LinkageType")));
                    break;
                }
                case "Probability": {
                    JSONObject probability = (JSONObject)_sub.get(key);
                    positionOne.setProbabilityUpper(JSONParamAnalyzer.parseProbability(_sub.getJSONObject("Probability").get("High")));
                    positionOne.setProbabilityLower(JSONParamAnalyzer.parseProbability(_sub.getJSONObject("Probability").get("Low")));
                    break;
                }
                case "Notation": {
                    subFace = JSONParamAnalyzer.parseSubstituentTemplate(_sub.getString(key));
                }
            }
        }
        Substituent sub = new Substituent(subFace, positionOne, null);
        if (sub.getFirstPosition().getParentLinkageType().equals((Object)LinkageType.H_AT_OH)) {
            sub.setHeadAtom("O");
        }
        subEdge.setSubstituent(sub);
        sub.addParentEdge(subEdge);
        subEdge.addGlycosidicLinkage(positionOne);
        return subEdge;
    }

    public ArrayList<GlyCoModification> parseModifications(JSONArray _mod) throws GlycanException {
        ArrayList<GlyCoModification> ret = new ArrayList<GlyCoModification>();
        HashMap<Integer, ArrayList<JSONObject>> mods = this.extractUnsaturationWithDeoxy(_mod);
        for (Integer key : mods.keySet()) {
            JSONObject modObj = mods.get(key).get(0);
            ModificationTemplate modTemp = this.hasUnsaturationWithDeoxy(mods.get(key)) ? this.parseUnsaturation(mods.get(key)) : this.modifyUnsaturation(this.parseModificationTemplate((String)modObj.get("Notation")));
            GlyCoModification gMod = new GlyCoModification(modTemp, (int)key);
            ret.add(gMod);
        }
        return ret;
    }

    private HashMap<Integer, ArrayList<JSONObject>> extractUnsaturationWithDeoxy(JSONArray _mod) {
        HashMap<Integer, ArrayList<JSONObject>> ret = new HashMap<Integer, ArrayList<JSONObject>>();
        for (Object item : _mod) {
            JSONObject modObj = (JSONObject)item;
            Integer pos = (Integer)modObj.get("Position");
            if (!ret.containsKey(pos)) {
                ArrayList<JSONObject> items = new ArrayList<JSONObject>();
                items.add(modObj);
                ret.put(pos, items);
                continue;
            }
            ret.get(pos).add(modObj);
        }
        return ret;
    }

    private boolean hasUnsaturationWithDeoxy(ArrayList<JSONObject> _mods) {
        int result = 0;
        for (JSONObject item : _mods) {
            if (this.parseModificationTemplate((String)item.get("Notation")).equals((Object)ModificationTemplate.UNSATURATION_EL)) {
                ++result;
            }
            if (this.parseModificationTemplate((String)item.get("Notation")).equals((Object)ModificationTemplate.UNSATURATION_FL)) {
                ++result;
            }
            if (this.parseModificationTemplate((String)item.get("Notation")).equals((Object)ModificationTemplate.UNSATURATION_ZL)) {
                ++result;
            }
            if (!this.parseModificationTemplate((String)item.get("Notation")).equals((Object)ModificationTemplate.DEOXY)) continue;
            ++result;
        }
        return result == 2;
    }

    private ModificationTemplate parseModificationTemplate(String _notation) {
        for (ModificationTemplate value : ModificationTemplate.values()) {
            if (!_notation.equals(value.getIUPACnotation())) continue;
            return value;
        }
        return null;
    }

    private ModificationTemplate parseUnsaturation(ArrayList<JSONObject> _mods) {
        ModificationTemplate ret = null;
        for (JSONObject item : _mods) {
            if (item.get("Notation").equals("(E)en")) {
                ret = ModificationTemplate.UNSATURATION_EL;
            }
            if (item.get("Notation").equals("(F)en")) {
                ret = ModificationTemplate.UNSATURATION_FL;
            }
            if (!item.get("Notation").equals("(Z)en")) continue;
            ret = ModificationTemplate.UNSATURATION_ZL;
        }
        return ret;
    }

    private ModificationTemplate modifyUnsaturation(ModificationTemplate _modTemp) {
        if (_modTemp == null) {
            return null;
        }
        if (_modTemp.equals((Object)ModificationTemplate.UNSATURATION_FL)) {
            return ModificationTemplate.UNSATURATION_FU;
        }
        if (_modTemp.equals((Object)ModificationTemplate.UNSATURATION_ZL)) {
            return ModificationTemplate.UNSATURATION_ZU;
        }
        if (_modTemp.equals((Object)ModificationTemplate.UNSATURATION_EL)) {
            return ModificationTemplate.UNSATURATION_EU;
        }
        return _modTemp;
    }
}

