/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.Scan;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportOptions;
import org.jdesktop.layout.GroupLayout;

public class ProfilesComparisonReportDialog
extends EscapeDialog
implements ActionListener,
ChangeListener {
    private GlycanWorkspace theWorkspace;
    private ProfilesComparisonReportOptions theOptions;
    private HashMap<String, Scan> nameScanMap = new HashMap();
    private HashMap<Scan, String> scanNameMap = new HashMap();
    private Vector<String> scanNames = new Vector();
    private Vector<Scan> firstGroup = new Vector();
    private Vector<Scan> secondGroup = new Vector();
    private JButton button_addfirst;
    private JButton button_addsecond;
    private JButton button_cancel;
    private JRadioButton button_deconvolution_terminals;
    private JRadioButton button_deconvolution_cores;
    private JRadioButton button_deconvolution_disaccharides;
    private JRadioButton button_deconvolution_monosaccharides;
    private JRadioButton button_deconvolution_none;
    private JRadioButton button_normalization_average;
    private JRadioButton button_normalization_basepeak;
    private JRadioButton button_normalization_standardization;
    private JRadioButton button_normalization_sum;
    private JCheckBox button_normalizebyrow;
    private JButton button_ok;
    private JButton button_removefirst;
    private JButton button_removesecond;
    private JRadioButton button_representation_bars;
    private JRadioButton button_representation_distributions;
    private JRadioButton button_representation_errorbars;
    private JRadioButton button_representation_table;
    private ButtonGroup buttongroup_deconvolution;
    private ButtonGroup buttongroup_normalization;
    private ButtonGroup buttongroup_representation;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JList list_firstgroup;
    private JList list_profiles;
    private JList list_secondgroup;

    public ProfilesComparisonReportDialog(Frame parent, GlycanWorkspace workspace, ProfilesComparisonReportOptions options) {
        super(parent, true);
        this.theWorkspace = workspace;
        this.theOptions = options;
        this.initComponents();
        this.setTraversal();
        this.setData();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
    }

    public Vector<Scan> getFirstGroup() {
        return this.firstGroup;
    }

    public Vector<Scan> getSecondGroup() {
        return this.secondGroup;
    }

    public Map<String, Scan> getNameScanMap() {
        return this.nameScanMap;
    }

    public Map<Scan, String> getScanNameMap() {
        return this.scanNameMap;
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.list_profiles);
        tp.addComponent((Component)this.button_addfirst);
        tp.addComponent((Component)this.button_removefirst);
        tp.addComponent((Component)this.list_firstgroup);
        tp.addComponent((Component)this.button_addsecond);
        tp.addComponent((Component)this.button_removesecond);
        tp.addComponent((Component)this.list_secondgroup);
        tp.addComponent((Component)this.button_normalization_basepeak);
        tp.addComponent((Component)this.button_normalization_sum);
        tp.addComponent((Component)this.button_normalization_average);
        tp.addComponent((Component)this.button_normalization_standardization);
        tp.addComponent((Component)this.button_deconvolution_none);
        tp.addComponent((Component)this.button_deconvolution_monosaccharides);
        tp.addComponent((Component)this.button_deconvolution_disaccharides);
        tp.addComponent((Component)this.button_deconvolution_cores);
        tp.addComponent((Component)this.button_deconvolution_terminals);
        tp.addComponent((Component)this.button_representation_table);
        tp.addComponent((Component)this.button_representation_bars);
        tp.addComponent((Component)this.button_representation_errorbars);
        tp.addComponent((Component)this.button_representation_distributions);
        tp.addComponent((Component)this.button_normalizebyrow);
        tp.addComponent((Component)this.button_ok);
        tp.addComponent((Component)this.button_cancel);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void addOrdered(JList dst, String s) {
        DefaultListModel dst_model = (DefaultListModel)dst.getModel();
        for (int i = 0; i < dst_model.getSize(); ++i) {
            if (this.scanNames.indexOf(dst_model.get(i)) <= this.scanNames.indexOf(s)) continue;
            dst_model.add(i, s);
            return;
        }
        dst_model.addElement(s);
    }

    private void getProfiles(GlycanWorkspace workspace) {
        int count = 1;
        for (Scan s : workspace.getAllScans()) {
            if (s.getAnnotatedPeakList().size() > 0 && s.getAnnotatedPeakList().getNoStructures() == 1 && s.getAnnotatedPeakList().getStructure(0).isEmpty()) {
                String scan_name = s.getName() != null && s.getName().length() > 0 && !s.getName().equals("Scan") ? s.getName() : "Scan" + count;
                this.nameScanMap.put(scan_name, s);
                this.scanNameMap.put(s, scan_name);
                this.scanNames.add(scan_name);
            }
            ++count;
        }
    }

    private void setData() {
        this.list_profiles.setModel(new DefaultListModel());
        this.list_firstgroup.setModel(new DefaultListModel());
        this.list_secondgroup.setModel(new DefaultListModel());
        this.getProfiles(this.theWorkspace);
        for (String s : this.scanNames) {
            this.addOrdered(this.list_profiles, s);
        }
        this.button_normalization_basepeak.setSelected(this.theOptions.NORMALIZATION == 1);
        this.button_normalization_sum.setSelected(this.theOptions.NORMALIZATION == 2);
        this.button_normalization_average.setSelected(this.theOptions.NORMALIZATION == 3);
        this.button_normalization_standardization.setSelected(this.theOptions.NORMALIZATION == 4);
        this.button_deconvolution_none.setSelected(this.theOptions.DECONVOLUTION == ProfilesComparisonReportOptions.NONE);
        this.button_deconvolution_monosaccharides.setSelected(this.theOptions.DECONVOLUTION == 1);
        this.button_deconvolution_disaccharides.setSelected(this.theOptions.DECONVOLUTION == 2);
        this.button_deconvolution_cores.setSelected(this.theOptions.DECONVOLUTION == 3);
        this.button_deconvolution_terminals.setSelected(this.theOptions.DECONVOLUTION == 4);
        this.button_representation_table.setSelected(this.theOptions.REPRESENTATION == 1);
        this.button_representation_bars.setSelected(this.theOptions.REPRESENTATION == 2);
        this.button_representation_errorbars.setSelected(this.theOptions.REPRESENTATION == 3);
        this.button_representation_distributions.setSelected(this.theOptions.REPRESENTATION == 4);
        this.button_normalizebyrow.setSelected(this.theOptions.NORMALIZEBYROW);
        this.pack();
    }

    private void setActions() {
        this.button_addfirst.addActionListener(this);
        this.button_removefirst.addActionListener(this);
        this.button_addsecond.addActionListener(this);
        this.button_removesecond.addActionListener(this);
        this.button_representation_table.addChangeListener(this);
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
        this.button_representation_table.setEnabled(this.list_secondgroup.getModel().getSize() == 0);
        this.button_representation_bars.setEnabled(this.list_secondgroup.getModel().getSize() == 0);
        this.button_representation_errorbars.setEnabled(this.list_secondgroup.getModel().getSize() > 0);
        this.button_representation_distributions.setEnabled(this.list_secondgroup.getModel().getSize() > 0);
    }

    private void retrieveData() {
        this.firstGroup = this.retrieveData(this.list_firstgroup);
        this.secondGroup = this.retrieveData(this.list_secondgroup);
        if (this.firstGroup.size() == 0) {
            this.firstGroup = this.retrieveData(this.list_profiles);
        }
        this.theOptions.NORMALIZATION = this.button_normalization_basepeak.isSelected() ? 1 : (this.button_normalization_sum.isSelected() ? 2 : (this.button_normalization_average.isSelected() ? 3 : (this.button_normalization_standardization.isSelected() ? 4 : 3)));
        this.theOptions.DECONVOLUTION = this.button_deconvolution_none.isSelected() ? ProfilesComparisonReportOptions.NONE : (this.button_deconvolution_monosaccharides.isSelected() ? 1 : (this.button_deconvolution_disaccharides.isSelected() ? 2 : (this.button_deconvolution_cores.isSelected() ? 3 : (this.button_deconvolution_terminals.isSelected() ? 4 : ProfilesComparisonReportOptions.DECONVOLUTION_DEFAULT))));
        this.theOptions.REPRESENTATION = this.button_representation_table.isSelected() && this.button_representation_table.isEnabled() ? 1 : (this.button_representation_bars.isSelected() && this.button_representation_bars.isEnabled() ? 2 : (this.button_representation_errorbars.isSelected() && this.button_representation_errorbars.isEnabled() ? 3 : (this.button_representation_distributions.isSelected() && this.button_representation_distributions.isEnabled() ? 4 : 1)));
        this.theOptions.NORMALIZEBYROW = this.button_normalizebyrow.isSelected();
    }

    private Vector<Scan> retrieveData(JList src) {
        DefaultListModel src_model = (DefaultListModel)src.getModel();
        Vector<Scan> ret = new Vector<Scan>();
        for (int i = 0; i < src_model.getSize(); ++i) {
            ret.add(this.nameScanMap.get((String)src_model.get(i)));
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData();
            this.return_status = action;
            this.closeDialog();
        } else if (action == "Cancel") {
            this.return_status = action;
            this.closeDialog();
        } else if (action == ">>") {
            if (e.getSource() == this.button_addfirst) {
                this.move(this.list_profiles, this.list_firstgroup);
            } else {
                this.move(this.list_profiles, this.list_secondgroup);
                this.enableItems();
            }
        } else if (action == "<<") {
            if (e.getSource() == this.button_removefirst) {
                this.move(this.list_firstgroup, this.list_profiles);
            } else {
                this.move(this.list_secondgroup, this.list_profiles);
                this.enableItems();
            }
        } else {
            this.enableItems();
        }
    }

    private void move(JList src, JList dst) {
        DefaultListModel src_model = (DefaultListModel)src.getModel();
        for (Object v : src.getSelectedValues()) {
            this.addOrdered(dst, (String)v);
            src_model.remove(src_model.indexOf(v));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enableItems();
    }

    private void initComponents() {
        this.buttongroup_normalization = new ButtonGroup();
        this.buttongroup_deconvolution = new ButtonGroup();
        this.buttongroup_representation = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.list_profiles = new JList();
        this.button_addfirst = new JButton();
        this.button_removefirst = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.list_firstgroup = new JList();
        this.button_addsecond = new JButton();
        this.button_removesecond = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.list_secondgroup = new JList();
        this.jLabel1 = new JLabel();
        this.button_normalization_basepeak = new JRadioButton();
        this.button_normalization_sum = new JRadioButton();
        this.button_normalization_average = new JRadioButton();
        this.button_normalization_standardization = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.button_deconvolution_monosaccharides = new JRadioButton();
        this.button_deconvolution_disaccharides = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.button_representation_table = new JRadioButton();
        this.button_representation_bars = new JRadioButton();
        this.button_representation_errorbars = new JRadioButton();
        this.button_representation_distributions = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.button_deconvolution_none = new JRadioButton();
        this.button_normalizebyrow = new JCheckBox();
        this.button_deconvolution_cores = new JRadioButton();
        this.button_deconvolution_terminals = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.list_profiles.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.list_profiles);
        this.button_addfirst.setText(">>");
        this.button_removefirst.setText("<<");
        this.list_firstgroup.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.list_firstgroup);
        this.button_addsecond.setText(">>");
        this.button_removesecond.setText("<<");
        this.list_secondgroup.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane3.setViewportView(this.list_secondgroup);
        this.jLabel1.setText("Normalizaton");
        this.buttongroup_normalization.add(this.button_normalization_basepeak);
        this.button_normalization_basepeak.setText("base peak");
        this.buttongroup_normalization.add(this.button_normalization_sum);
        this.button_normalization_sum.setText("sum");
        this.buttongroup_normalization.add(this.button_normalization_average);
        this.button_normalization_average.setText("average");
        this.buttongroup_normalization.add(this.button_normalization_standardization);
        this.button_normalization_standardization.setText("standardization");
        this.jLabel2.setText("Structure deconvolution");
        this.buttongroup_deconvolution.add(this.button_deconvolution_monosaccharides);
        this.button_deconvolution_monosaccharides.setText("monosaccharides");
        this.buttongroup_deconvolution.add(this.button_deconvolution_disaccharides);
        this.button_deconvolution_disaccharides.setText("disaccharides");
        this.jLabel3.setText("Representation");
        this.buttongroup_representation.add(this.button_representation_table);
        this.button_representation_table.setText("table");
        this.buttongroup_representation.add(this.button_representation_bars);
        this.button_representation_bars.setText("bars");
        this.buttongroup_representation.add(this.button_representation_errorbars);
        this.button_representation_errorbars.setText("error bars");
        this.buttongroup_representation.add(this.button_representation_distributions);
        this.button_representation_distributions.setText("distributions");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.jLabel4.setText("Profiles");
        this.jLabel5.setText("To compare");
        this.buttongroup_deconvolution.add(this.button_deconvolution_none);
        this.button_deconvolution_none.setText("none");
        this.button_normalizebyrow.setText("normalize by row");
        this.buttongroup_deconvolution.add(this.button_deconvolution_cores);
        this.button_deconvolution_cores.setText("cores");
        this.buttongroup_deconvolution.add(this.button_deconvolution_terminals);
        this.button_deconvolution_terminals.setText("terminals");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.button_representation_table).addPreferredGap(0).add((Component)this.button_representation_bars).addPreferredGap(0).add((Component)this.button_representation_errorbars).addPreferredGap(0).add((Component)this.button_representation_distributions)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 158, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.button_removesecond, -1, -1, Short.MAX_VALUE).add((Component)this.button_addsecond, 0, 0, Short.MAX_VALUE).add((Component)this.button_addfirst, -1, -1, Short.MAX_VALUE).add((Component)this.button_removefirst))).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel5).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jScrollPane3, -2, 183, -2).add((Component)this.jScrollPane2, -2, 183, -2))))).add((Component)this.button_normalizebyrow).add((Component)this.jSeparator1, -1, 418, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(135, 135, 135).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel)).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.button_normalization_basepeak).addPreferredGap(0).add((Component)this.button_normalization_sum).addPreferredGap(0).add((Component)this.button_normalization_average).addPreferredGap(0).add((Component)this.button_normalization_standardization)).add((Component)this.jLabel2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.button_deconvolution_none).addPreferredGap(0).add((Component)this.button_deconvolution_monosaccharides).addPreferredGap(0).add((Component)this.button_deconvolution_disaccharides)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.button_deconvolution_cores).addPreferredGap(0).add((Component)this.button_deconvolution_terminals))).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.linkSize(new Component[]{this.jScrollPane1, this.jScrollPane2, this.jScrollPane3}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.button_addfirst).addPreferredGap(0).add((Component)this.button_removefirst)).add((Component)this.jScrollPane2, -2, 84, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.button_addsecond).addPreferredGap(0).add((Component)this.button_removesecond)).add((Component)this.jScrollPane3, -2, 84, -2))).add((Component)this.jScrollPane1)).addPreferredGap(1).add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_normalization_basepeak).add((Component)this.button_normalization_sum).add((Component)this.button_normalization_average).add((Component)this.button_normalization_standardization)).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_deconvolution_monosaccharides).add((Component)this.button_deconvolution_disaccharides).add((Component)this.button_deconvolution_none)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_deconvolution_cores).add((Component)this.button_deconvolution_terminals)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel3).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_representation_table).add((Component)this.button_representation_bars).add((Component)this.button_representation_errorbars).add((Component)this.button_representation_distributions)).addPreferredGap(0).add((Component)this.button_normalizebyrow).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_ok).add((Component)this.button_cancel)).addContainerGap()));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private static class ScanCellRenderer
    extends DefaultListCellRenderer {
        private ScanCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
            } else if (value instanceof Scan) {
                this.setText(((Scan)value).getName());
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }
}

