/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakData;
import org.eurocarbdb.application.glycoworkbench.ScanData;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PluginManager;
import org.eurocarbdb.application.glycoworkbench.plugin.SpectraPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.PeakPickerCWT;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.PeakPickerOptionsDialog;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class SpectraPlugin
implements Plugin,
ActionListener {
    PluginManager theManager = null;
    GlycoWorkbench theApplication = null;
    GlycanWorkspace theWorkspace = null;
    PeakPickerCWT thePeakPicker = new PeakPickerCWT();
    SpectraPanel theSpectraPanel = new SpectraPanel();

    public SpectraPlugin(GlycoWorkbench application) {
        this.theApplication = application;
    }

    @Override
    public void init() {
        if (this.theWorkspace != null) {
            try {
                if (GlycoWorkbench.isFirstRun()) {
                    System.out.println("WARNING: SpectraPlugin detected first run");
                    System.out.println("WARNING: Going to store configuration and then reload to work around an unknown bug in the PeakPicker config on first launch");
                    this.thePeakPicker.retrieve(this.theWorkspace.getConfiguration());
                    this.theWorkspace.storeConfiguration(GlycoWorkbench.getConfigurationFile().getPath());
                    this.thePeakPicker = new PeakPickerCWT();
                    this.theWorkspace.getConfiguration().open(GlycoWorkbench.getConfigurationFile().getPath());
                }
            }
            catch (IOException ex) {
                LogUtils.report((Exception)ex);
            }
            this.thePeakPicker.retrieve(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public void exit() {
        if (this.theWorkspace != null) {
            this.thePeakPicker.store(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public String getName() {
        return "Spectra";
    }

    @Override
    public int getMnemonic() {
        return 83;
    }

    public ResizableIcon getResizableIcon() {
        return FileUtils.getThemeManager().getResizableIcon("spectradoc", Plugin.DEFAULT_ICON_SIZE).getResizableIcon();
    }

    @Override
    public ImageIcon getIcon() {
        return ThemeManager.getEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE);
    }

    @Override
    public int getViewPosition(String view) {
        return 2;
    }

    @Override
    public Component getLeftComponent() {
        return null;
    }

    @Override
    public Component getRightComponent() {
        return null;
    }

    @Override
    public Component getBottomComponent() {
        return this.theSpectraPanel;
    }

    @Override
    public Collection<String> getViews() {
        return Collections.singleton("Spectra");
    }

    @Override
    public Collection<GlycanAction> getActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        actions.add(new GlycanAction("addPeaks", this.theApplication.getThemeManager().getResizableIcon("addpeaks", Plugin.DEFAULT_ICON_SIZE), "Add selected peaks to the peak list", 65, "", (ActionListener)this));
        actions.add(new GlycanAction("annotatePeaks", this.theApplication.getThemeManager().getResizableIcon("annotatepeaks", Plugin.DEFAULT_ICON_SIZE), "Find possible annotations for selected peaks", 78, "", (ActionListener)this));
        actions.add(new GlycanAction("centroid", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Compute peak centroids", 67, "", (ActionListener)this));
        return actions;
    }

    @Override
    public Collection<GlycanAction> getToolbarActions() {
        return new Vector<GlycanAction>();
    }

    @Override
    public Collection<GlycanAction> getObjectActions(Object prototype, ActionListener al) {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public void setManager(PluginManager manager) {
        this.theManager = manager;
    }

    @Override
    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
        this.theSpectraPanel.setApplication(application);
    }

    @Override
    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        this.theSpectraPanel.setWorkspace(workspace);
    }

    @Override
    public PluginManager getManager() {
        return this.theManager;
    }

    @Override
    public GlycoWorkbench getApplication() {
        return this.theApplication;
    }

    @Override
    public GlycanWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    public SpectraPanel getSpectraPanel() {
        return this.theSpectraPanel;
    }

    @Override
    public void show(String view) throws Exception {
        if (!view.equals("Spectra")) {
            throw new Exception("Invalid view: " + view);
        }
    }

    @Override
    public boolean runAction(String action) throws Exception {
        if (action.equals("addPeaks")) {
            return this.theSpectraPanel.onAddPeaks();
        }
        if (action.equals("annotatePeaks")) {
            return this.theSpectraPanel.onAnnotatePeaks(null);
        }
        if (action.equals("centroid")) {
            return this.computeCentroids(this.theSpectraPanel.getCurrentInd());
        }
        throw new Exception("Invalid action: " + action);
    }

    @Override
    public boolean runAction(String action, Object param) throws Exception {
        if (action.equals("addIsotopeCurves")) {
            this.theSpectraPanel.addIsotopeCurves((TreeMap)param);
            return true;
        }
        return this.runAction(action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.runAction(GlycanAction.getAction((ActionEvent)e));
        }
        catch (Exception ex) {
            LogUtils.report((Exception)ex);
        }
    }

    @Override
    public void updateViews() {
        this.theSpectraPanel.updateView();
    }

    @Override
    public void updateMasses() {
    }

    public boolean computeCentroids(int ind) {
        if (this.theWorkspace.getSpectra() == null || this.theWorkspace.getSpectra().size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "Empty spectrum", "Error", 0);
            return false;
        }
        ScanData sd = this.theWorkspace.getSpectra().getScanDataAt(ind);
        PeakData pd = this.theWorkspace.getSpectra().getPeakDataAt(ind);
        this.thePeakPicker.store(this.theWorkspace.getConfiguration());
        this.thePeakPicker = new PeakPickerCWT();
        this.thePeakPicker.retrieve(this.theWorkspace.getConfiguration());
        PeakPickerOptionsDialog dlg = new PeakPickerOptionsDialog((Frame)((Object)this.theApplication), this.thePeakPicker);
        dlg.setVisible(true);
        if (dlg.getReturnStatus().equals("Cancel")) {
            return false;
        }
        double start_mz = dlg.getStartMZ();
        double end_mz = dlg.getEndMZ();
        if (this.theWorkspace.getPeakList().size() > 0 && JOptionPane.showConfirmDialog((Component)((Object)this.theApplication), "The current peaklist will be overwritten. Continue?", "Warning", 0) == 1) {
            return false;
        }
        this.theApplication.haltInteractions();
        try {
            int ms_level = this.theWorkspace.getCurrentScan().isMsMs() ? 2 : 1;
            Vector<Peak> picked_peaks = end_mz == 0.0 ? this.thePeakPicker.pick(pd.getData(), ms_level) : this.thePeakPicker.pick(pd.getData(start_mz, end_mz), ms_level);
            this.theApplication.restoreInteractions();
            if (picked_peaks.size() > 0) {
                this.theWorkspace.getPeakList().setData(picked_peaks);
                this.theManager.show("PeakList", "Chart");
                return true;
            }
            JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "No peaks found", "Warning", 2);
            return false;
        }
        catch (Exception e) {
            this.theApplication.restoreInteractions();
            LogUtils.report((Exception)e);
            return false;
        }
    }

    @Override
    public void completeSetup() {
    }

    @Override
    public List<JRibbonBand> getBandsForToolBar() {
        return null;
    }

    @Override
    public RibbonTask getRibbonTask() {
        return null;
    }
}

