/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptionsDialog;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.Scan;
import org.eurocarbdb.application.glycoworkbench.plugin.AnnotationThread;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakAnnotationCalibrationPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakAnnotationDetailsPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakAnnotationReportPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakAnnotationStatsPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakAnnotationSummaryPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PluginManager;
import org.eurocarbdb.application.glycoworkbench.plugin.ScanAnnotationCascadeThread;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class AnnotationPlugin
implements Plugin,
ActionListener {
    protected PluginManager theManager = null;
    protected GlycoWorkbench theApplication = null;
    protected GlycanWorkspace theWorkspace = null;
    protected JTabbedPane theAnnotationToolsPane = null;
    protected PeakAnnotationStatsPanel thePeakAnnotationStatsPanel = null;
    protected PeakAnnotationDetailsPanel thePeakAnnotationDetailsPanel = null;
    protected PeakAnnotationSummaryPanel thePeakAnnotationSummaryPanel = null;
    protected PeakAnnotationCalibrationPanel thePeakAnnotationCalibrationPanel = null;
    protected PeakAnnotationReportPanel thePeakAnnotationReportPanel = null;
    protected boolean first_time_run = true;
    protected boolean annotate = false;
    protected boolean showTopResults = true;
    protected AnnotationThread theThread = null;
    protected ProgressMonitor progressDialog = null;
    protected Timer activityMonitor = null;
    protected ScanAnnotationCascadeThread scanThread = null;
    protected HashMap<String, GlycanAction> publicActionMap = new HashMap();
    public static String PLUGIN_NAME = "Annotation";

    public AnnotationPlugin(GlycoWorkbench bench) {
        this.theApplication = bench;
        this.thePeakAnnotationStatsPanel = new PeakAnnotationStatsPanel();
        this.thePeakAnnotationDetailsPanel = new PeakAnnotationDetailsPanel();
        this.thePeakAnnotationSummaryPanel = new PeakAnnotationSummaryPanel();
        this.thePeakAnnotationCalibrationPanel = new PeakAnnotationCalibrationPanel();
        this.thePeakAnnotationReportPanel = new PeakAnnotationReportPanel();
        this.theAnnotationToolsPane = new JTabbedPane();
        this.theAnnotationToolsPane.add("Stats", this.thePeakAnnotationStatsPanel);
        this.theAnnotationToolsPane.add("Details", this.thePeakAnnotationDetailsPanel);
        this.theAnnotationToolsPane.add("Summary", this.thePeakAnnotationSummaryPanel);
        this.theAnnotationToolsPane.add("Calibration", this.thePeakAnnotationCalibrationPanel);
        GlycanAction glycanAction = new GlycanAction("matchFragments", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("canvas_annotate", Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with fragments from canvas", 78, "", (ActionListener)this);
        this.addActionToPublicMap(glycanAction);
    }

    public GlycanAction getAction(String action) {
        return this.publicActionMap.get(action);
    }

    private void addActionToPublicMap(GlycanAction glycanAction) {
        this.publicActionMap.put(glycanAction.getActionCommand(), glycanAction);
    }

    public PeakAnnotationStatsPanel getPeakAnnotationStatsPanel() {
        return this.thePeakAnnotationStatsPanel;
    }

    public PeakAnnotationDetailsPanel getPeakAnnotationDetailsPanel() {
        return this.thePeakAnnotationDetailsPanel;
    }

    public PeakAnnotationSummaryPanel getPeakAnnotationSummaryPanel() {
        return this.thePeakAnnotationSummaryPanel;
    }

    public PeakAnnotationCalibrationPanel getPeakAnnotationCalibrationPanel() {
        return this.thePeakAnnotationCalibrationPanel;
    }

    public PeakAnnotationReportPanel getPeakAnnotationReportPanel() {
        return this.thePeakAnnotationReportPanel;
    }

    @Override
    public void init() {
    }

    @Override
    public void exit() {
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public int getMnemonic() {
        return 65;
    }

    public ResizableIcon getResizableIcon() {
        return FileUtils.getThemeManager().getResizableIcon("annpeaksdoc", Plugin.DEFAULT_ICON_SIZE).getResizableIcon();
    }

    @Override
    public ImageIcon getIcon() {
        return ThemeManager.getEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE);
    }

    @Override
    public int getViewPosition(String view) {
        if (view.equals("Report")) {
            return 2;
        }
        return 1;
    }

    @Override
    public Component getLeftComponent() {
        return null;
    }

    @Override
    public Component getRightComponent() {
        return this.theAnnotationToolsPane;
    }

    @Override
    public Component getBottomComponent() {
        return this.thePeakAnnotationReportPanel;
    }

    @Override
    public Collection<String> getViews() {
        Vector<String> views = new Vector<String>();
        views.add("Stats");
        views.add("Details");
        views.add("Summary");
        views.add("Calibration");
        views.add("Report");
        return views;
    }

    @Override
    public Collection<GlycanAction> getActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        actions.add(new GlycanAction("options", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Set plugin options", 79, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("findFragmentsCurrent", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find all fragments of the current structure with a given m/z value", 67, "", (ActionListener)this));
        actions.add(new GlycanAction("findFragmentsSelected", this.theApplication.getThemeManager().getResizableIcon("findfragments", Plugin.DEFAULT_ICON_SIZE), "Find all fragments of the selected structures with a given m/z value", 83, "", (ActionListener)this));
        actions.add(new GlycanAction("findFragmentsAll", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find all fragments of all the structures with a given m/z value", 65, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("matchFragmentsCurrent", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with fragments from current structure", 85, "", (ActionListener)this));
        actions.add(new GlycanAction("matchFragmentsSelected", this.theApplication.getThemeManager().getResizableIcon("findfragments", Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with fragments from selected structures", 69, "", (ActionListener)this));
        actions.add(new GlycanAction("matchFragmentsAll", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with fragments from all structures", 76, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("placeAntennae", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Place uncertain antennae in current structure using the peak list", 80, "", (ActionListener)this));
        actions.add(new GlycanAction("cascadeAnnotation", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Cascade scan annotation", 66, "", (ActionListener)this));
        return actions;
    }

    @Override
    public Collection<GlycanAction> getToolbarActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        actions.add(new GlycanAction("findFragmentsSelected", this.theApplication.getThemeManager().getResizableIcon("findfragments", Plugin.DEFAULT_ICON_SIZE), "Find all fragments of the selected structures with a given m/z value", 83, "", (ActionListener)this));
        actions.add(new GlycanAction("matchFragmentsSelected", this.theApplication.getThemeManager().getResizableIcon("findfragments", Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with fragments from selected structures", 69, "", (ActionListener)this));
        return actions;
    }

    @Override
    public Collection<GlycanAction> getObjectActions(Object prototype, ActionListener al) {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public void setManager(PluginManager manager) {
        this.theManager = manager;
        if (this.theManager != null) {
            this.theManager.addMsMsPeakAction(new GlycanAction("findFragmentsSelected", this.theApplication.getThemeManager().getResizableIcon("findfragments", Plugin.DEFAULT_ICON_SIZE), "Find all fragments of the selected structures matching the peaks", 83, "", (ActionListener)this));
        }
    }

    @Override
    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
        this.thePeakAnnotationStatsPanel.setApplication(application);
        this.thePeakAnnotationDetailsPanel.setApplication(application);
        this.thePeakAnnotationSummaryPanel.setApplication(application);
        this.thePeakAnnotationCalibrationPanel.setApplication(application);
        this.thePeakAnnotationReportPanel.setApplication(application);
    }

    @Override
    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        this.thePeakAnnotationStatsPanel.setWorkspace(workspace);
        this.thePeakAnnotationDetailsPanel.setWorkspace(workspace);
        this.thePeakAnnotationSummaryPanel.setWorkspace(workspace);
        this.thePeakAnnotationCalibrationPanel.setWorkspace(workspace);
        this.thePeakAnnotationReportPanel.setWorkspace(workspace);
    }

    @Override
    public PluginManager getManager() {
        return this.theManager;
    }

    @Override
    public GlycoWorkbench getApplication() {
        return this.theApplication;
    }

    @Override
    public GlycanWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    @Override
    public void show(String view) throws Exception {
        if (view.equals("Stats")) {
            this.theAnnotationToolsPane.setSelectedComponent(this.thePeakAnnotationStatsPanel);
        } else if (view.equals("Details")) {
            this.theAnnotationToolsPane.setSelectedComponent(this.thePeakAnnotationDetailsPanel);
        } else if (view.equals("Summary")) {
            this.theAnnotationToolsPane.setSelectedComponent(this.thePeakAnnotationSummaryPanel);
        } else if (view.equals("Calibration")) {
            this.theAnnotationToolsPane.setSelectedComponent(this.thePeakAnnotationCalibrationPanel);
        } else if (!view.equals("Report")) {
            throw new Exception("Invalid view: " + view);
        }
    }

    @Override
    public boolean runAction(String action) throws Exception {
        if (action.startsWith("find")) {
            String m_z = JOptionPane.showInputDialog((Component)((Object)this.theApplication), "Insert m/z value", this.theWorkspace.getRecentMZValue());
            if (m_z != null) {
                Double mz_value = Double.valueOf(m_z);
                this.theWorkspace.setRecentMZValue(mz_value);
                return this.runAction(true, action, (Object)new PeakList(mz_value));
            }
            return false;
        }
        return this.runAction(true, action, (Object)this.theWorkspace.getPeakList());
    }

    @Override
    public boolean runAction(String action, Object params) throws Exception {
        if (this.runAction(this.first_time_run, action, params)) {
            this.first_time_run = false;
            return true;
        }
        return false;
    }

    public boolean runAction(boolean ask, String action, Object params) throws Exception {
        if (!(params instanceof PeakList)) {
            throw new Exception("Invalid param object: PeakList needed");
        }
        PeakList peaks = (PeakList)((Object)params);
        if (action.equals("options")) {
            return this.setOptions();
        }
        if (action.equals("findFragmentsCurrent")) {
            this.annotate = false;
            this.theApplication.getCanvas().enforceSelection();
            if (this.matchAllFragments(ask, this.theApplication.getCanvas().getCurrentStructure(), peaks)) {
                this.theManager.show("Search", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("matchFragments")) {
            action = this.theApplication.getCanvas().getSelectedStructures().size() > 0 ? "matchFragmentsSelected" : "matchFragmentsAll";
        }
        if (action.equals("findFragmentsSelected")) {
            this.annotate = false;
            this.theApplication.getCanvas().enforceSelection();
            if (this.matchAllFragments(ask, this.theApplication.getCanvas().getSelectedStructures(), peaks)) {
                this.theManager.show("Search", this.theApplication.getCanvas().getSelectedStructures().size() > 1 ? "Summary" : "Details");
                return true;
            }
            return false;
        }
        if (action.equals("findFragmentsAll")) {
            this.annotate = false;
            if (this.matchAllFragments(ask, this.theWorkspace.getStructures().getStructures(), peaks)) {
                this.theManager.show("Search", this.theWorkspace.getStructures().size() > 1 ? "Summary" : "Details");
                return true;
            }
            return false;
        }
        if (action.equals("matchFragmentsCurrent")) {
            this.annotate = true;
            this.theApplication.getCanvas().enforceSelection();
            if (this.matchAllFragments(ask, this.theApplication.getCanvas().getCurrentStructure(), peaks)) {
                this.theManager.show("Annotation", "Stats");
                return true;
            }
            return false;
        }
        if (action.equals("matchFragmentsSelected")) {
            this.annotate = true;
            this.theApplication.getCanvas().enforceSelection();
            if (this.matchAllFragments(ask, this.theApplication.getCanvas().getSelectedStructures(), peaks)) {
                this.theManager.show("Annotation", "Stats");
                return true;
            }
            return false;
        }
        if (action.equals("matchFragmentsAll")) {
            this.annotate = true;
            if (this.matchAllFragments(ask, this.theWorkspace.getStructures().getStructures(), peaks)) {
                this.theManager.show("Annotation", "Stats");
                return true;
            }
            return false;
        }
        if (action.equals("placeAntennae")) {
            this.annotate = true;
            this.theApplication.getCanvas().enforceSelection();
            if (this.placeAntennae(ask, this.theApplication.getCanvas().getCurrentStructure(), peaks)) {
                this.theManager.show("Annotation", "Stats");
                return true;
            }
            return false;
        }
        if (action.equals("cascadeAnnotation")) {
            this.annotate = true;
            if (this.scanAnnotationCascade(ask, this.getWorkspace().getAllParentScans())) {
                this.theManager.show("Annotation", "Stats");
                this.getWorkspace().fireDocumentChanged();
                return true;
            }
            return false;
        }
        throw new Exception("Invalid action: " + action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.runAction(GlycanAction.getAction((ActionEvent)e));
        }
        catch (Exception ex) {
            LogUtils.report((Exception)ex);
        }
    }

    @Override
    public void updateViews() {
        this.thePeakAnnotationStatsPanel.updateView();
        this.thePeakAnnotationDetailsPanel.updateView();
        this.thePeakAnnotationSummaryPanel.updateView();
        this.thePeakAnnotationCalibrationPanel.updateView();
        this.thePeakAnnotationReportPanel.updateView();
    }

    @Override
    public void updateMasses() {
    }

    public boolean setOptions() {
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        AnnotationOptionsDialog adlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, false, false);
        adlg.setVisible(true);
        return adlg.getReturnStatus().equals("OK");
    }

    public boolean matchAllFragments(boolean ask_options, Glycan structure, PeakList peaks) {
        if (structure != null) {
            return this.matchAllFragments(ask_options, Collections.singleton(structure), peaks);
        }
        return false;
    }

    public boolean scanAnnotationCascade(boolean ask, Vector<Scan> parentScans) {
        if (this.setAnnotationOptions(ask)) {
            this.theApplication.haltInteractions();
            this.showTopResults = false;
            this.scanThread = new ScanAnnotationCascadeThread(parentScans, this.theWorkspace.getFragmentOptions(), this.theWorkspace.getAnnotationOptions());
            this.scanThread.start();
            this.progressDialog = new ProgressMonitor((Component)((Object)this.theApplication), "Parent scans completed", null, 0, this.scanThread.getTarget());
            this.activityMonitor = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int progress = AnnotationPlugin.this.scanThread.getProgress();
                    AnnotationPlugin.this.progressDialog.setProgress(progress);
                    if (progress == AnnotationPlugin.this.scanThread.getTarget() || AnnotationPlugin.this.progressDialog.isCanceled()) {
                        System.err.println("Stopping activity monitor");
                        AnnotationPlugin.this.activityMonitor.stop();
                        AnnotationPlugin.this.progressDialog.close();
                        if (progress != AnnotationPlugin.this.scanThread.getTarget()) {
                            AnnotationPlugin.this.scanThread.interrupt();
                            AnnotationPlugin.this.onAnnotationAborted(AnnotationPlugin.this.scanThread);
                        } else {
                            AnnotationPlugin.this.onAnnotationCompleted(AnnotationPlugin.this.scanThread);
                        }
                    }
                }
            });
            this.activityMonitor.start();
        }
        return true;
    }

    public boolean setAnnotationOptions(boolean ask_options) {
        if (ask_options) {
            AnnotationOptionsDialog dlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), this.theWorkspace.getFragmentOptions(), this.theWorkspace.getAnnotationOptions(), true, true);
            dlg.setVisible(true);
            return dlg.getReturnStatus().equals("OK");
        }
        return true;
    }

    public boolean matchAllFragments(boolean ask_options, Collection<Glycan> structures, PeakList peaks) {
        Fragmenter frag;
        if (structures == null || structures.size() == 0) {
            return false;
        }
        if (peaks.size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "You must load a peak list first", "Error", 0);
            return false;
        }
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        if (ask_options) {
            AnnotationOptionsDialog dlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, true, true);
            dlg.setVisible(true);
            if (!dlg.getReturnStatus().equals("OK")) {
                return false;
            }
        }
        if (ann_opt.CLEAR_EXISTING_ANNOTATIONS) {
            this.theWorkspace.getAnnotatedPeakList().clear();
        }
        if (((frag = new Fragmenter(frag_opt)).getComputeAFragments() || frag.getComputeXFragments()) && ask_options) {
            for (Glycan s : structures) {
                if (s.checkLinkages()) continue;
                if (JOptionPane.showConfirmDialog((Component)((Object)this.theApplication), "Cross ring fragments will not be computed for residues with incomplete linkage or anomeric information. Continue?", "Warning", 0) != 1) break;
                return false;
            }
        }
        this.theApplication.haltInteractions();
        this.showTopResults = false;
        return this.runAnnotation(peaks, structures, frag, ann_opt);
    }

    public boolean placeAntennae(boolean ask_options, Glycan current, PeakList peaks) {
        Fragmenter frag;
        if (current == null) {
            return false;
        }
        if (current.getNoAntennae() > 2) {
            JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "This features is still experimental and the maximum number of antennae that can be placed is set to two.", "Warning", 2);
            return false;
        }
        if (peaks.size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "You must load a peak list first", "Error", 0);
            return false;
        }
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        if (ask_options) {
            AnnotationOptionsDialog dlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, true, true);
            dlg.hideClearAnnotationOption();
            dlg.setVisible(true);
            if (!dlg.getReturnStatus().equals("OK")) {
                return false;
            }
        }
        if (((frag = new Fragmenter(frag_opt)).getComputeAFragments() || frag.getComputeXFragments()) && ask_options && !current.checkLinkages() && JOptionPane.showConfirmDialog((Component)((Object)this.theApplication), "Cross ring fragments will not be computed for residues with incomplete linkage or anomeric information. Continue?", "Warning", 0) == 1) {
            return false;
        }
        this.theApplication.haltInteractions();
        Vector<Glycan> structures = new Vector<Glycan>();
        current.placeAntennae(structures);
        this.showTopResults = true;
        return this.runAnnotation(peaks, structures, frag, ann_opt);
    }

    protected boolean runAnnotation(PeakList _peaks, Collection<Glycan> _structures, Fragmenter _fragmenter, AnnotationOptions _ann_opt) {
        this.theThread = new AnnotationThread(_peaks, _structures, _fragmenter, _ann_opt);
        this.theThread.start();
        this.progressDialog = new ProgressMonitor((Component)((Object)this.theApplication), "Matching peaks with fragments", null, 0, this.theThread.getTarget());
        this.activityMonitor = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int progress = AnnotationPlugin.this.theThread.getProgress();
                AnnotationPlugin.this.progressDialog.setProgress(progress);
                if (progress == AnnotationPlugin.this.theThread.getTarget() || AnnotationPlugin.this.progressDialog.isCanceled()) {
                    System.err.println("Stopping activity monitor");
                    AnnotationPlugin.this.activityMonitor.stop();
                    AnnotationPlugin.this.progressDialog.close();
                    if (progress != AnnotationPlugin.this.theThread.getTarget()) {
                        AnnotationPlugin.this.theThread.interrupt();
                        AnnotationPlugin.this.onAnnotationAborted(AnnotationPlugin.this.theThread);
                    } else {
                        AnnotationPlugin.this.onAnnotationCompleted(AnnotationPlugin.this.theThread);
                    }
                }
            }
        });
        System.err.println("Starting activity monitor");
        this.activityMonitor.start();
        return true;
    }

    protected void onAnnotationCompleted(AnnotationThread t) {
        AnnotatedPeakList dest = null;
        if (this.annotate) {
            dest = this.theWorkspace.getAnnotatedPeakList();
        } else {
            dest = this.theWorkspace.getSearchResults();
            this.theWorkspace.setSearchGenerator(this);
        }
        if (this.showTopResults) {
            dest.copy(t.getAnnotatedPeaks().getFirst(20));
        } else {
            dest.copy(t.getAnnotatedPeaks());
        }
        this.theApplication.restoreInteractions();
        if (t.getNonEmptyStructures() > 0 && t.hasFuzzyStructures()) {
            if (t.getNonEmptyStructures() == 1) {
                JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "Cannot compute fragments for structures with uncertain terminals", "Error", 0);
            } else if (t.hasNonFuzzyStructures()) {
                JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "Cannot compute fragments for some structures with uncertain terminals", "Error", 0);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "Cannot compute fragments, all structures have uncertain terminals", "Error", 0);
            }
        }
    }

    protected void onAnnotationAborted(AnnotationThread t) {
        this.theApplication.restoreInteractions();
    }

    protected void onAnnotationAborted(ScanAnnotationCascadeThread scanThread) {
        this.theApplication.restoreInteractions();
    }

    protected void onAnnotationCompleted(ScanAnnotationCascadeThread t) {
        HashMap<Scan, AnnotatedPeakList> scanToAnnotatedPeakList = t.getScanToAnnotatedPeaks();
        for (Scan scan : scanToAnnotatedPeakList.keySet()) {
            this.theWorkspace.setCurrentScan(scan);
            AnnotatedPeakList dest = null;
            if (this.annotate) {
                dest = this.theWorkspace.getAnnotatedPeakList();
            } else {
                dest = this.theWorkspace.getSearchResults();
                this.theWorkspace.setSearchGenerator(this);
            }
            if (this.showTopResults) {
                dest.copy(scanToAnnotatedPeakList.get(scan).getFirst(20));
                continue;
            }
            dest.copy(scanToAnnotatedPeakList.get(scan));
        }
        this.theApplication.restoreInteractions();
    }

    @Override
    public void completeSetup() {
    }

    @Override
    public List<JRibbonBand> getBandsForToolBar() {
        return null;
    }

    @Override
    public RibbonTask getRibbonTask() {
        return null;
    }
}

