/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.sugar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

public class SugarUnitRepeat
extends GlycoNode
implements GlycoGraph {
    public static final int UNKNOWN = -1;
    private GlycoEdge m_linkRepeatLinkage = null;
    private int m_iMinCount = -1;
    private int m_iMaxCount = -1;
    private ArrayList<GlycoNode> m_aResidues = new ArrayList();
    private ArrayList<UnderdeterminedSubTree> m_aSpezialTrees = new ArrayList();

    public SugarUnitRepeat() {
        this.m_aResidues.clear();
    }

    public int getMinRepeatCount() {
        return this.m_iMinCount;
    }

    public int getMaxRepeatCount() {
        return this.m_iMaxCount;
    }

    public void setMinRepeatCount(int a_iCount) {
        this.m_iMinCount = a_iCount;
    }

    public void setMaxRepeatCount(int a_iCount) {
        this.m_iMaxCount = a_iCount;
    }

    public void setRepeatLinkage(GlycoEdge a_objLinkage, GlycoNode a_objParent, GlycoNode a_objChild) throws GlycoconjugateException {
        if (a_objChild == null || a_objLinkage == null || a_objParent == null) {
            throw new GlycoconjugateException("null is not valide for a internal repeat linkage and residue.");
        }
        this.m_linkRepeatLinkage = a_objLinkage;
        this.m_linkRepeatLinkage.setParent(a_objParent);
        this.m_linkRepeatLinkage.setChild(a_objChild);
    }

    public GlycoEdge getRepeatLinkage() {
        return this.m_linkRepeatLinkage;
    }

    @Override
    public void accept(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        a_objVisitor.visit(this);
    }

    @Override
    public ArrayList<GlycoNode> getRootNodes() throws GlycoconjugateException {
        ArrayList<GlycoNode> t_aResult = new ArrayList<GlycoNode>();
        Iterator<GlycoNode> t_iterResidue = this.getNodeIterator();
        while (t_iterResidue.hasNext()) {
            GlycoNode t_objResidue = t_iterResidue.next();
            GlycoEdge t_objParents = t_objResidue.getParentEdge();
            if (t_objParents != null) continue;
            t_aResult.add(t_objResidue);
        }
        if (t_aResult.size() < 1) {
            throw new GlycoconjugateException("Repeat unit seems not to have at least one root residue");
        }
        return t_aResult;
    }

    @Override
    public Iterator<GlycoNode> getNodeIterator() {
        return this.m_aResidues.iterator();
    }

    @Override
    public boolean isConnected() throws GlycoconjugateException {
        ArrayList<GlycoNode> t_objRoots = this.getRootNodes();
        return t_objRoots.size() <= 1;
    }

    @Override
    public boolean removeNode(GlycoNode a_objResidue) throws GlycoconjugateException {
        GlycoNode t_objResidue;
        GlycoEdge t_objLinkage2;
        if (a_objResidue == null) {
            throw new GlycoconjugateException("Invalide residue.");
        }
        if (a_objResidue.getClass() != SugarUnitCyclic.class) {
            this.searchCyclicForDeleting(a_objResidue);
        }
        if ((t_objLinkage2 = a_objResidue.getParentEdge()) != null) {
            t_objResidue = t_objLinkage2.getParent();
            if (t_objResidue == null) {
                throw new GlycoconjugateException("A linkage with a null parent exists.");
            }
            t_objResidue.removeChildEdge(t_objLinkage2);
        }
        for (GlycoEdge t_objLinkage2 : a_objResidue.getChildEdges()) {
            t_objResidue = t_objLinkage2.getChild();
            if (t_objResidue == null) {
                throw new GlycoconjugateException("A linkage with a null child exists.");
            }
            t_objResidue.removeParentEdge(t_objLinkage2);
        }
        return this.m_aResidues.remove(a_objResidue);
    }

    @Override
    public ArrayList<GlycoNode> getNodes() {
        return this.m_aResidues;
    }

    @Override
    public boolean addNode(GlycoNode a_objResidue) throws GlycoconjugateException {
        if (a_objResidue == null) {
            throw new GlycoconjugateException("Invalide residue.");
        }
        if (!this.m_aResidues.contains(a_objResidue)) {
            try {
                GlycoVisitorNodeType t_objNodeType = new GlycoVisitorNodeType();
                if (t_objNodeType.isSugarUnitCyclic(a_objResidue)) {
                    throw new GlycoconjugateException("Cyclic unit are not allowed in repeat units.");
                }
            }
            catch (GlycoVisitorException e) {
                throw new GlycoconjugateException(e.getMessage(), e);
            }
            a_objResidue.removeAllEdges();
            return this.m_aResidues.add(a_objResidue);
        }
        return false;
    }

    @Override
    public boolean addNode(GlycoNode a_objParent, GlycoEdge a_objLinkage, GlycoNode a_objChild) throws GlycoconjugateException {
        if (a_objParent == null || a_objChild == null) {
            throw new GlycoconjugateException("Invalide residue.");
        }
        if (a_objLinkage == null) {
            throw new GlycoconjugateException("Invalide linkage.");
        }
        if (a_objChild.getParentEdge() != null) {
            throw new GlycoconjugateException("The child residue has a parent residue.");
        }
        this.addNode(a_objChild);
        this.addNode(a_objParent);
        if (!this.m_aResidues.contains(a_objChild) || !this.m_aResidues.contains(a_objParent)) {
            throw new GlycoconjugateException("Could not add residue to repeat unit.");
        }
        if (this.isParent(a_objChild, a_objParent)) {
            throw new GlycoconjugateException("You try to create a cyclic sugar, cyclic units are not allowed in repeat units.");
        }
        a_objChild.setParentEdge(a_objLinkage);
        a_objParent.addChildEdge(a_objLinkage);
        a_objLinkage.setChild(a_objChild);
        a_objLinkage.setParent(a_objParent);
        return true;
    }

    @Override
    public boolean addEdge(GlycoNode a_objParent, GlycoNode a_objChild, GlycoEdge a_objLinkage) throws GlycoconjugateException {
        return this.addNode(a_objParent, a_objLinkage, a_objChild);
    }

    @Override
    public boolean containsNode(GlycoNode a_objNode) {
        return this.m_aResidues.contains(a_objNode);
    }

    private void searchCyclicForDeleting(GlycoNode a_objResidue) throws GlycoconjugateException {
        for (GlycoNode t_objElement : this.m_aResidues) {
            SugarUnitCyclic t_objCyclic;
            if (t_objElement.getClass() != SugarUnitCyclic.class || (t_objCyclic = (SugarUnitCyclic)t_objElement).getCyclicStart() != a_objResidue) continue;
            this.removeNode(t_objElement);
        }
    }

    @Override
    public boolean isParent(GlycoNode a_objParent, GlycoNode a_objNode) {
        GlycoNode t_objParent = a_objNode.getParentNode();
        if (t_objParent == null) {
            return false;
        }
        if (t_objParent == a_objParent) {
            return true;
        }
        return this.isParent(a_objParent, t_objParent);
    }

    @Override
    public boolean removeEdge(GlycoEdge a_objEdge) throws GlycoconjugateException {
        if (a_objEdge == null) {
            return false;
        }
        GlycoNode t_objChild = a_objEdge.getChild();
        GlycoNode t_objParent = a_objEdge.getParent();
        if (t_objChild == null || t_objParent == null) {
            throw new GlycoconjugateException("The edge contains null values.");
        }
        if (t_objChild.getParentEdge() != a_objEdge) {
            throw new GlycoconjugateException("The child attachment is not correct");
        }
        ArrayList<GlycoEdge> t_aEdges = t_objParent.getChildEdges();
        if (!t_aEdges.contains(a_objEdge)) {
            throw new GlycoconjugateException("The parent attachment is not correct");
        }
        t_objChild.removeParentEdge(a_objEdge);
        t_objParent.removeChildEdge(a_objEdge);
        return true;
    }

    @Override
    public SugarUnitRepeat copy() throws GlycoconjugateException {
        GlycoEdge t_objLinkCopy;
        GlycoEdge t_objLinkOriginal2;
        GlycoNode t_objNodeTwo;
        GlycoNode t_objNodeOne2;
        ArrayList t_aAlternative = new ArrayList();
        HashMap<GlycoNode, GlycoNode> t_hashResidues = new HashMap<GlycoNode, GlycoNode>();
        SugarUnitRepeat t_objCopy = new SugarUnitRepeat();
        GlycoVisitorNodeType t_visNodeType = new GlycoVisitorNodeType();
        for (GlycoNode t_objNodeOne2 : this.m_aResidues) {
            try {
                if (t_visNodeType.isSugarUnitCyclic(t_objNodeOne2)) continue;
                if (t_visNodeType.isSugarUnitAlternative(t_objNodeOne2)) {
                    throw new GlycoconjugateException("Unable to copy alternative residues.");
                }
                t_objNodeTwo = t_objNodeOne2.copy();
                t_hashResidues.put(t_objNodeOne2, t_objNodeTwo);
                t_objCopy.addNode(t_objNodeTwo);
            }
            catch (GlycoVisitorException e) {
                throw new GlycoconjugateException(e.getMessage(), e);
            }
        }
        for (GlycoNode t_objNodeOne2 : this.m_aResidues) {
            ArrayList<GlycoEdge> t_aLinkages = t_objNodeOne2.getChildEdges();
            for (GlycoEdge t_objLinkOriginal2 : t_aLinkages) {
                t_objLinkCopy = t_objLinkOriginal2.copy();
                t_objNodeOne2 = (GlycoNode)t_hashResidues.get(t_objLinkOriginal2.getParent());
                t_objNodeTwo = (GlycoNode)t_hashResidues.get(t_objLinkOriginal2.getChild());
                if (t_objNodeOne2 == null || t_objNodeTwo == null) {
                    throw new GlycoconjugateException("Impossible to copy repeat unit. Null values in copy.");
                }
                t_objCopy.addEdge(t_objNodeOne2, t_objNodeTwo, t_objLinkCopy);
            }
        }
        t_objLinkOriginal2 = this.m_linkRepeatLinkage;
        t_objLinkCopy = t_objLinkOriginal2.copy();
        t_objNodeOne2 = (GlycoNode)t_hashResidues.get(t_objLinkOriginal2.getParent());
        t_objNodeTwo = (GlycoNode)t_hashResidues.get(t_objLinkOriginal2.getChild());
        if (t_objNodeOne2 == null || t_objNodeTwo == null) {
            throw new GlycoconjugateException("Impossible to copy repeat unit. Null values in copy.");
        }
        t_objCopy.setRepeatLinkage(t_objLinkCopy, t_objNodeOne2, t_objNodeTwo);
        t_objCopy.setMinRepeatCount(this.m_iMinCount);
        t_objCopy.setMaxRepeatCount(this.m_iMaxCount);
        for (SugarUnitAlternative t_objAlternative : t_aAlternative) {
            HashMap<GlycoNode, GlycoNode> t_objMapNew = new HashMap<GlycoNode, GlycoNode>();
            for (GlycoGraphAlternative t_objAltGraph : t_objAlternative.getAlternatives()) {
                t_objMapNew.clear();
                HashMap<GlycoNode, GlycoNode> t_objMapOld = t_objAltGraph.getLeadOutNodeToNode();
                for (GlycoNode t_objKeyNode : t_objMapOld.keySet()) {
                    GlycoNode t_objKeyNodeNew = (GlycoNode)t_hashResidues.get(t_objKeyNode);
                    if (t_objKeyNodeNew == null) {
                        throw new GlycoconjugateException("Error child attache position of alternative graph was not translated.");
                    }
                    t_objMapNew.put(t_objKeyNodeNew, t_objMapOld.get(t_objKeyNode));
                }
                t_objAlternative.setLeadOutNodeToNode(t_objMapNew, t_objAltGraph);
            }
        }
        for (UnderdeterminedSubTree t_objTreeOriginal : this.m_aSpezialTrees) {
            UnderdeterminedSubTree t_objTreeCopy = t_objTreeOriginal.copy();
            t_objCopy.addUndeterminedSubTree(t_objTreeCopy);
            for (GlycoNode t_objNodeOne2 : t_objTreeOriginal.getParents()) {
                t_objNodeTwo = (GlycoNode)t_hashResidues.get(t_objNodeOne2);
                if (t_objNodeTwo == null) {
                    throw new GlycoconjugateException("Impossible to copy repeat unit. Null values in copy.");
                }
                t_objTreeCopy.addParent(t_objNodeTwo);
            }
        }
        return t_objCopy;
    }

    public void setUndeterminedSubTrees(ArrayList<UnderdeterminedSubTree> a_aSubTree) throws GlycoconjugateException {
        if (a_aSubTree == null) {
            throw new GlycoconjugateException("null is not a valide set of special subtrees.");
        }
        this.m_aSpezialTrees.clear();
        Iterator<UnderdeterminedSubTree> t_iterTree = a_aSubTree.iterator();
        while (t_iterTree.hasNext()) {
            this.addUndeterminedSubTree(t_iterTree.next());
        }
    }

    public ArrayList<UnderdeterminedSubTree> getUndeterminedSubTrees() {
        return this.m_aSpezialTrees;
    }

    public boolean addUndeterminedSubTreeParent(UnderdeterminedSubTree a_objTree, GlycoNode a_objParent) throws GlycoconjugateException {
        if (!this.m_aResidues.contains(a_objParent)) {
            throw new GlycoconjugateException("Parent is not part of the sugar.");
        }
        if (!this.m_aSpezialTrees.contains(a_objTree)) {
            throw new GlycoconjugateException("UnderdeterminedSubTree is not part of the sugar.");
        }
        return a_objTree.addParent(a_objParent);
    }

    public boolean addUndeterminedSubTree(UnderdeterminedSubTree a_objTree) throws GlycoconjugateException {
        if (a_objTree == null) {
            throw new GlycoconjugateException("null is not valide for special subtree.");
        }
        if (!this.m_aSpezialTrees.contains(a_objTree)) {
            return this.m_aSpezialTrees.add(a_objTree);
        }
        return false;
    }

    public void setRepeatCount(int a_iCount) {
        this.setMinRepeatCount(a_iCount);
        this.setMaxRepeatCount(a_iCount);
    }
}

