/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.sugar;

import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;

public enum Anomer {
    Alpha("alpha", "a"),
    Beta("beta", "b"),
    OpenChain("open-chain", "o"),
    Unknown("unknown", "x");

    private String m_strFullname;
    private String m_strSymbol;

    private Anomer(String fullname, String symbol) {
        this.m_strFullname = fullname;
        this.m_strSymbol = symbol;
    }

    public String getName() {
        return this.m_strFullname;
    }

    public String getSymbol() {
        return this.m_strSymbol;
    }

    public static Anomer forName(String anomer) throws GlycoconjugateException {
        Anomer[] anomerArray = Anomer.values();
        int n = anomerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Anomer a = anomerArray[n2];
            if (anomer.equals(a.m_strFullname)) {
                return a;
            }
            ++n2;
        }
        throw new GlycoconjugateException("Invalid value for anomer");
    }

    public static Anomer forSymbol(char anomer) throws GlycoconjugateException {
        Anomer[] anomerArray = Anomer.values();
        int n = anomerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Anomer a = anomerArray[n2];
            if (anomer == a.m_strSymbol.charAt(0)) {
                return a;
            }
            ++n2;
        }
        throw new GlycoconjugateException("Invalid value for anomer");
    }

    public static Anomer forSymbol(String anomer) throws GlycoconjugateException {
        Anomer[] anomerArray = Anomer.values();
        int n = anomerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Anomer a = anomerArray[n2];
            if (a.m_strSymbol.equals(anomer)) {
                return a;
            }
            ++n2;
        }
        throw new GlycoconjugateException("Invalid value for anomer");
    }
}

