/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.cabosml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.GlycoCTLinkageComparator;
import org.eurocarbdb.MolecularFramework.io.SugarImporter;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Anomer;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SugarImporterCabosML
extends SugarImporter {
    private Document m_objDocument = null;
    private String m_strID = null;
    private GlycoEdge m_edge = null;
    private HashMap<SubstituentType, LinkageType> m_hSubstPositionOne = new HashMap();
    private HashMap<SubstituentType, LinkageType> m_hSubstPositionTwo = new HashMap();

    public SugarImporterCabosML() {
        this.m_hSubstPositionOne.put(SubstituentType.N_ACETYL, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.ETHYL, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.SULFATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.N_GLYCOLYL, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.AMINO, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.HYDROXYMETHYL, LinkageType.H_LOSE);
        this.m_hSubstPositionOne.put(SubstituentType.ACETYL, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.PHOSPHATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.N_SULFATE, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.ANHYDRO, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.N_FORMYL, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.PYRUVATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.FLOURO, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.CHLORO, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.N_AMIDINO, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.R_CARBOXYETHYL, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.DIPHOSPHO_ETHANOLAMINE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.PHOSPHO_ETHANOLAMINE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.ETHANOLAMINE, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.GLYCOLYL, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.THIO, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.S_PYRUVATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.N_METHYL, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.R_PYRUVATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.IODO, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.N_SUCCINATE, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.BROMO, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.N_DIMETHYL, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.LACTONE, LinkageType.DEOXY);
        this.m_hSubstPositionOne.put(SubstituentType.PYROPHOSPHATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.R_LACTATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.S_LACTATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.X_LACTATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionOne.put(SubstituentType.TRIPHOSPHATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionTwo.put(SubstituentType.PHOSPHATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionTwo.put(SubstituentType.ANHYDRO, LinkageType.H_AT_OH);
        this.m_hSubstPositionTwo.put(SubstituentType.PYRUVATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionTwo.put(SubstituentType.S_PYRUVATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionTwo.put(SubstituentType.R_PYRUVATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionTwo.put(SubstituentType.LACTONE, LinkageType.H_AT_OH);
        this.m_hSubstPositionTwo.put(SubstituentType.AMINO, LinkageType.DEOXY);
        this.m_hSubstPositionTwo.put(SubstituentType.ETHANOLAMINE, LinkageType.H_AT_OH);
        this.m_hSubstPositionTwo.put(SubstituentType.PYROPHOSPHATE, LinkageType.H_AT_OH);
        this.m_hSubstPositionTwo.put(SubstituentType.TRIPHOSPHATE, LinkageType.H_AT_OH);
    }

    public String getID() {
        return this.m_strID;
    }

    @Override
    public Sugar parse(String a_strXML) throws SugarImporterException {
        SAXBuilder builder = new SAXBuilder();
        this.m_objSugar = new Sugar();
        try {
            this.m_objDocument = builder.build((Reader)new StringReader(a_strXML));
            if (builder.getValidation()) {
                throw new SugarImporterException("XML Validation error");
            }
            Element t_root = this.m_objDocument.getRootElement();
            if (!t_root.getName().equals("Glyco")) {
                throw new SugarImporterException("Missing tag: Glyco.");
            }
            List t_lMainElements = this.m_objDocument.getRootElement().getChildren();
            for (Element t_element : t_lMainElements) {
                if (t_element.getName().equals("Carb_ID")) {
                    this.m_strID = t_element.getTextTrim();
                    continue;
                }
                if (t_element.getName().equals("Carb_structure")) {
                    List t_aChilds = t_element.getChildren();
                    if (t_aChilds.size() != 1) {
                        throw new SugarImporterException("More than one sub-tag found in Carb_structure.");
                    }
                    for (Element element : t_aChilds) {
                        if (!element.getName().equals("MS")) {
                            throw new SugarImporterException("Subtag is not a MS tag: " + element.getName());
                        }
                        this.parseRoot(element);
                    }
                    continue;
                }
                if (t_element.getName().equals("CategoryComposition") || t_element.getName().equals("Composition")) continue;
                throw new SugarImporterException("Found unknown tag: " + t_element.getName());
            }
            return this.m_objSugar;
        }
        catch (JDOMException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
        catch (NumberFormatException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
    }

    private void parseRoot(Element a_element) throws SugarImporterException, GlycoconjugateException {
        List t_aAttributes = a_element.getAttributes();
        Monosaccharide t_ms = this.parserMSattributes(t_aAttributes, true);
        this.m_objSugar.addNode(t_ms);
        List t_aChilds = a_element.getChildren();
        for (Element element : t_aChilds) {
            if (element.getName().equals("MS")) {
                this.parserMS(element, t_ms);
                continue;
            }
            if (element.getName().equals("MOD")) {
                this.parseSubst(element, t_ms);
                continue;
            }
            throw new SugarImporterException("Found unknown tag in root MS: " + element.getName());
        }
    }

    private void parserMS(Element a_element, Monosaccharide a_parent) throws GlycoconjugateException, SugarImporterException {
        List t_aAttributes = a_element.getAttributes();
        Monosaccharide t_ms = this.parserMSattributes(t_aAttributes, false);
        ArrayList<Linkage> t_oLinkages = this.m_edge.getGlycosidicLinkages();
        GlycoCTLinkageComparator t_linComp = new GlycoCTLinkageComparator();
        Collections.sort(t_oLinkages, t_linComp);
        int t_iCount = 1;
        for (Linkage linkage : t_oLinkages) {
            if (t_iCount != 1) {
                throw new SugarImporterException("MS with more then two parent linkages to other MS found : " + t_ms.getGlycoCTName());
            }
            linkage.setParentLinkageType(LinkageType.H_AT_OH);
            linkage.setChildLinkageType(LinkageType.DEOXY);
            ++t_iCount;
        }
        this.m_objSugar.addNode(t_ms);
        this.m_objSugar.addEdge(a_parent, t_ms, this.m_edge);
        List t_aChilds = a_element.getChildren();
        for (Element element : t_aChilds) {
            if (element.getName().equals("MS")) {
                this.parserMS(element, t_ms);
                continue;
            }
            if (element.getName().equals("MOD")) {
                this.parseSubst(element, t_ms);
                continue;
            }
            throw new SugarImporterException("Found unknown tag in MS: " + element.getName());
        }
    }

    private void parserMS(Element a_element, Substituent a_parent) throws GlycoconjugateException, SugarImporterException {
        List t_aAttributes = a_element.getAttributes();
        Monosaccharide t_ms = this.parserMSattributes(t_aAttributes, false);
        ArrayList<Linkage> t_oLinkages = this.m_edge.getGlycosidicLinkages();
        GlycoCTLinkageComparator t_linComp = new GlycoCTLinkageComparator();
        Collections.sort(t_oLinkages, t_linComp);
        int t_iCount = 1;
        if (a_parent.getParentEdge() != null) {
            t_iCount = a_parent.getParentEdge().getGlycosidicLinkages().size() + 1;
        }
        for (Linkage linkage : t_oLinkages) {
            if (t_iCount == 1) {
                linkage.setChildLinkageType(this.getLinkageTypeForSubst1(a_parent.getSubstituentType()));
                linkage.setParentLinkageType(LinkageType.NONMONOSACCHARID);
            } else if (t_iCount == 2) {
                linkage.setChildLinkageType(this.getLinkageTypeForSubst2(a_parent.getSubstituentType()));
                linkage.setParentLinkageType(LinkageType.NONMONOSACCHARID);
            } else {
                throw new SugarImporterException("MOD with more then two parent linkages found : " + (Object)((Object)a_parent.getSubstituentType()));
            }
            ++t_iCount;
        }
        this.m_objSugar.addNode(t_ms);
        this.m_objSugar.addEdge(a_parent, t_ms, this.m_edge);
        List t_aChilds = a_element.getChildren();
        for (Element element : t_aChilds) {
            if (element.getName().equals("MS")) {
                this.parserMS(element, t_ms);
                continue;
            }
            if (element.getName().equals("MOD")) {
                this.parseSubst(element, t_ms);
                continue;
            }
            throw new SugarImporterException("Found unknown tag in MS: " + element.getName());
        }
    }

    private void parseSubst(Element a_element, Monosaccharide a_parent) throws SugarImporterException, GlycoconjugateException {
        List t_aAttributes = a_element.getAttributes();
        Substituent t_subst = this.parserSubstAttributes(t_aAttributes);
        ArrayList<Linkage> t_oLinkages = this.m_edge.getGlycosidicLinkages();
        GlycoCTLinkageComparator t_linComp = new GlycoCTLinkageComparator();
        Collections.sort(t_oLinkages, t_linComp);
        int t_iCount = 1;
        for (Linkage linkage : t_oLinkages) {
            if (t_iCount == 1) {
                linkage.setParentLinkageType(this.getLinkageTypeForSubst1(t_subst.getSubstituentType()));
                linkage.setChildLinkageType(LinkageType.NONMONOSACCHARID);
            } else if (t_iCount == 2) {
                linkage.setParentLinkageType(this.getLinkageTypeForSubst2(t_subst.getSubstituentType()));
                linkage.setChildLinkageType(LinkageType.NONMONOSACCHARID);
            } else {
                throw new SugarImporterException("MOD with more then two parent linkages found : " + (Object)((Object)t_subst.getSubstituentType()));
            }
            ++t_iCount;
        }
        this.m_objSugar.addNode(t_subst);
        this.m_objSugar.addEdge(a_parent, t_subst, this.m_edge);
        List t_aChilds = a_element.getChildren();
        for (Element element : t_aChilds) {
            if (element.getName().equals("MS")) {
                this.parserMS(element, t_subst);
                continue;
            }
            throw new SugarImporterException("Found unknown tag in MOD: " + element.getName());
        }
    }

    private Substituent parserSubstAttributes(List<Attribute> a_aAttributes) throws GlycoconjugateException, SugarImporterException {
        String t_strNameGlycoCT = null;
        ArrayList<Integer> t_aParentPos = new ArrayList<Integer>();
        for (Attribute attribute : a_aAttributes) {
            if (attribute.getName().equals("ct_name")) {
                t_strNameGlycoCT = attribute.getValue();
                continue;
            }
            if (attribute.getName().equals("name") || attribute.getName().equals("node")) continue;
            if (attribute.getName().startsWith("pos")) {
                String t_strValue = attribute.getName().replaceAll("pos", "").trim();
                if (t_strValue.equals("X")) {
                    t_aParentPos.add(-1);
                    continue;
                }
                t_aParentPos.add(Integer.parseInt(t_strValue));
                continue;
            }
            throw new SugarImporterException("Found unknown attribute in MOD: " + attribute.getName());
        }
        if (t_strNameGlycoCT == null) {
            throw new SugarImporterException("Missing ct_name in MS.");
        }
        if (t_aParentPos.size() == 0) {
            throw new SugarImporterException("Missing child linkage position in MS: " + t_strNameGlycoCT);
        }
        this.m_edge = new GlycoEdge();
        Linkage t_linkage = new Linkage();
        t_linkage.addChildLinkage(1);
        t_linkage.setParentLinkages(t_aParentPos);
        t_linkage.setChildLinkageType(LinkageType.DEOXY);
        t_linkage.setParentLinkageType(LinkageType.H_AT_OH);
        this.m_edge.addGlycosidicLinkage(t_linkage);
        return new Substituent(SubstituentType.forName(t_strNameGlycoCT));
    }

    private Monosaccharide parserMSattributes(List<Attribute> a_aAttributes, boolean a_bRoot) throws SugarImporterException, GlycoconjugateException {
        Superclass t_super = null;
        String t_strNameGlycoCT = null;
        ArrayList<Integer> t_aParentPos = new ArrayList<Integer>();
        ArrayList<Integer> t_aChildPos = new ArrayList<Integer>();
        Anomer t_anomer = null;
        for (Attribute attribute : a_aAttributes) {
            String t_strValue;
            if (attribute.getName().equals("SUBCLASS")) {
                t_super = Superclass.forName(attribute.getValue());
                continue;
            }
            if (attribute.getName().equals("ct_name")) {
                t_strNameGlycoCT = attribute.getValue();
                continue;
            }
            if (attribute.getName().equals("name") || attribute.getName().equals("node")) continue;
            if (attribute.getName().startsWith("plink")) {
                t_strValue = attribute.getName().replaceAll("plink", "").trim();
                if (t_strValue.equals("X")) {
                    t_aParentPos.add(-1);
                    continue;
                }
                t_aParentPos.add(Integer.parseInt(t_strValue));
                continue;
            }
            if (attribute.getName().startsWith("clink")) {
                t_strValue = attribute.getName().replaceAll("clink", "").trim();
                if (t_strValue.equals("X")) {
                    t_aChildPos.add(-1);
                    continue;
                }
                t_aChildPos.add(Integer.parseInt(t_strValue));
                continue;
            }
            if (attribute.getName().equals("anom")) {
                t_anomer = Anomer.forSymbol(attribute.getValue().toLowerCase());
                continue;
            }
            throw new SugarImporterException("Found unknown attribute in MS: " + attribute.getName());
        }
        if (t_strNameGlycoCT == null) {
            throw new SugarImporterException("Missing ct_name in MS.");
        }
        Monosaccharide t_ms = Monosaccharide.forGlycoCTName(t_strNameGlycoCT);
        if (t_super != null && t_ms.getSuperclass() != t_super) {
            throw new SugarImporterException("Superclass does not match: " + t_strNameGlycoCT);
        }
        if (!a_bRoot) {
            if (t_anomer == null) {
                throw new SugarImporterException("Missing anom in MS: " + t_strNameGlycoCT);
            }
            if (t_ms.getAnomer() == Anomer.OpenChain) {
                if (t_anomer != Anomer.Unknown) {
                    throw new SugarImporterException("Wrong anom in MS: " + t_strNameGlycoCT);
                }
            } else if (t_anomer != t_ms.getAnomer()) {
                throw new SugarImporterException("Anomer does not match: " + t_strNameGlycoCT);
            }
            if (t_aChildPos.size() == 0) {
                throw new SugarImporterException("Missing child linkage position in MS: " + t_strNameGlycoCT);
            }
            if (t_aParentPos.size() == 0) {
                throw new SugarImporterException("Missing parent linkage position in MS: " + t_strNameGlycoCT);
            }
            this.m_edge = new GlycoEdge();
            Linkage t_linkage = new Linkage();
            t_linkage.setChildLinkages(t_aChildPos);
            t_linkage.setParentLinkages(t_aParentPos);
            this.m_edge.addGlycosidicLinkage(t_linkage);
        }
        return t_ms;
    }

    private LinkageType getLinkageTypeForSubst1(SubstituentType a_substType) throws SugarImporterException {
        LinkageType t_result = this.m_hSubstPositionOne.get((Object)a_substType);
        if (t_result == null) {
            throw new SugarImporterException("Unable to set linkage type one for: " + (Object)((Object)a_substType));
        }
        return t_result;
    }

    private LinkageType getLinkageTypeForSubst2(SubstituentType a_substType) throws SugarImporterException {
        LinkageType t_result = this.m_hSubstPositionTwo.get((Object)a_substType);
        if (t_result == null) {
            throw new SugarImporterException("Unable to set linkage type two for: " + (Object)((Object)a_substType));
        }
        return t_result;
    }
}

