/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.util.comparater.MAPMASSComparator;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.array.WURCSImporter;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;
import org.glycoinfo.WURCSFramework.util.property.AtomicProperties;
import org.glycoinfo.WURCSFramework.util.subsumption.MSStateDeterminationUtility;
import org.glycoinfo.WURCSFramework.util.subsumption.WURCSSubsumptionConverter;
import org.glycoinfo.WURCSFramework.wurcs.array.MS;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptor;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class SkeletonCodeToStereo {
    public LinkedList<String> start(Backbone _backbone) throws WURCSFormatException, ConverterExchangeException {
        HashMap<Integer, ArrayList<Modification>> modMap = new HashMap<Integer, ArrayList<Modification>>();
        StringBuilder sc = new StringBuilder(_backbone.getSkeletonCode());
        if (this.containUndefinedCarbonDescriptor(_backbone)) {
            throw new ConverterExchangeException("This SkeletonCode partially contains the wild card (x or X).");
        }
        if (!_backbone.hasUnknownLength()) {
            this.extractSubstituentOnBranchPosition(_backbone, modMap);
        }
        if (!this.haveSubstituent(modMap)) {
            throw new ConverterExchangeException("This SkeletonCode contains H_LOSE in backbone without substituent.");
        }
        for (Integer pos : modMap.keySet()) {
            char newCD = this.modifyCarbonDescriptor(sc.charAt(pos - 1), modMap.get(pos));
            sc.replace(pos - 1, pos, String.valueOf(newCD));
        }
        MS ms = new WURCSImporter().extractMS(sc.toString());
        MSStateDeterminationUtility msUtility = new MSStateDeterminationUtility();
        WURCSSubsumptionConverter wsc = new WURCSSubsumptionConverter();
        LinkedList<String> stereos = msUtility.extractStereo(ms);
        if (stereos.isEmpty()) {
            stereos = this.checkStereos(ms);
        }
        stereos = this.modifyFuzzyConfiguration(stereos);
        return stereos;
    }

    private LinkedList<String> checkStereos(MS _ms) throws ConverterExchangeException {
        LinkedList<String> a_aStereo = new LinkedList<String>();
        String a_sSkeletonCode = _ms.getSkeletonCode();
        if (a_sSkeletonCode.equals("<Q>")) {
            a_aStereo.addLast("Sugar");
        }
        if (this.haveUncertainGroups(_ms)) {
            return a_aStereo;
        }
        if (a_aStereo.isEmpty()) {
            throw new ConverterExchangeException(_ms.getSkeletonCode() + " could not handled");
        }
        return a_aStereo;
    }

    private boolean haveUncertainGroups(MS _ms) {
        boolean ret = false;
        for (int i = 0; i < _ms.getSkeletonCode().length(); ++i) {
            if (i == 0 || i == _ms.getSkeletonCode().length() - 1) continue;
            CarbonDescriptor cd = CarbonDescriptor.forCharacter((char)_ms.getSkeletonCode().charAt(i), (Boolean)false);
            if (cd.equals((Object)CarbonDescriptor.SS3_STEREO_X_L)) {
                ret = true;
                continue;
            }
            ret = false;
            break;
        }
        return ret;
    }

    private LinkedList<String> modifyFuzzyConfiguration(LinkedList<String> _stereos) {
        LinkedList<String> ret = new LinkedList<String>();
        for (String stereo : _stereos) {
            if (!stereo.startsWith("d/l-")) {
                ret.add(stereo);
                continue;
            }
            ret.add(stereo.replaceFirst("d/l-", ""));
        }
        return ret;
    }

    private String checkDLconfiguration(String _stereo) {
        if (_stereo.startsWith("l") || _stereo.startsWith("d")) {
            _stereo = _stereo.replaceFirst("[ld]", "");
        }
        return _stereo;
    }

    private boolean containUndefinedCarbonDescriptor(Backbone _backbone) {
        boolean isNormal = false;
        boolean isWild = false;
        for (BackboneCarbon bc : _backbone.getBackboneCarbons()) {
            char cd = bc.getDescriptor().getChar();
            if (cd == '1' || cd == '2' || cd == '3' || cd == '4' || cd == '5' || cd == '6' || cd == '7' || cd == '8') {
                isNormal = true;
            }
            if (cd == 'x' || cd == 'X') {
                isWild = true;
            }
            if (!isNormal || !isWild) continue;
            break;
        }
        return isNormal && isWild;
    }

    private HashMap<Integer, ArrayList<Modification>> extractBranchingPoints(Backbone _backbone, HashMap<Integer, ArrayList<Modification>> _modMap) {
        String skeletonCode = _backbone.getSkeletonCode();
        for (int i = 0; i < skeletonCode.length(); ++i) {
            char carbon = skeletonCode.charAt(i);
            if (carbon != '5' && carbon != '6' && carbon != '7' && carbon != '8' && carbon != 'X') continue;
            _modMap.put(i + 1, new ArrayList());
        }
        return _modMap;
    }

    private HashMap<Integer, ArrayList<Modification>> extractSubstituentOnBranchPosition(Backbone _backbone, HashMap<Integer, ArrayList<Modification>> _modMap) {
        _modMap = this.extractBranchingPoints(_backbone, _modMap);
        String skeletonCode = _backbone.getSkeletonCode();
        for (WURCSEdge we : _backbone.getChildEdges()) {
            Modification mod = we.getModification();
            if (mod.isGlycosidic() || mod.isRing() || mod instanceof ModificationRepeat || mod.getParentEdges().size() != 1) continue;
            for (LinkagePosition lp : we.getLinkages()) {
                char cd;
                if (lp.getBackbonePosition() == -1 || !this.isChiralCarbonDescriptor(cd = skeletonCode.charAt(lp.getBackbonePosition() - 1)) || !_modMap.containsKey(lp.getBackbonePosition())) continue;
                _modMap.get(lp.getBackbonePosition()).add(mod);
            }
        }
        return _modMap;
    }

    private boolean haveSubstituent(HashMap<Integer, ArrayList<Modification>> _modMap) {
        boolean ret = true;
        for (Integer pos : _modMap.keySet()) {
            if (!_modMap.get(pos).isEmpty()) continue;
            ret = false;
        }
        return ret;
    }

    private char modifyCarbonDescriptor(char _carbonDescriptor, ArrayList<Modification> _mods) {
        boolean isSwap = this.compareSubstituentGroups(_mods) < 0;
        char ret = this.replaceCarbonDescriptorByStereo(_carbonDescriptor, isSwap);
        return ret;
    }

    private char replaceCarbonDescriptorByStereo(char _carbonDescriptor, boolean _isSwap) {
        int replacedCD;
        int n = _carbonDescriptor == '5' ? 49 : (_carbonDescriptor == '6' ? 50 : (_carbonDescriptor == '7' ? 51 : (_carbonDescriptor == '8' ? 52 : (_carbonDescriptor == 'X' ? 120 : (_carbonDescriptor == 'C' ? 99 : (_carbonDescriptor == 'h' ? 109 : (replacedCD = _carbonDescriptor == 'c' ? 104 : (int)_carbonDescriptor)))))));
        if (_isSwap) {
            replacedCD = replacedCD == 49 ? 50 : (replacedCD == 50 ? 49 : (replacedCD == 51 ? 52 : (replacedCD == 52 ? 51 : replacedCD)));
        }
        return (char)replacedCD;
    }

    private int compareSubstituentGroups(ArrayList<Modification> _mods) {
        Collections.sort(_mods, new MAPMASSComparator());
        char atom = _mods.get(_mods.size() - 1).getMAPCode().charAt(1);
        int atomMass = AtomicProperties.forSymbol((String)String.valueOf(atom)).getMassNumber();
        if (atomMass < 16) {
            return 1;
        }
        return -1;
    }

    private boolean isChiralCarbonDescriptor(char _carbonDescriptor) {
        return _carbonDescriptor == '5' || _carbonDescriptor == '6' || _carbonDescriptor == '7' || _carbonDescriptor == '8' || _carbonDescriptor == 'X';
    }
}

