/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.analyzer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.BaseStereoIndex;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameDictionary;

public class ThreeLetterCodeAnalyzer {
    private ArrayList<String> substituents = new ArrayList();
    private ArrayList<String> modifications = new ArrayList();
    private LinkedList<String> stereos = new LinkedList();
    private SuperClass superclass;
    private String coreNotation;

    public ArrayList<String> getSubstituents() {
        return this.substituents;
    }

    public ArrayList<String> getModificaitons() {
        return this.modifications;
    }

    public LinkedList<String> getStereos() {
        return this.stereos;
    }

    public SuperClass getSuperClass() {
        return this.superclass;
    }

    public String getCoreNotation() {
        if (this.coreNotation == null) {
            return this.coreNotation;
        }
        String prefix = String.valueOf(this.coreNotation.charAt(0));
        this.coreNotation = this.coreNotation.replaceFirst(prefix, prefix.toUpperCase());
        return this.coreNotation;
    }

    public void analyzeTrivialName(String _trivialName, LinkedList<String> _templates) throws GlyCoImporterException {
        Matcher matTriv = Pattern.compile("(\\dd)?([a-z]{2,3})+([A-Z][a-z]{1,2})+").matcher(_trivialName);
        String stereo = "";
        if (matTriv.find()) {
            TrivialNameDictionary trivDict;
            String sugarName = "";
            if (matTriv.group(1) != null) {
                sugarName = sugarName + matTriv + matTriv.group(1);
            }
            if (matTriv.group(2) != null) {
                sugarName = sugarName + matTriv.group(2);
                this.coreNotation = matTriv.group(2);
            }
            if ((trivDict = TrivialNameDictionary.forThreeLetterCode(sugarName)) != null) {
                stereo = trivDict.getStereos();
                this.extractModifications(trivDict.getModifications());
                this.extractSubstituents(trivDict.getSubstituents());
            } else {
                BaseStereoIndex bsi = BaseStereoIndex.forCode(sugarName);
                if (bsi != null) {
                    stereo = matTriv.group(2);
                }
            }
            this.superclass = SuperClass.forSuperClass(matTriv.group(3));
            if (!stereo.contains("_") && _templates.size() == 2) {
                this.stereos.addFirst(_templates.getFirst().toLowerCase());
                this.stereos.addLast(stereo.toLowerCase());
            } else {
                this.extractStereos(stereo);
            }
        } else {
            TrivialNameDictionary trivDict = TrivialNameDictionary.forThreeLetterCode(_trivialName);
            if (trivDict != null) {
                stereo = trivDict.getStereos();
                this.superclass = SuperClass.forSize(trivDict.getSize());
                this.extractModifications(trivDict.getModifications());
                this.extractSubstituents(trivDict.getSubstituents());
            } else {
                BaseStereoIndex bsi;
                stereo = _trivialName;
                this.superclass = !_trivialName.equals("Sugar") ? ((bsi = BaseStereoIndex.forCode(_trivialName)) == null ? SuperClass.forSuperClass(_trivialName) : SuperClass.forSize(bsi.getSize())) : SuperClass.SUG;
            }
            if (!this.isSuperClass(_trivialName)) {
                this.extractStereos(stereo);
            }
        }
        if (this.superclass == null) {
            throw new GlyCoImporterException("Monosaccharide size could not defined.");
        }
    }

    private boolean isSuperClass(String _threeLetterCode) {
        SuperClass superclass = SuperClass.forSuperClassWithIgnore(_threeLetterCode);
        return superclass != null;
    }

    private void extractStereos(String _temp) {
        for (String unit : _temp.split("_")) {
            this.stereos.add(unit.toLowerCase());
        }
    }

    private void extractSubstituents(String _temp) {
        if (_temp.equals("")) {
            return;
        }
        for (String unit : _temp.split("_")) {
            String[] parts = unit.split("\\*");
            this.substituents.add(parts[0] + parts[1]);
        }
    }

    private void extractModifications(String _temp) {
        if (_temp.equals("")) {
            return;
        }
        for (String unit : _temp.split("_")) {
            String[] parts = unit.split("\\*");
            this.modifications.add(parts[0] + parts[1]);
        }
    }
}

