/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.KCF;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KCFUtility {
    private ArrayList<String> nodes = new ArrayList();
    private ArrayList<String> edges = new ArrayList();
    private ArrayList<String> notationList = new ArrayList();

    public ArrayList<String> getNotationList() {
        return this.notationList;
    }

    public ArrayList<String> getNodes() {
        return this.nodes;
    }

    public ArrayList<String> getEdges() {
        return this.edges;
    }

    public void start(String _kcf) {
        String status = "";
        String countKey = "";
        this.notationList = new ArrayList<String>(Arrays.asList(_kcf.split("\n")));
        for (String unit : this.notationList) {
            if ((unit = unit.trim()).equals("///")) break;
            Matcher matNode = Pattern.compile("^([A-Z]+)+\\s+(\\d+)+$").matcher(unit);
            if (matNode.find()) {
                status = matNode.group(1);
                countKey = matNode.group(2);
                continue;
            }
            if (status.equals("NODE")) {
                this.nodes.add(unit);
            }
            if (status.equals("EDGE")) {
                this.edges.add(unit);
            }
            if (!unit.startsWith(countKey)) continue;
            countKey = "";
            status = "";
        }
    }

    public String getEdgeByID(String _id, boolean _isParent) {
        String ret = "";
        for (String s : this.edges) {
            String notation = _isParent ? this.splitNotation(s).get(2) : this.splitNotation(s).get(1);
            if (!this.extractID(notation).equals(_id)) continue;
            ret = s;
        }
        return ret;
    }

    public String getNodeByID(String _id) {
        String ret = "";
        for (String s : this.nodes) {
            if (!this.splitNotation(s).get(0).equals(_id)) continue;
            ret = s;
        }
        return ret;
    }

    public String getLinkagePositionByNodeID(String _id, boolean _isParent) {
        String ret = "";
        for (String s : this.edges) {
            String status = _isParent ? this.splitNotation(s).get(2) : this.splitNotation(s).get(1);
            if (!_id.equals(this.extractID(status))) continue;
            ret = status;
        }
        return this.extractLinkagePosition(ret);
    }

    public ArrayList<String> splitNotation(String _node) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : _node.split("\\s")) {
            if (s.equals("")) continue;
            ret.add(s);
        }
        return ret;
    }

    public String extractID(String _linkage) {
        String[] units = _linkage.split(":");
        return units[0];
    }

    public ArrayList<String> extractAcceptorEdgeByID(String _currentID) {
        ArrayList<String> ret = new ArrayList<String>();
        boolean isEdge = false;
        for (String unit : this.edges) {
            String acceptorID = this.extractID(this.splitNotation(unit).get(2));
            if (!acceptorID.equals(_currentID)) continue;
            ret.add(unit);
        }
        return ret;
    }

    public String extractDonorEdgeByID(String _currentID) {
        String ret = "";
        boolean isEdge = false;
        for (String unit : this.edges) {
            String donorID = this.extractID(this.splitNotation(unit).get(1));
            if (!donorID.equals(_currentID)) continue;
            ret = unit;
            break;
        }
        return ret;
    }

    public String extractEdgeByID(String _currentID, boolean _isParent) {
        if (_isParent) {
            ArrayList<String> acceptors = this.extractAcceptorEdgeByID(_currentID);
            if (!acceptors.isEmpty()) {
                return acceptors.get(0);
            }
        } else {
            return this.extractDonorEdgeByID(_currentID);
        }
        return "";
    }

    public ArrayList<String> extractEdgesByID(String _currentID, boolean _isParent) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String unit : this.edges) {
            String childID = _isParent ? this.extractID(this.splitNotation(unit).get(2)) : this.extractID(this.splitNotation(unit).get(1));
            if (!childID.equals(_currentID)) continue;
            ret.add(unit);
        }
        return ret;
    }

    public String extractLinkagePosition(String _linkage) {
        if (!_linkage.contains(":")) {
            return null;
        }
        String[] units = _linkage.split(":");
        String ret = units[1];
        if (ret.matches("^[abAB].+")) {
            ret = ret.replaceAll("[abAB]", "");
        }
        return ret;
    }

    public String extractAnomerixState(String _linkage) {
        if (!_linkage.contains(":")) {
            return null;
        }
        String[] units = _linkage.split(":");
        String ret = units[1];
        return ret;
    }
}

