/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC.extended;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.util.MonosaccharideUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.MonosaccharideIndex;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.IUPACSubstituentNotationAnalyzer;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.ThreeLetterCodeAnalyzer;

public class IUPACNotationParser {
    /*
     * WARNING - void declaration
     */
    public Node parseMonosaccharide(String _iupac) throws GlycanException, GlyCoImporterException {
        void var14_30;
        Matcher matSub;
        String temp = this.trim(_iupac);
        String linkagePos = "";
        String anomericState = "";
        Monosaccharide mono = new Monosaccharide();
        ArrayList<String> subNotation = new ArrayList<String>();
        ArrayList<String> modifications = new ArrayList<String>();
        LinkedList<String> configurations = new LinkedList<String>();
        LinkedList<String> trivialName = new LinkedList<String>();
        IUPACSubstituentNotationAnalyzer subAna = new IUPACSubstituentNotationAnalyzer();
        MonosaccharideUtility monoUtil = new MonosaccharideUtility();
        if (temp.contains("-(")) {
            linkagePos = temp.substring(temp.indexOf("-(") + 1);
            temp = temp.replace("-" + linkagePos, "");
        }
        if (temp.contains(")-")) {
            temp = temp.substring(temp.indexOf(")-") + 2);
        }
        if ((matSub = Pattern.compile("^([?\\d])+([(\\w)]+)+=(\\d\\$)").matcher(_iupac)).find()) {
            subAna.start(matSub.group(1) + matSub.group(2));
            Substituent sub = subAna.getSubstituents().get(0);
            Edge edge = new Edge();
            edge.addGlycosidicLinkage(sub.getFirstPosition());
            edge.setSubstituent(sub);
            sub.addParentEdge(edge);
            return sub;
        }
        Matcher matMod = Pattern.compile("([\\d,:]*-Anhydro-)?([\\d,?]*-\\w*deoxy-)?([LD?]-\\w{3}-)?((keto|aldehyde|\\?|\u03b1|\u03b2)-)?([\\d,:]*-Anhydro-)?([\\d,?]*-\\w*deoxy-)?([DL?])?").matcher(temp);
        if (matMod.find()) {
            if (matMod.group(5) != null && matMod.group(8) != null) {
                if (!matMod.group(5).equals("aldehyde")) {
                    anomericState = matMod.group(5);
                } else {
                    modifications.add(matMod.group(5));
                }
                String string = matMod.group(4).replace("?", "\\?");
                temp = temp.replaceFirst(string, "");
            }
            if (matMod.group(1) != null || matMod.group(6) != null) {
                String string = matMod.group(1) != null ? matMod.group(1) : matMod.group(6);
                subNotation.addAll(monoUtil.resolveNotation(this.trimTail(string)));
                temp = temp.replace(string, "");
            }
            if (matMod.group(2) != null || matMod.group(7) != null) {
                void var14_23;
                String string = "";
                if (matMod.group(2) != null) {
                    String string2 = matMod.group(2);
                }
                if (matMod.group(7) != null) {
                    String string3 = matMod.group(7);
                }
                modifications.addAll(monoUtil.resolveNotation(this.trimTail((String)var14_23)));
                temp = temp.replace((CharSequence)var14_23, "");
            }
        }
        for (String unit : temp.split("-")) {
            if (unit.equals("D") || unit.equals("L") || unit.equals("?")) {
                configurations.addLast(unit);
                if (unit.equals("?")) {
                    unit = unit.replace(unit, "\\" + unit);
                }
                temp = temp.replaceFirst(unit + "-", "");
            }
            if (!unit.equals("ol") && !unit.equals("onic") && !unit.equals("aric") && !unit.equals("uronic")) continue;
            modifications.add(unit);
            temp = temp.replace("-" + unit, "");
        }
        if (temp.matches("[a-z]{3}-.+")) {
            trivialName.add(temp.substring(0, temp.indexOf("-")));
            trivialName.add(temp.substring(temp.indexOf("-") + 1));
        } else {
            trivialName.add(temp);
        }
        if (modifications.contains("ol")) {
            anomericState = "";
        }
        String string = (String)trivialName.getLast();
        String threeLetterCode = "";
        Matcher matCore = Pattern.compile("(Sugar|Ko|[a-z]{2,3}[A-Z][a-z]{2}|[\\dedi]*[A-Z][a-z]{2}C?)+((\\dulo)+)?").matcher(string);
        if (matCore.find()) {
            if (matCore.group(1) != null) {
                ThreeLetterCodeAnalyzer threeCode = new ThreeLetterCodeAnalyzer();
                threeCode.analyzeTrivialName(matCore.group(1), trivialName);
                threeLetterCode = threeCode.getCoreNotation() != null ? threeCode.getCoreNotation() : matCore.group(1);
                mono.setStereos(threeCode.getStereos());
                mono.setSuperClass(threeCode.getSuperClass());
                subNotation.addAll(threeCode.getSubstituents());
                modifications.addAll(threeCode.getModificaitons());
                String string4 = string.replace(matCore.group(1), "");
            }
            if (matCore.group(2) != null) {
                void var14_28;
                String ulosonic = matCore.group(2);
                while (ulosonic.length() != 0) {
                    String unit = ulosonic.substring(0, 4);
                    modifications.add(unit);
                    ulosonic = ulosonic.replaceFirst(unit, "");
                }
                String string5 = var14_28.replace(matCore.group(2), "");
            }
        }
        mono.setAnomer(this.convertAnomericState(mono, anomericState));
        mono.setAnomericPosition(this.extractAnomericPosition(mono, linkagePos, threeLetterCode, modifications));
        Matcher matTail = Pattern.compile("([pf?])?([\\d,\\w/:(%)\\-?]+)?").matcher((CharSequence)var14_30);
        if (matTail.find() && (matTail.group(1) != null || matTail.group(2) != null)) {
            boolean isRingSize = false;
            if (matTail.group(2) == null) {
                isRingSize = true;
            }
            if (matTail.group(2) != null && var14_30.length() > 1 && String.valueOf(var14_30.charAt(1)).matches("[\\dNA\\\\?]")) {
                isRingSize = true;
            }
            if (matTail.group(1) == null) {
                isRingSize = false;
            }
            if (isRingSize) {
                mono = monoUtil.makeRingSize(mono, matTail.group(1), threeLetterCode, modifications);
            }
            if (matTail.group(2) != null) {
                String subNotations = "";
                if (!isRingSize && matTail.group(1) != null) {
                    subNotations = subNotations + matTail.group(1);
                }
                if ((subNotations = subNotations + matTail.group(2)).startsWith("A")) {
                    String acid = String.valueOf(mono.getSuperClass().getSize()) + subNotations.charAt(0);
                    modifications.add(acid);
                    subNotations = subNotations.replaceFirst(String.valueOf(subNotations.charAt(0)), "");
                }
                subNotation.addAll(subAna.resolveSubstituents(subNotations, true));
                modifications.addAll(subAna.resolveSubstituents(subNotations, false));
            }
        }
        mono = monoUtil.appendModifications(mono, modifications);
        mono = monoUtil.appendSubstituents(mono, subNotation);
        mono = monoUtil.modifyStereos(mono, configurations);
        mono = monoUtil.checkTruelyConfiguration(threeLetterCode, configurations, mono);
        return mono;
    }

    private int extractAnomericPosition(Monosaccharide _mono, String _linkage, String _code, ArrayList<String> _mods) {
        String ulosonate;
        if (_code.equalsIgnoreCase("sugar")) {
            if (_mono.getAnomer().equals((Object)AnomericStateDescriptor.ALPHA) || _mono.getAnomer().equals((Object)AnomericStateDescriptor.BETA)) {
                return -1;
            }
            if (_mono.getAnomer().equals((Object)AnomericStateDescriptor.UNKNOWN_STATE)) {
                return 0;
            }
        }
        if (_linkage.equals("")) {
            if (_mono.getAnomer().equals((Object)AnomericStateDescriptor.OPEN)) {
                return 0;
            }
            return -1;
        }
        int childPos = -1;
        AnomericStateDescriptor anomer = _mono.getAnomer();
        boolean isAnomeric = false;
        for (String unit : _linkage.split(":")) {
            if (unit.matches("\\(.+")) {
                unit = this.trimHead(unit);
            }
            if (unit.contains("\u2192") || unit.contains("\u2194")) {
                childPos = this.charToInt(unit.charAt(0));
                isAnomeric = true;
            }
            if (isAnomeric) break;
        }
        if (anomer.equals((Object)AnomericStateDescriptor.OPEN)) {
            return 0;
        }
        if (_mono.getAnomericPosition() != 0 && childPos == -1) {
            childPos = _mono.getAnomericPosition();
        }
        if (!(ulosonate = this.extractAnomericUlosonate(_mods)).equals("")) {
            return Integer.parseInt(ulosonate);
        }
        MonosaccharideIndex mi = MonosaccharideIndex.forTrivialNameWithIgnore(_code);
        if (mi == null) {
            return childPos;
        }
        if (mi.getAnomerciPosition() != childPos) {
            return mi.getAnomerciPosition();
        }
        return childPos;
    }

    private AnomericStateDescriptor convertAnomericState(Monosaccharide _mono, String _anomeric) {
        switch (_anomeric) {
            case "?": {
                return AnomericStateDescriptor.UNKNOWN_STATE;
            }
            case "": {
                return AnomericStateDescriptor.OPEN;
            }
            case "\u03b1": {
                return AnomericStateDescriptor.ALPHA;
            }
            case "\u03b2": {
                return AnomericStateDescriptor.BETA;
            }
        }
        return null;
    }

    private String extractAnomericUlosonate(ArrayList<String> _mods) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String mod : _mods) {
            if (!mod.contains("ulo")) continue;
            ret.add(mod);
        }
        Collections.sort(ret);
        if (ret.isEmpty()) {
            return "";
        }
        return String.valueOf(((String)ret.get(0)).charAt(0));
    }

    private int charToInt(char _char) {
        if (_char == '?') {
            return -1;
        }
        return Integer.parseInt(String.valueOf(_char));
    }

    private String trim(String _notation) {
        String ret = _notation;
        if (_notation.matches(".+(=\\d+\\$,?)+")) {
            ret = _notation.replaceAll("(=\\d+\\$,?)", "");
        }
        if (_notation.matches(".*([?\\d+]\\$\\|?)+.+")) {
            ret = ret.replaceFirst("([?\\d+]\\$\\|?)+", "");
        }
        ret = ret.contains(")-") ? ret.substring(ret.indexOf(")-") + 1) : ret;
        ret = ret.startsWith("[") ? ret.replaceAll("\\[", "") : ret;
        ret = ret.startsWith("]-") ? ret.replaceAll("]-", "") : ret;
        ret = ret.startsWith("-") ? ret.replaceFirst("-", "") : ret;
        ret = ret.endsWith("]") ? ret.replaceFirst("]", "") : ret;
        return ret;
    }

    private String trimTail(String _temp) {
        return _temp.substring(0, _temp.length() - 1);
    }

    private String trimHead(String _temp) {
        return _temp.substring(1);
    }
}

