/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC.extended;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACStacker;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.extended.IUPACLinkageParser;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.extended.IUPACNotationParser;
import org.glycoinfo.GlycanFormatconverter.util.GlyContainerOptimizer;

public class IUPACExtendedImporter {
    /*
     * WARNING - void declaration
     */
    public GlyContainer start(String _iupac) throws GlycanException, GlyCoImporterException {
        GlyContainer glyCo = new GlyContainer();
        LinkedHashMap<Node, String> nodeIndex = new LinkedHashMap<Node, String>();
        ArrayList<Object> notations = new ArrayList();
        if (_iupac.contains("$,")) {
            for (String string : _iupac.split("\\$,")) {
                void var8_13;
                if (string.matches(".+=[\\d?]+")) {
                    String string2 = (String)string + "$,";
                }
                notations.add(var8_13);
            }
            Collections.reverse(notations);
        }
        if (_iupac.matches(".*}\\d+")) {
            notations = this.parseCompositionUnits(_iupac);
        }
        if (notations.isEmpty()) {
            notations.add(_iupac);
        }
        for (String string : notations) {
            void var6_10;
            IUPACStacker stacker = new IUPACStacker();
            Matcher matcher = Pattern.compile("^\\{.+}(\\d+)+$").matcher(string);
            if (matcher.find()) {
                String count = matcher.group(1);
                String string4 = string.replaceFirst("\\{", "");
                string4 = string4.substring(0, string4.indexOf("}" + (String)count));
                stacker.setNumOfNode(Integer.parseInt(count));
                stacker.setComposition();
            }
            stacker.setNotations(this.parseNotation((String)var6_10));
            if (var6_10.endsWith("$,")) {
                stacker.setFragment();
            }
            for (String unit : stacker.getNotations()) {
                if (stacker.isComposition()) {
                    for (int i = stacker.getNumOfNode(); i != 0; --i) {
                        Node node = this.makeNode(unit);
                        nodeIndex.put(node, unit);
                        stacker.addNode(node);
                    }
                    continue;
                }
                Node node = this.makeNode(unit);
                nodeIndex.put(node, unit);
                stacker.addNode(node);
            }
            this.parseChildren(stacker, nodeIndex);
            IUPACLinkageParser iupacLP = new IUPACLinkageParser(glyCo, nodeIndex, stacker);
            iupacLP.start();
            glyCo = iupacLP.getGlyCo();
        }
        GlyContainerOptimizer gcOpt = new GlyContainerOptimizer();
        gcOpt.start(glyCo);
        return glyCo;
    }

    private Node makeNode(String _notation) throws GlycanException, GlyCoImporterException {
        IUPACNotationParser iupacNP = new IUPACNotationParser();
        return iupacNP.parseMonosaccharide(_notation);
    }

    private ArrayList<String> parseNotation(String _iupac) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder mono = new StringBuilder();
        boolean isLinkage = false;
        boolean isRepeat = false;
        boolean isbisect = false;
        boolean isMultipleParent = false;
        for (int i = 0; i < _iupac.length(); ++i) {
            mono.append(_iupac.charAt(i));
            if (_iupac.charAt(i) == '(') {
                isLinkage = true;
            }
            if (isbisect && _iupac.charAt(i) == ']') {
                ret.add(mono.toString());
                mono = new StringBuilder();
                isbisect = false;
            }
            if (isMultipleParent && _iupac.charAt(i) == ')') {
                if (_iupac.charAt(i + 1) == ']' && _iupac.charAt(i + 2) != '-') {
                    isbisect = true;
                    isMultipleParent = false;
                    continue;
                }
                ret.add(mono.toString());
                mono = new StringBuilder();
                isMultipleParent = false;
            }
            if (isLinkage && _iupac.charAt(i) == ')') {
                if (_iupac.charAt(i + 1) == '=') {
                    isLinkage = false;
                    continue;
                }
                if (_iupac.charAt(i + 1) == ']' && _iupac.charAt(i + 2) != '-') {
                    isbisect = true;
                    isLinkage = false;
                    continue;
                }
                if (String.valueOf(_iupac.charAt(i + 1)).matches("[a-zA-Z,]")) continue;
                ret.add(mono.toString());
                mono = new StringBuilder();
                isLinkage = false;
            }
            if (isLinkage && _iupac.charAt(i) == ']') {
                isLinkage = false;
                isRepeat = true;
                continue;
            }
            if (_iupac.length() - 1 == i) {
                ret.add(mono.toString());
                break;
            }
            if (!isRepeat) continue;
            if (String.valueOf(_iupac.charAt(i)).matches("[\\dn]")) {
                if (String.valueOf(_iupac.charAt(i + 1)).matches("\\d") || _iupac.charAt(i + 1) == '-' && String.valueOf(_iupac.charAt(i + 2)).matches("[\\dn(]") || _iupac.charAt(i - 1) == '(' && _iupac.charAt(i + 1) == '\u2192') continue;
                isRepeat = false;
            }
            if (_iupac.charAt(i + 1) == ':') {
                isMultipleParent = true;
                continue;
            }
            if (isRepeat) continue;
            ret.add(mono.toString());
            mono = new StringBuilder();
        }
        return ret;
    }

    private void parseChildren(IUPACStacker _stacker, LinkedHashMap<Node, String> _index) {
        ArrayList<Node> nodes = new ArrayList<Node>(_stacker.getNodes());
        Collections.reverse(nodes);
        for (Node node : nodes) {
            Node child;
            int childIndex;
            String current = _index.get(node);
            if (this.haveChild(current)) {
                childIndex = nodes.indexOf(node) + 1;
                child = nodes.get(childIndex);
                _stacker.addFamily(child, node);
            }
            if (!this.isStartOfBranch(current)) continue;
            childIndex = nodes.indexOf(node) + 1;
            child = nodes.get(childIndex);
            _stacker.addFamily(child, node);
            for (Node cNode : this.pickChildren(nodes, node, _index)) {
                _stacker.addFamily(cNode, node);
            }
        }
    }

    private ArrayList<String> parseCompositionUnits(String _iupac) {
        ArrayList<String> ret = new ArrayList<String>();
        String notation = "";
        boolean isEndBracket = false;
        for (int i = 0; i < _iupac.length(); ++i) {
            if (isEndBracket && _iupac.charAt(i) == ',') {
                ret.add(notation);
                notation = "";
                isEndBracket = false;
                continue;
            }
            notation = notation + _iupac.charAt(i);
            if (i + 1 == _iupac.length()) {
                ret.add(notation);
            }
            if (i <= 0 || _iupac.charAt(i) != '}') continue;
            isEndBracket = true;
        }
        return ret;
    }

    private ArrayList<Node> pickChildren(ArrayList<Node> _nodes, Node _branch, LinkedHashMap<Node, String> _index) {
        ArrayList<Node> children = new ArrayList<Node>();
        int count = 0;
        boolean isChild = false;
        if (this.isStartOfBranch(_index.get(_branch))) {
            count = -1;
        }
        for (Node node : _nodes.subList(_nodes.indexOf(_branch) + 1, _nodes.size())) {
            String notation = _index.get(node);
            if (isChild) {
                children.add(node);
            }
            if (count == 0 && !this.isBisecting(notation) && (this.isStartOfBranch(notation) || this.isEndOfBranch(notation) || this.haveChild(notation))) break;
            if (this.isStartOfBranch(notation)) {
                --count;
            }
            if (this.isEndOfBranch(notation)) {
                ++count;
            }
            if (this.isBisecting(notation)) {
                --count;
            }
            if (count == 0) {
                if (this.isBisecting(notation)) {
                    isChild = true;
                }
                if (!this.isEndOfBranch(notation)) continue;
                isChild = true;
                continue;
            }
            isChild = false;
        }
        return children;
    }

    private boolean isBisecting(String _notation) {
        return _notation.endsWith("]");
    }

    private boolean haveChild(String _notation) {
        return _notation.startsWith("-");
    }

    private boolean isStartOfBranch(String _notation) {
        return _notation.startsWith("]-");
    }

    private boolean isEndOfBranch(String _notation) {
        if (_notation.matches("\\[\\d\\).+")) {
            return false;
        }
        return _notation.startsWith("[");
    }
}

