/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC.condensed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACStacker;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.MonosaccharideIndex;

public class IUPACCondensedLinkageParser {
    private final HashMap<Node, String> nodeIndex;
    private final GlyContainer glyCo;
    private final IUPACStacker stacker;

    public IUPACCondensedLinkageParser(GlyContainer _glyCo, HashMap<Node, String> _nodeIndex, IUPACStacker _stacker) {
        this.nodeIndex = _nodeIndex;
        this.glyCo = _glyCo;
        this.stacker = _stacker;
    }

    public GlyContainer start() throws GlycanException {
        for (Node node : this.stacker.getNodes()) {
            String notation = this.nodeIndex.get(node);
            if (!this.isRootOfFramgnets(notation) && !this.stacker.isComposition()) continue;
            this.glyCo.addGlycanUndefinedUnit(this.makeUndefinedUnit(node, notation));
        }
        for (Node node : this.stacker.getNodes()) {
            if (node instanceof Substituent) {
                this.parseSubstituent(node);
                continue;
            }
            this.parseLinkage(node);
        }
        return this.glyCo;
    }

    private void parseSubstituent(Node _node) throws GlycanException {
        Edge edge = new Edge();
        Node acceptor = this.stacker.getParent(_node);
        edge.setSubstituent(_node);
        edge.setParent(acceptor);
        acceptor.addChildEdge(edge);
        _node.addParentEdge(edge);
        edge.addGlycosidicLinkage(((Substituent)_node).getFirstPosition());
    }

    private void parseLinkage(Node _node) throws GlycanException {
        String notation = this.nodeIndex.get(_node);
        Node acceptor = this.stacker.getParent(_node);
        if (this.haveStartRepeat(notation)) {
            throw new GlycanException("Repeating unit can not parse in the IUPAC-Condensed importer.");
        }
        this.parseSimpleLinkage(_node, acceptor, notation);
        if (acceptor == null && !this.glyCo.containsNode(_node)) {
            this.glyCo.addNode(_node);
        }
    }

    private void parseSimpleLinkage(Node _donor, Node _acceptor, String _notation) throws GlycanException {
        String linkNotation = this.extractLinkage(_notation);
        if (linkNotation.equals("") || linkNotation.equals("-")) {
            return;
        }
        for (String unit : linkNotation.split(":")) {
            Matcher matPos = Pattern.compile("([\\d?])-(([\\d?])?([(A-Za-z)]+)([\\d?])?-)?(([\\d?/]+)([ab?])?)").matcher(unit);
            if (!matPos.find()) continue;
            Edge edge = new Edge();
            Linkage linkage = new Linkage();
            linkage.addChildLinkage(this.charToInt(matPos.group(1).charAt(0)));
            for (String pos : matPos.group(7).split("/")) {
                linkage.addParentLinkage(this.charToInt(pos.charAt(0)));
            }
            if (matPos.group(2) != null) {
                BaseCrossLinkedTemplate subface = BaseCrossLinkedTemplate.forIUPACNotation(matPos.group(4));
                Substituent bridge = new Substituent(subface, new Linkage(), new Linkage());
                if (matPos.group(1) != null) {
                    bridge.getFirstPosition().addParentLinkage(this.charToInt(matPos.group(1).charAt(0)));
                }
                if (matPos.group(3) != null) {
                    bridge.getFirstPosition().addChildLinkage(this.charToInt(matPos.group(3).charAt(0)));
                }
                if (matPos.group(5) != null) {
                    bridge.getFirstPosition().addChildLinkage(this.charToInt(matPos.group(5).charAt(0)));
                }
                if (matPos.group(7) != null) {
                    bridge.getSecondPosition().addParentLinkage(this.charToInt(matPos.group(7).charAt(0)));
                }
                edge.setSubstituent(bridge);
                bridge.addParentEdge(edge);
            }
            edge.addGlycosidicLinkage(linkage);
            if (_acceptor != null) {
                this.modifyStructureState(_acceptor, matPos.group(6));
                if (!this.stacker.isFragment()) {
                    this.glyCo.addNode(_acceptor, edge, _donor);
                }
            }
            if (_acceptor != null || matPos.group(7) == null) continue;
            _donor.addParentEdge(edge);
            edge.setChild(_donor);
            GlycanUndefinedUnit und = this.glyCo.getUndefinedUnitWithIndex(_donor);
            und.setConnection(edge);
        }
    }

    private void parseRepeating(Node _donor, Node _acceptor, String _linkage) {
    }

    private String extractLinkage(String _notation) {
        String ret = "";
        Matcher matPos = Pattern.compile(".+\\(([ab?]?[\\d?]-(.+))\\).?").matcher(_notation);
        if (matPos.find()) {
            return matPos.group(1);
        }
        return ret;
    }

    private Integer charToInt(char _position) {
        if (_position == '?') {
            return -1;
        }
        return Integer.parseInt(String.valueOf(_position));
    }

    private boolean isRootOfFramgnets(String _notation) {
        if (_notation.lastIndexOf("$,") != -1) {
            return true;
        }
        return _notation.lastIndexOf("$") == _notation.length() - 1;
    }

    private GlycanUndefinedUnit makeUndefinedUnit(Node _node, String _notation) throws GlycanException {
        GlycanUndefinedUnit ret = new GlycanUndefinedUnit();
        ret.addNode(_node);
        for (Node parent : this.parseFragmentParents(_notation)) {
            ret.addParentNode(parent);
        }
        return ret;
    }

    public ArrayList<Node> parseFragmentParents(String _fragment) {
        ArrayList<Node> ret = new ArrayList<Node>();
        String anchor = _fragment.substring(_fragment.indexOf("=") + 1, _fragment.length() - 1);
        for (Node node : this.nodeIndex.keySet()) {
            String target;
            String notation = this.nodeIndex.get(node);
            if (notation.equals(_fragment)) continue;
            if (notation.contains("=") && notation.startsWith("?$") && anchor.equals(target = notation.endsWith(",") ? notation.substring(notation.indexOf("=") + 1, notation.length() - 1) : notation.substring(notation.indexOf("=") + 1))) {
                ret.add(node);
            }
            if (!notation.contains("|") && !notation.contains("$") || notation.contains("=")) continue;
            String temp = "";
            for (int i = 0; i < notation.length(); ++i) {
                char unit = notation.charAt(i);
                if (String.valueOf(unit).matches("\\d")) {
                    temp = temp + unit;
                }
                if (unit != '$') continue;
                if (anchor.endsWith(temp = temp + unit)) {
                    ret.add(node);
                }
                temp = "";
            }
        }
        return ret;
    }

    private String extractLinkageNotation(String _notation) {
        Matcher matLin = Pattern.compile("\\(([ab?].+)\\)?").matcher(_notation);
        if (matLin.find()) {
            return matLin.group(1);
        }
        return "";
    }

    private boolean haveStartRepeat(String _notation) {
        for (String item : this.extractLinkageNotation(_notation).split(":")) {
            if (!item.matches("[ab?][\\d?]-][\\dn-]+")) continue;
            return true;
        }
        return false;
    }

    private Node modifyStructureState(Node _acceptor, String _linkage) throws GlycanException {
        if (_acceptor instanceof Substituent) {
            return _acceptor;
        }
        if (_linkage.length() != 2) {
            return _acceptor;
        }
        Monosaccharide acceptor = (Monosaccharide)_acceptor;
        if (_linkage.charAt(1) == 'a') {
            acceptor.setAnomer(AnomericStateDescriptor.ALPHA);
        } else if (_linkage.charAt(1) == 'b') {
            acceptor.setAnomer(AnomericStateDescriptor.BETA);
        } else {
            acceptor.setAnomer(AnomericStateDescriptor.UNKNOWN_STATE);
        }
        if (_linkage.charAt(0) == '?') {
            acceptor.setAnomericPosition(-1);
        } else {
            acceptor.setAnomericPosition(Integer.parseInt(String.valueOf(_linkage.charAt(0))));
        }
        String notation = this.nodeIndex.get(_acceptor);
        Matcher matMono = Pattern.compile("([LD?]-?)?([468]?[dei])?([A-Z][a-z]{1,2}C?|KDN|[a-zA-Z]{6})([pf?])?(5[GA]c|N[AG]c|NA|A|N)?([A-Za-z]+)?").matcher(notation);
        String ringSize = "";
        if (matMono.find() && matMono.group(4) != null) {
            if (matMono.group(4).equals("?") && matMono.group(6) == null) {
                ringSize = matMono.group(4);
            }
            if (!matMono.group(4).equals("?")) {
                ringSize = matMono.group(4);
            }
        }
        if (ringSize.equals("")) {
            String stereo = acceptor.getStereos().getFirst();
            stereo = stereo.length() == 4 ? stereo.substring(1) : stereo;
            MonosaccharideIndex mi = MonosaccharideIndex.forTrivialNameWithIgnore(stereo);
            ringSize = mi.getRingSize();
        }
        if (ringSize.equals("p")) {
            if (acceptor.getAnomericPosition() == 1) {
                acceptor.setRing(1, 5);
            }
            if (acceptor.getAnomericPosition() == 2) {
                acceptor.setRing(2, 6);
            }
        } else if (ringSize.equals("f")) {
            if (acceptor.getAnomericPosition() == 1) {
                acceptor.setRing(1, 4);
            }
            if (acceptor.getAnomericPosition() == 2) {
                acceptor.setRing(2, 5);
            }
        } else {
            acceptor.setRing(acceptor.getAnomericPosition(), -1);
        }
        return _acceptor;
    }
}

