/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.Glycan;

import java.util.ArrayList;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.util.visitor.ContainerVisitor;
import org.glycoinfo.GlycanFormatconverter.util.visitor.Visitable;
import org.glycoinfo.GlycanFormatconverter.util.visitor.VisitorException;

public class Edge
implements Visitable {
    private Node parent = null;
    private Node child = null;
    private ArrayList<Linkage> linkages = new ArrayList();
    private Node substituent = null;

    public void setParent(Node _parent) {
        this.parent = _parent;
    }

    public void setChild(Node _child) {
        this.child = _child;
    }

    public void setSubstituent(Node _substituent) {
        this.substituent = _substituent;
    }

    public Node getChild() {
        return this.child;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getSubstituent() {
        return this.substituent;
    }

    public void setGlycosidicLinkages(ArrayList<Linkage> _linkages) throws GlycanException {
        if (_linkages == null) {
            throw new GlycanException("linkage is Null");
        }
        this.linkages.clear();
        for (Linkage linkage : _linkages) {
            this.addGlycosidicLinkage(linkage);
        }
        this.linkages = _linkages;
    }

    public ArrayList<Linkage> getGlycosidicLinkages() {
        ArrayList<Linkage> ret = new ArrayList<Linkage>();
        for (Linkage lin : this.linkages) {
            ret.add(lin);
        }
        return ret;
    }

    public boolean addGlycosidicLinkage(Linkage _linkage) throws GlycanException {
        if (_linkage == null) {
            throw new GlycanException("Linkage is Null");
        }
        if (!this.linkages.contains(_linkage)) {
            return this.linkages.add(_linkage);
        }
        return false;
    }

    public boolean removeGlycosidicLinkage(Linkage _linkage) {
        if (this.linkages.contains(_linkage)) {
            return this.linkages.remove(_linkage);
        }
        return false;
    }

    public boolean isRepeat() {
        if (this.substituent == null) {
            return false;
        }
        if (!(this.substituent instanceof GlycanRepeatModification)) {
            return false;
        }
        return !this.isCyclic();
    }

    public boolean isCyclic() {
        if (this.substituent == null) {
            return false;
        }
        if (!(this.substituent instanceof GlycanRepeatModification)) {
            return false;
        }
        GlycanRepeatModification cyclic = (GlycanRepeatModification)this.substituent;
        return cyclic.getMaxRepeatCount() == 1 && cyclic.getMinRepeatCount() == 1;
    }

    public boolean isReverseEdge() {
        if (this.substituent != null) {
            if (this.substituent instanceof GlycanRepeatModification) {
                return false;
            }
            if (this.child != null) {
                return true;
            }
        }
        if (this.linkages.size() > 1) {
            return false;
        }
        if (this.child == null) {
            return false;
        }
        Monosaccharide childMono = (Monosaccharide)this.child;
        int childPos = this.linkages.get(0).getChildLinkages().get(0);
        int anomericPos = childMono.getAnomericPosition();
        if (!childMono.getAnomer().equals((Object)AnomericStateDescriptor.OPEN)) {
            if (childPos != -1) {
                return true;
            }
            if (anomericPos != -1 && childPos == -1) {
                return true;
            }
        } else {
            if (anomericPos == childPos) {
                return true;
            }
            if (anomericPos == 0 && !this.linkages.get(0).getChildLinkages().contains(anomericPos)) {
                return true;
            }
        }
        return false;
    }

    public Edge copy() throws GlycanException {
        Edge ret = new Edge();
        for (Linkage linkage : this.linkages) {
            ret.addGlycosidicLinkage(linkage.copy());
        }
        if (this.substituent != null) {
            ret.setSubstituent(((Substituent)this.substituent).copy());
        }
        return ret;
    }

    @Override
    public void accept(ContainerVisitor _visitor) throws VisitorException {
        _visitor.visit(this);
    }
}

