/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionUtils;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.swt.graphics.Rectangle;

public class SelectCellCommandHandler
implements ILayerCommandHandler<SelectCellCommand> {
    private final SelectionLayer selectionLayer;

    public SelectCellCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SelectCellCommand command) {
        if (command.convertToTargetLayer(this.selectionLayer)) {
            this.toggleCell(command.getColumnPosition(), command.getRowPosition(), command.isShiftMask(), command.isControlMask(), command.isForcingEntireCellIntoViewport());
            this.selectionLayer.fireCellSelectionEvent(command.getColumnPosition(), command.getRowPosition(), command.isForcingEntireCellIntoViewport(), command.isShiftMask(), command.isControlMask());
            return true;
        }
        return false;
    }

    protected void toggleCell(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask, boolean forcingEntireCellIntoViewport) {
        boolean selectCell = true;
        if (SelectionUtils.isControlOnly(withShiftMask, withControlMask) && this.selectionLayer.isCellPositionSelected(columnPosition, rowPosition)) {
            ILayerCell cell = this.selectionLayer.getCellByPosition(columnPosition, rowPosition);
            Rectangle cellRect = new Rectangle(cell.getOriginColumnPosition(), cell.getOriginRowPosition(), cell.getColumnSpan(), cell.getRowSpan());
            this.selectionLayer.clearSelection(cellRect);
            selectCell = false;
        }
        if (selectCell) {
            this.selectCell(columnPosition, rowPosition, withShiftMask, withControlMask);
        }
    }

    public void selectCell(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        ILayerCell cell;
        if (!withShiftMask && !withControlMask) {
            this.selectionLayer.clear(false);
        }
        if ((cell = this.selectionLayer.getCellByPosition(columnPosition, rowPosition)) != null) {
            this.selectionLayer.setLastSelectedCell(cell.getOriginColumnPosition(), cell.getOriginRowPosition());
            if (this.selectionLayer.getSelectionModel().isMultipleSelectionAllowed() && withShiftMask && this.selectionLayer.getLastSelectedRegion() != null && this.selectionLayer.hasRowSelection() && this.selectionLayer.getSelectionAnchor().rowPosition != -1 && this.selectionLayer.getSelectionAnchor().columnPosition != -1) {
                Rectangle lastSelected = new Rectangle(this.selectionLayer.getLastSelectedRegion().x, this.selectionLayer.getLastSelectedRegion().y, this.selectionLayer.getLastSelectedRegion().width, this.selectionLayer.getLastSelectedRegion().height);
                if (cell.getRowPosition() > this.selectionLayer.getSelectionAnchor().rowPosition) {
                    int maxRowPosition = cell.getOriginRowPosition() + cell.getRowSpan() - 1;
                    lastSelected.height = Math.abs(this.selectionLayer.getSelectionAnchor().rowPosition - maxRowPosition) + 1;
                } else {
                    int minRowPosition = cell.getOriginRowPosition();
                    lastSelected.height = Math.abs(this.selectionLayer.getSelectionAnchor().rowPosition - minRowPosition) + 1;
                }
                lastSelected.y = Math.min(this.selectionLayer.getSelectionAnchor().rowPosition, cell.getOriginRowPosition());
                if (cell.getColumnPosition() > this.selectionLayer.getSelectionAnchor().columnPosition) {
                    int maxColumnPosition = cell.getOriginColumnPosition() + cell.getColumnSpan() - 1;
                    lastSelected.width = Math.abs(this.selectionLayer.getSelectionAnchor().columnPosition - maxColumnPosition) + 1;
                } else {
                    int minColumnPosition = cell.getOriginColumnPosition();
                    lastSelected.width = Math.abs(this.selectionLayer.getSelectionAnchor().columnPosition - minColumnPosition) + 1;
                }
                lastSelected.x = Math.min(this.selectionLayer.getSelectionAnchor().columnPosition, cell.getOriginColumnPosition());
                this.selectionLayer.setLastSelectedRegion(lastSelected);
                this.selectionLayer.addSelection(this.selectionLayer.getLastSelectedRegion());
            } else {
                this.selectionLayer.setLastSelectedRegion(null);
                Rectangle selection = new Rectangle(cell.getOriginColumnPosition(), cell.getOriginRowPosition(), cell.getColumnSpan(), cell.getRowSpan());
                this.selectionLayer.addSelection(selection);
            }
        }
    }

    @Override
    public Class<SelectCellCommand> getCommandClass() {
        return SelectCellCommand.class;
    }
}

