/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions;

import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.archive.config.ImageRegistry;
import org.grits.toolbox.entry.archive.editor.ArchiveEntryEditor;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.FileArchivePage;
import org.grits.toolbox.entry.archive.model.ArchivedFile;
import org.grits.toolbox.entry.archive.utility.UniqueNameValidator;
import org.grits.toolbox.entry.archive.utility.UtilityFileName;

public class RenameArchivedFile
extends Action {
    private static Logger logger = Logger.getLogger(RenameArchivedFile.class);
    private FileArchivePage page = null;

    public RenameArchivedFile(FileArchivePage fileArchivePage) {
        this.page = fileArchivePage;
        this.setText("Rename");
        this.setToolTipText("Rename the File");
        this.setImageDescriptor(ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.archive", ImageRegistry.ArchiveImage.RENAME_ICON));
    }

    public void run() {
        block5: {
            logger.debug((Object)"Start - Renaming  Archive File");
            TreeViewer treeViewer = this.page.getLeftSideTreeViewer();
            if (!treeViewer.getSelection().isEmpty()) {
                ArchivedFile selectedArchivedFile = (ArchivedFile)((TreeSelection)treeViewer.getSelection()).getFirstElement();
                List inputArchivedFiles = (List)treeViewer.getInput();
                ArchiveEntryEditor archiveEntryEditor = this.page.getEditor();
                File archiveFolder = archiveEntryEditor.getArchiveFolder();
                try {
                    String newName;
                    HashSet<String> existingNames = UtilityFileName.getExistingNames(inputArchivedFiles, archiveFolder);
                    existingNames.remove(selectedArchivedFile.getTypicalArchivedFile().getFileName());
                    InputDialog renameDialog = new InputDialog(Display.getCurrent().getActiveShell(), "RenameArchivedFile", "Please give a unique name to this archive", selectedArchivedFile.getTypicalArchivedFile().getFileName(), (IInputValidator)new UniqueNameValidator(existingNames));
                    if (renameDialog.open() != 0) break block5;
                    String previousName = selectedArchivedFile.getTypicalArchivedFile().getFileName();
                    if (new File(archiveFolder, previousName).renameTo(new File(archiveFolder, newName = renameDialog.getValue()))) {
                        Date modifiedDate = archiveEntryEditor.renameArchive(previousName, newName);
                        selectedArchivedFile.setModifiedDate(modifiedDate);
                        selectedArchivedFile.getTypicalArchivedFile().setFileName(newName);
                        treeViewer.refresh();
                        treeViewer.setSelection(treeViewer.getSelection());
                        logger.debug((Object)("Renamed successfully : " + selectedArchivedFile.getTypicalArchivedFile().getFileName()));
                        break block5;
                    }
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"RenameArchivedFile Unsuccessful", (String)"The archive file could not be renamed.");
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"RenameArchivedFile Unsuccessful", (String)"The archive file could not be renamed.");
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"No File Selected", (String)"Please select a file to rename.");
            }
        }
    }
}

