/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

public interface ICarbonDescriptor {
    public static final ModificationType H = ModificationType.H;
    public static final ModificationType X1 = ModificationType.X1;
    public static final ModificationType X2 = ModificationType.X2;
    public static final ModificationType X3 = ModificationType.X3;
    public static final String SP = "sp";
    public static final String SP2 = "sp2";
    public static final String SP3 = "sp3";
    public static final String SPX = "?";
    public static final String R = "R";
    public static final String S = "S";
    public static final String r = "r";
    public static final String s = "s";
    public static final String X = "X";
    public static final String E = "E";
    public static final String Z = "Z";
    public static final String N = "N";

    public char getChar();

    public String getHybridOrbital();

    public Boolean isTerminal();

    public Boolean isAnomeric();

    public int getNumberOfUniqueModifications();

    public String getStereo();

    public boolean isChiral();

    public ModificationType getModificationType(int var1);

    public String getModification(int var1);

    public int getNumberOfModifications();

    public int getNumberOfHydrogens();

    public int getCarbonScore();

    public ICarbonDescriptor getInverted();

    public static enum ModificationType {
        H("-H", 1, true),
        X1("-X", 1, false),
        X2("=X", 2, false),
        X3("#X", 3, false);

        private String m_strSymbol;
        private int m_iOrder;
        private boolean m_bIsHydrogen;

        private ModificationType(String strSymbol, int iOrder, boolean bIsHydrogen) {
            this.m_strSymbol = strSymbol;
            this.m_iOrder = iOrder;
            this.m_bIsHydrogen = bIsHydrogen;
        }

        public String getSymbol() {
            return this.m_strSymbol;
        }

        public int getOrder() {
            return this.m_iOrder;
        }

        public boolean isHydrogen() {
            return this.m_bIsHydrogen;
        }

        public static ModificationType forSymbol(String a_strSymbol) {
            for (ModificationType type : ModificationType.values()) {
                if (!type.m_strSymbol.equals(a_strSymbol)) continue;
                return type;
            }
            return null;
        }

        public static ModificationType forConnection(int a_iOrder, boolean a_bIsHydrogen) {
            for (ModificationType type : ModificationType.values()) {
                if (type.m_iOrder != a_iOrder || type.m_bIsHydrogen != a_bIsHydrogen) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.m_strSymbol;
        }
    }
}

