/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.property.chemical;

import java.util.HashMap;
import java.util.TreeSet;
import org.glycoinfo.WURCSFramework.util.property.AtomicProperties;
import org.glycoinfo.WURCSFramework.util.property.chemical.WURCSChemicalCompositionException;

public abstract class ChemicalCompositionCalculatorAbstract {
    private HashMap<AtomicProperties, Integer> m_mapAtomToNumber = new HashMap();

    public void addNumberOfElements(AtomicProperties a_enumAP, int a_nCount) {
        int t_nCount = a_nCount;
        if (this.m_mapAtomToNumber.containsKey((Object)a_enumAP)) {
            t_nCount += this.m_mapAtomToNumber.get((Object)a_enumAP).intValue();
        }
        this.m_mapAtomToNumber.put(a_enumAP, t_nCount);
    }

    public void margeNumberOfElements(ChemicalCompositionCalculatorAbstract a_oComp) {
        HashMap<AtomicProperties, Integer> t_mapAtomToNumber = a_oComp.getNumberOfElements();
        for (AtomicProperties t_enumAP : t_mapAtomToNumber.keySet()) {
            this.addNumberOfElements(t_enumAP, t_mapAtomToNumber.get((Object)t_enumAP));
        }
    }

    public HashMap<AtomicProperties, Integer> getNumberOfElements() {
        return this.m_mapAtomToNumber;
    }

    public String getComposition() {
        String t_strComposition = "";
        if (this.m_mapAtomToNumber.containsKey((Object)AtomicProperties.C)) {
            t_strComposition = t_strComposition + "C" + this.m_mapAtomToNumber.get((Object)AtomicProperties.C);
        }
        if (this.m_mapAtomToNumber.containsKey((Object)AtomicProperties.H)) {
            t_strComposition = t_strComposition + "H" + this.m_mapAtomToNumber.get((Object)AtomicProperties.H);
        }
        TreeSet<String> t_aSymbols = new TreeSet<String>();
        for (AtomicProperties t_enumAP : this.m_mapAtomToNumber.keySet()) {
            if (t_enumAP == AtomicProperties.C || t_enumAP == AtomicProperties.H) continue;
            t_aSymbols.add(t_enumAP.getSymbol());
        }
        for (String t_strSymbol : t_aSymbols) {
            t_strComposition = t_strComposition + t_strSymbol + this.m_mapAtomToNumber.get((Object)AtomicProperties.forSymbol(t_strSymbol));
        }
        return t_strComposition;
    }

    public abstract void start() throws WURCSChemicalCompositionException;
}

