/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.annotation.sugar.GlycanExtraInfo;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;

public class GlycanObjectHandler {
    private static final Logger logger = Logger.getLogger(GlycanObjectHandler.class);
    private static final HashMap<String, Glycan> m_hmGStructureToGlycan = new HashMap();
    private static final Pattern m_p1 = Pattern.compile("(-1)(\\)\\d+n)");
    private static final Pattern m_p2 = Pattern.compile("(n\\()(\\-1)");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Glycan getGlycanObject(GlycanStructure structure) {
        if ((structure.getSequence() != null || structure.getGWBSequence() != null) && m_hmGStructureToGlycan.containsKey(structure.getId())) {
            return m_hmGStructureToGlycan.get(structure.getId());
        }
        Glycan t_glycan = null;
        try {
            if (structure.getGWBSequence() != null && !structure.getGWBSequence().isEmpty()) {
                t_glycan = Glycan.fromString((String)structure.getGWBSequence());
                if (structure.getSequenceFormat() == null || !structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED)) {
                    structure.setSequence(t_glycan.toGlycoCTCondensed());
                }
            } else {
                if (structure.getSequence() == null || structure.getSequence().isEmpty()) throw new Exception("Sequence not specfied for structure: " + structure.getId());
                if (structure.getSequenceFormat() == null || structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYDEII)) {
                    Sugar t_sugar = GlycanExtraInfo.glydeToSugar((String)structure.getSequence());
                    String t_glycoCT = GlycanExtraInfo.sugarToGlycoCT((Sugar)t_sugar);
                    t_glycan = Glycan.fromGlycoCTCondensed((String)t_glycoCT);
                    structure.setSequence(t_glycan.toGlycoCTCondensed());
                } else if (structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED)) {
                    t_glycan = Glycan.fromGlycoCTCondensed((String)structure.getSequence());
                } else {
                    if (!structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_XML)) throw new Exception("Unsupported sequence type (" + structure.getSequenceFormat() + ") for structure: " + structure.getId());
                    t_glycan = Glycan.fromGlycoCT((String)structure.getSequence());
                    structure.setSequence(t_glycan.toGlycoCTCondensed());
                }
            }
            Matcher m1 = m_p1.matcher(structure.getSequence());
            Matcher m2 = m_p2.matcher(structure.getSequence());
            if (m1.find()) {
                StringBuffer sb = new StringBuffer(structure.getSequence().length());
                m1.reset();
                while (m1.find()) {
                    String match1 = m2.group(1);
                    String match2 = m2.group(2);
                    match1 = match1.replace("-1", "1");
                    String sNew = String.valueOf(Matcher.quoteReplacement(match1)) + match2;
                    m1.appendReplacement(sb, sNew);
                }
                m1.appendTail(sb);
                structure.setSequence(sb.toString().trim());
            } else if (m2.find()) {
                StringBuffer sb = new StringBuffer(structure.getSequence().length());
                m2.reset();
                while (m2.find()) {
                    String match1 = m2.group(1);
                    String match2 = m2.group(2);
                    match2 = match2.replace("-1", "1");
                    String sNew = String.valueOf(match1) + Matcher.quoteReplacement(match2);
                    m2.appendReplacement(sb, sNew);
                }
                m2.appendTail(sb);
                structure.setSequence(sb.toString().trim());
            }
            structure.setSequenceFormat(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED);
            if (t_glycan != null && structure.getGWBSequence() == null) {
                structure.setGWBSequence(t_glycan.toString());
            }
        }
        catch (GlycoVisitorException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SugarImporterException e) {
            logger.error((Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        if (t_glycan == null) return t_glycan;
        m_hmGStructureToGlycan.put(structure.getId(), t_glycan);
        return t_glycan;
    }
}

