/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConverter;
import org.glycomedb.residuetranslator.ResidueTranslator;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.MSGlycanAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.MSGlycanAnnotationViewerPreferenceLoader;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.MSGlycanAnnotationCartoonPreferences;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMScan;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.tablecore.IGritsTable;
import org.grits.toolbox.entry.ms.annotation.glycan.command.MSGlycanAnnotationViewColumnChooserCommandHandler;
import org.grits.toolbox.entry.ms.annotation.glycan.command.ViewMSOverviewCommandExecutor;
import org.grits.toolbox.entry.ms.annotation.glycan.filter.MSGlycanAnnotationFilterVisitor;
import org.grits.toolbox.entry.ms.annotation.glycan.process.loader.MSGlycanAnnotationImageConversion;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers.GlycanStructureExportConfiguration;
import org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers.MSGlycanAnnotationCellOverrideLabelAccumulator;
import org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers.MSGlycanAnnotationSummaryTable;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationSummary;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.AutoResizeImagePainter;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationCellOverrideLabelAccumulatorForRowHeader;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.SharedCheckboxWidget;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationDetails;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationEntityScroller;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationTableBase;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.utils.data.CartoonOptions;
import org.grits.toolbox.utils.image.GlycanImageProvider;
import org.grits.toolbox.utils.process.GlycoWorkbenchUtil;
import org.grits.toolbox.widgets.processDialog.ProgressBarWithErrorListener;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;

public class MSGlycanAnnotationTable
extends MSAnnotationTable {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationTable.class);
    public static final String GLYCAN_ID_PREFIX = "GlycanID: ";
    protected MSGlycanAnnotationImageConversion imageLoader;
    private GlycoWorkbenchUtil m_gwbUtil;

    public MSGlycanAnnotationTable(MSAnnotationTableBase parent, TableDataProcessor xmlExtractor) throws Exception {
        super(parent, xmlExtractor);
        this.initializeGlycoWorkbench();
    }

    public MSGlycanAnnotationTable(Composite parent, MSGlycanAnnotationTable parentTable, int iParentRowIndex, int iParentScanNum, String sParentRowId) {
        super(parent, (MSAnnotationTable)parentTable, iParentRowIndex, iParentScanNum, sParentRowId);
        this.initializeGlycoWorkbench();
    }

    public MSGlycanAnnotationTable(Composite parent, TableDataProcessor tableDataExtractor) {
        super(parent, tableDataExtractor);
        this.initializeGlycoWorkbench();
    }

    private void initializeGlycoWorkbench() {
        Config t_objConf = new Config();
        MonosaccharideConverter t_msdb = new MonosaccharideConverter(t_objConf);
        try {
            this.m_gwbUtil = new GlycoWorkbenchUtil((MonosaccharideConversion)new ResidueTranslator(), (MonosaccharideConversion)t_msdb);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void loadData() throws Exception {
        super.loadData();
        int iSuccess = this.performImageConversion(this.getShell());
        if (iSuccess == GRITSProcessStatus.ERROR) {
            throw new Exception("Failed to convert images.");
        }
        if (iSuccess == GRITSProcessStatus.CANCEL) {
            this.getTableDataProcessor().cancelWork();
            return;
        }
    }

    public void createMainTable() throws Exception {
        try {
            this.initCommonTableComponents();
            this.initColumnChooserLayer();
            this.registerDataUpdateHandler();
            this.registerEditableColumns(this.configRegistry);
            this.registerLockedIcons(this.configRegistry);
            this.registerFilterStyle((IConfigRegistry)this.configRegistry, true);
            this.registerDoubleStyles((IConfigRegistry)this.configRegistry);
            this.registerPolarityStyle(this.configRegistry);
            this.updateRowVisibilityAfterRead();
            this.updateEventListForVisibility();
            this.updateImageRegistry(false);
            this.bLoadedSubset = false;
            this.finishNatTable();
            this.performAutoResizeAfterPaint();
            this.initialSort();
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing table.", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public void reInit(Composite parent, MSAnnotationTable parentTable, int iParentRowIndex, int iParentScanNum, String sParentRowId) {
        super.reInit(parent, parentTable, iParentRowIndex, iParentScanNum, sParentRowId);
    }

    public void createSubsetTable() {
        try {
            this.loadDataFromParent();
            MSAnnotationViewerPreference parentPref = (MSAnnotationViewerPreference)this.parentTable.getPreference();
            MSGlycanAnnotationViewerPreference pref = this.loadPreference(parentPref);
            if (pref.getPreferenceSettings() == null) {
                pref.setPreferenceSettings(parentPref.getPreferenceSettings());
                pref.writePreference();
            } else {
                boolean bUpdate = this.addUnrecognizedHeadersToSubsetTable(parentPref, (MSAnnotationViewerPreference)pref);
                if (bUpdate) {
                    pref.writePreference();
                }
            }
            this.setPreference((MassSpecViewerPreference)pref);
            this.initCommonTableComponents();
            this.initColumnChooserLayer();
            this.registerSelectedCheckbox((IConfigRegistry)this.configRegistry, this.getCheckboxEditableRule());
            this.registerFilterStyle((IConfigRegistry)this.configRegistry, false);
            this.registerDoubleStyles((IConfigRegistry)this.configRegistry);
            this.bLoadedSubset = true;
            this.finishNatTable();
            this.performAutoResizeAfterPaint();
            this.parentTable.setCurrentSubsetTable((MSAnnotationTable)this);
            this.createCheckBoxPainters();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create subset table.", (Throwable)e);
        }
    }

    protected MSGlycanAnnotationViewerPreference loadPreference(MSAnnotationViewerPreference parentPref) {
        return MSGlycanAnnotationViewerPreferenceLoader.getTableViewerPreference((int)parentPref.getMSLevel(), (FillTypes)FillTypes.Selection);
    }

    protected void initColumnChooserLayer() {
        MSGlycanAnnotationViewColumnChooserCommandHandler columnChooserCommandHandler = new MSGlycanAnnotationViewColumnChooserCommandHandler((IGritsTable)this);
        this.columnGroupHeaderLayer.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
    }

    protected AbstractUiBindingConfiguration getUIBindingConfiguration() {
        return new GlycanStructureExportConfiguration(this.getMyTableDataObject().getCartoonCols(), this);
    }

    private MSGlycanAnnotationTableDataObject getMyTableDataObject() {
        return (MSGlycanAnnotationTableDataObject)this.getGRITSTableDataObject();
    }

    protected void loadDataFromParent() {
        super.loadDataFromParent();
        this.setImageLoader(((MSGlycanAnnotationTable)this.parentTable).getImageLoader());
    }

    public MSGlycanAnnotationImageConversion getImageLoader() {
        return this.imageLoader;
    }

    protected void setImageLoader(MSGlycanAnnotationImageConversion imageLoader) {
        this.imageLoader = imageLoader;
    }

    protected MSAnnotationMultiPageViewer getParentMultiPageViewer() {
        Entry parentEntry = this.parentView.getEntry().getParent();
        MSGlycanAnnotationMultiPageViewer viewer = MSGlycanAnnotationMultiPageViewer.getActiveViewerForEntry(this.parentView.getParentEditor().getContext(), parentEntry);
        return viewer;
    }

    public void performAutoResizeAfterPaint() {
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                MSGlycanAnnotationTable.this.performAutoResize();
                MSGlycanAnnotationTable.this.removeListener(9, this);
            }
        });
    }

    protected boolean rowNeedsResize(int iRowNum) {
        return super.rowNeedsResize(iRowNum);
    }

    protected MSGlycanAnnotationImageConversion getNewImageConverter() {
        return new MSGlycanAnnotationImageConversion();
    }

    public int performImageConversion(Shell shell) {
        try {
            this.setImageProviderCartoonOptions();
            this.imageLoader = new MSGlycanAnnotationImageConversion();
            this.imageLoader.setSimianTableData(this.getMyTableDataObject());
            this.imageLoader.setReportName(this.parentView.getTitle());
            ProgressBarWithErrorListener pbl = this.getTableDataProcessor().getProgressBarDialog().getMinorProgressBarListener(0);
            pbl.setMinValue(0);
            pbl.setMaxValue(this.getMyTableDataObject().getTableData().size());
            this.imageLoader.addProgressListeners((IProgressListener)this.getTableDataProcessor().getProgressBarDialog().getMinorProgressBarListener(0));
            this.imageLoader.convertImages();
            return GRITSProcessStatus.OK;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    public void setImageProviderCartoonOptions() {
        String sLayout = this.getMyTableDataObject().getCartoonPrefs().getImageLayout();
        String sStyle = this.getMyTableDataObject().getCartoonPrefs().getImageStyle();
        String sScaleFactor = this.getMyTableDataObject().getCartoonPrefs().getImageScaleFactor();
        String sOrientation = this.getMyTableDataObject().getCartoonPrefs().getOrientation();
        boolean bShowInfo = this.getMyTableDataObject().getCartoonPrefs().isShowInfo();
        boolean bShowMasses = this.getMyTableDataObject().getCartoonPrefs().isShowMasses();
        boolean bShowRedEnd = this.getMyTableDataObject().getCartoonPrefs().isShowRedEnd();
        CartoonOptions cartoonOptions = null;
        try {
            cartoonOptions = new CartoonOptions(MSGlycanAnnotationCartoonPreferences.getGWBlayoutString((String)sLayout), MSGlycanAnnotationCartoonPreferences.getGWBStyleString((String)sStyle), Double.valueOf(Double.parseDouble(sScaleFactor)), Integer.valueOf(MSGlycanAnnotationCartoonPreferences.getGWBOrientationCode((String)sOrientation)), bShowInfo, bShowMasses, bShowRedEnd);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        MSGlycanAnnotationTableDataObject.glycanImageProvider.setCartoonOptions(cartoonOptions);
    }

    public void refreshTableImages() {
        this.updateImageRegistry(true);
        this.finishUpdateHiddenRowsAfterEdit(false);
    }

    public void initCellAccumulator() {
        int polarityColumn;
        List intensityCols;
        MSGlycanAnnotationCellOverrideLabelAccumulator cellLabelAccumulator = null;
        MSAnnotationCellOverrideLabelAccumulatorForRowHeader rowHeaderCellAccumulator = null;
        ArrayList filterCols = this.getMyTableDataObject().getFilterCols();
        if (this.parentTable == null) {
            intensityCols = this.getAllIntensityColumns(null);
            Integer commentCol = null;
            if (this.getMyTableDataObject().getCommentCols() != null && !this.getMyTableDataObject().getCommentCols().isEmpty()) {
                commentCol = (Integer)this.getMyTableDataObject().getCommentCols().get(0);
            }
            Integer ratioCol = null;
            if (this.getMyTableDataObject().getRatioCols() != null && !this.getMyTableDataObject().getRatioCols().isEmpty()) {
                ratioCol = (Integer)this.getMyTableDataObject().getRatioCols().get(0);
            }
            cellLabelAccumulator = filterCols != null && !filterCols.isEmpty() ? new MSGlycanAnnotationCellOverrideLabelAccumulator(this.bodyDataProvider, this.getMyTableDataObject().getCartoonCols(), (Integer)filterCols.get(0), commentCol, ratioCol, intensityCols) : new MSGlycanAnnotationCellOverrideLabelAccumulator(this.bodyDataProvider, this.getMyTableDataObject().getCartoonCols(), null, commentCol, ratioCol, intensityCols);
            rowHeaderCellAccumulator = new MSAnnotationCellOverrideLabelAccumulatorForRowHeader((IRowDataProvider)this.bodyDataProvider, (MSAnnotationTable)this, Integer.valueOf(0));
        } else {
            intensityCols = this.getAllIntensityColumns(1);
            cellLabelAccumulator = filterCols != null && !filterCols.isEmpty() ? new MSGlycanAnnotationCellOverrideLabelAccumulator(this.bodyDataProvider, this.getMyTableDataObject().getCartoonCols(), 0, (Integer)filterCols.get(0), null, null, intensityCols) : new MSGlycanAnnotationCellOverrideLabelAccumulator(this.bodyDataProvider, this.getMyTableDataObject().getCartoonCols(), 0, null, null, null, intensityCols);
        }
        if (this.getTableDataProcessor() != null && this.getTableDataProcessor().getTempPreference() != null && (polarityColumn = this.getTableDataProcessor().getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_polarity.name())) != -1) {
            cellLabelAccumulator.setPolarityColumn(polarityColumn);
        }
        this.dataLayer.setConfigLabelAccumulator(cellLabelAccumulator);
        if (rowHeaderCellAccumulator != null) {
            this.rowHeaderDataLayer.setConfigLabelAccumulator(rowHeaderCellAccumulator);
        }
    }

    protected void initImageConfigRegistry() {
        try {
            if (this.getMyTableDataObject().getCartoonCols() != null && this.getGRITSTableDataObject().getTableData() != null && !this.getGRITSTableDataObject().getTableData().isEmpty()) {
                int i = 0;
                while (i < this.getGRITSTableDataObject().getTableData().size()) {
                    int j = 0;
                    while (j < this.getMyTableDataObject().getCartoonCols().size()) {
                        Integer iCartoonCol = (Integer)this.getMyTableDataObject().getCartoonCols().get(j);
                        String sCartoonFile = (String)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get(iCartoonCol);
                        if (sCartoonFile != null && !sCartoonFile.equals("")) {
                            Integer iSequenceCol = (Integer)this.getMyTableDataObject().getSequenceCols().get(j);
                            String sSequence = (String)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get(iSequenceCol);
                            if (sSequence != null && !sSequence.equals("")) {
                                this.registerImage(this.configRegistry, sSequence, sCartoonFile);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void initConfigRegistry() {
        super.initConfigRegistry();
        this.initImageConfigRegistry();
    }

    protected void updateImageRegistry(boolean bForceImageRedraw) {
        if (this.getGRITSTableDataObject().getTableData() == null || this.getGRITSTableDataObject().getTableData().isEmpty() || this.getMyTableDataObject().getPeakIdCols().isEmpty() || this.getMyTableDataObject().getCartoonCols().isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.getGRITSTableDataObject().getTableData().size()) {
            if (((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getCartoonCols().get(0)) != null) {
                int j = 0;
                while (j < this.getMyTableDataObject().getCartoonCols().size()) {
                    if (((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols() != null && !((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().isEmpty() && ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0)) != null) {
                        ((Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0))).intValue();
                    }
                    int iCartoonCol = (Integer)this.getMyTableDataObject().getCartoonCols().get(j);
                    int iPeakId = -1;
                    String sCartoonID = (String)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get(iCartoonCol);
                    if (sCartoonID != null && !sCartoonID.equals("")) {
                        Integer iSequenceCol = (Integer)this.getMyTableDataObject().getSequenceCols().get(j);
                        String sSequence = (String)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get(iSequenceCol);
                        if (this.getMyTableDataObject().getCartoonCols().size() == this.getMyTableDataObject().getPeakIdCols().size()) {
                            iPeakId = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getPeakIdCols().get(j));
                        }
                        Integer iParentScanNum = this.getScanNumberForVisibility((MSAnnotationTableDataObject)this.getMyTableDataObject(), i);
                        boolean bInvisible = this.getGRITSTableDataObject().isInvisibleRow(iParentScanNum, Integer.toString(iPeakId));
                        Object ob = this.configRegistry.getSpecificConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", sCartoonID);
                        if (bForceImageRedraw) {
                            this.configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", sCartoonID);
                            this.registerImage(this.configRegistry, sSequence, sCartoonID);
                        } else if (ob == null && !bInvisible) {
                            this.registerImage(this.configRegistry, sSequence, sCartoonID);
                        } else if (ob != null && bInvisible) {
                            this.configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", sCartoonID);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void registerImage(ConfigRegistry configRegistry, String sequence, String imgName) {
        try {
            GlycanImageProvider.GlycanImageObject image = MSGlycanAnnotationTableDataObject.glycanImageProvider.getImage(sequence);
            AutoResizeImagePainter imgPainter = new AutoResizeImagePainter(image, true, 5, true);
            Style cellStyle = new Style();
            cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.CENTER);
            cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignmentEnum.MIDDLE);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", imgName);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)imgPainter, "NORMAL", imgName);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void createCheckBoxPainters() {
        MSGlycanAnnotationTableDataObject tdo = (MSGlycanAnnotationTableDataObject)this.getGRITSTableDataObject();
        SharedCheckboxWidget scw = this.getSharedCheckboxWidget();
        scw.getHtGlycanToCheckBox().clear();
        int iNumRows = tdo.getTableData().size();
        int i = 0;
        while (i < iNumRows) {
            int j = 0;
            while (j < tdo.getCartoonCols().size()) {
                Integer iFeatureCol = (Integer)tdo.getFeatureIdCols().get(j);
                Integer iPeakCol = (Integer)tdo.getPeakIdCols().get(j);
                Integer iAnnotCol = (Integer)tdo.getAnnotationIdCols().get(j);
                if (iFeatureCol != null && iPeakCol != null && iAnnotCol != null) {
                    Integer iPeakId = (Integer)((GRITSListDataRow)tdo.getTableData().get(i)).getDataRow().get(iPeakCol);
                    String sFeature = (String)((GRITSListDataRow)tdo.getTableData().get(i)).getDataRow().get(iFeatureCol);
                    Integer iAnnotId = (Integer)((GRITSListDataRow)tdo.getTableData().get(i)).getDataRow().get(iAnnotCol);
                    if (iPeakId != null && sFeature != null && iAnnotId != null) {
                        Annotation annot = ((MSAnnotationTableDataProcessor)this.getTableDataProcessor()).getAnnotation(iAnnotId);
                        String sHeaderKey = MSAnnotationEntityScroller.getCombinedKeyForLookup((Integer)iPeakId, (String)sFeature);
                        Boolean bCurStatus = (Boolean)((GRITSListDataRow)tdo.getTableData().get(i)).getDataRow().get(0);
                        MSAnnotationEntityProperty prop = (MSAnnotationEntityProperty)((MSAnnotationTableDataProcessor)this.getTableDataProcessor()).getSourceProperty();
                        String sLabel = MSAnnotationDetails.getLabelForCheckbox((String)this.getAnnotationStructureId(annot), (String)sFeature, (int)(prop.getMsLevel() + 1));
                        this.getSharedCheckboxWidget().createCheckBoxPainter(sHeaderKey, sLabel, bCurStatus.booleanValue());
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected String getAnnotationStructureId(Annotation annot) {
        return GLYCAN_ID_PREFIX + ((GlycanAnnotation)annot).getStringId();
    }

    public void mouseDown(MouseEvent e) {
        super.mouseDown(e);
    }

    public void mouseDoubleClick(MouseEvent e) {
        super.mouseDoubleClick(e);
    }

    public void finishUpdateHiddenRowsAfterEdit(boolean isDirty) {
        this.highlightRows();
        this.updateImageRegistry(false);
        super.finishUpdateHiddenRowsAfterEdit(isDirty);
        if (!isDirty) {
            return;
        }
        MSAnnotationTable subsetTable = this.getCurrentSubsetTable();
        if (subsetTable == null) {
            return;
        }
        MSGlycanAnnotationMultiPageViewer viewer = MSGlycanAnnotationMultiPageViewer.getActiveSummaryViewer(this.parentView.getParentEditor().getContext(), this.parentView.getEntry(), subsetTable.getParentTableRowId());
        if (viewer != null) {
            MSGlycanAnnotationSummary summaryViewer = viewer.getSummaryView();
            summaryViewer.setParentSubsetTableData(this.getCurrentSubsetTable(), this.getCurrentRowIndex(), this.getCurrentParentScanNum(), this.getCurrentRowId());
            MSGlycanAnnotationSummaryTable summaryTable = (MSGlycanAnnotationSummaryTable)viewer.getSummaryView().getViewBase().getNatTable();
            summaryTable.updateHeaderCheckboxRegistry();
        }
    }

    public boolean startUpdateHiddenRowsAfterEdit(MSAnnotationTable subsetTable) {
        boolean bIsDirty = super.startUpdateHiddenRowsAfterEdit(subsetTable);
        MSGlycanAnnotationMultiPageViewer viewer = MSGlycanAnnotationMultiPageViewer.getActiveSummaryViewer(this.parentView.getParentEditor().getContext(), this.parentView.getEntry(), subsetTable.getParentTableRowId());
        if (bIsDirty && viewer != null) {
            viewer.getSummaryView().setParentSubsetTableData(subsetTable, this.getCurrentRowIndex(), this.getCurrentParentScanNum(), this.getCurrentRowId());
        }
        return bIsDirty;
    }

    protected void openRowSelection(int iSourceRowIndex, int iSourceParentScanNum, String sSourceParentRowId) {
        MSGlycanAnnotationMultiPageViewer.showRowSelection(this.parentView.getParentEditor().getContext(), this.parentView.getEntry(), this, iSourceRowIndex, iSourceParentScanNum, sSourceParentRowId);
    }

    protected void showMSOverview(Entry newEntry) {
        ViewMSOverviewCommandExecutor.showMSOverview(this.parentView.getParentEditor().getContext(), newEntry);
    }

    protected boolean applyFilter(Object filter, boolean _bOverrideManual, boolean highlightOnly) throws Exception {
        if (!(filter instanceof FilterSetting)) {
            return false;
        }
        int iNumRows = this.getBottomDataLayer().getRowCount();
        if (iNumRows == 0) {
            return false;
        }
        MSAnnotationTableDataProcessor tdp = (MSAnnotationTableDataProcessor)this.getTableDataProcessor();
        boolean isDirty = false;
        this.getTableDataProcessor().getProgressBarDialog().getMinorProgressBarListener(0).setMaxValue(iNumRows);
        this.getTableDataProcessor().getProgressBarDialog().getMinorProgressBarListener(0).setProgressValue(0);
        int i = 0;
        while (i < iNumRows && !this.getTableDataProcessor().getProgressBarDialog().isCanceled()) {
            this.getTableDataProcessor().getProgressBarDialog().getMinorProgressBarListener(0).setProgressValue(i + 1);
            this.getTableDataProcessor().getProgressBarDialog().getMinorProgressBarListener(0).setProgressMessage("Filtering row: " + (i + 1) + " of " + iNumRows);
            if (this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getParentNoCol().get(0)).intValue(), i) != null && this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i) != null && this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i) != null) {
                boolean bManuallyChanged;
                Integer iParentScanNo = this.getScanNumberForVisibility(this, i);
                Integer iPeakId = (Integer)this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i);
                Integer iScan = null;
                if (((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0)) != null) {
                    iScan = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0));
                }
                String sRowId = Feature.getRowId((Integer)iPeakId, iScan, (boolean)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getUsesComplexRowId());
                boolean bLocked = this.getGRITSTableDataObject().isLockedPeak(iParentScanNo, sRowId);
                if (!(bLocked && !highlightOnly || (bManuallyChanged = this.getGRITSTableDataObject().isManuallyChangedPeak(iParentScanNo, sRowId)) && !_bOverrideManual && !highlightOnly)) {
                    GRITSListDataRow rowData;
                    int j;
                    GRITSListDataRow backendRowData;
                    boolean bCurHidden;
                    String sId = this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i).toString();
                    boolean bPrevInvisible = this.getGRITSTableDataObject().isInvisibleRow(iParentScanNo, sRowId);
                    boolean bPrevHidden = this.getGRITSTableDataObject().isHiddenRow(iParentScanNo, sRowId, sId);
                    int sequenceCol = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getSequenceCols().get(0);
                    Integer filterCol = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().get(0);
                    String sequence = (String)this.getBottomDataLayer().getDataValueByPosition(sequenceCol, i);
                    boolean bl = bCurHidden = !this.passesFilters(sequence, (FilterSetting)filter, i);
                    if (!bCurHidden) {
                        if (highlightOnly) {
                            if (filterCol != -1) {
                                backendRowData = this.bodyDataProvider.getGRITSListDataRow(i);
                                j = this.getSourceIndexFromRowId(backendRowData.getId());
                                rowData = (GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(j);
                                rowData.getDataRow().set(filterCol, 10);
                            }
                        } else {
                            this.getGRITSTableDataObject().removeHiddenRow(iParentScanNo, sRowId, sId);
                            if (bPrevInvisible || bPrevHidden) {
                                isDirty = true;
                                tdp.addDirtyParentScan(iParentScanNo);
                            }
                        }
                    } else if (bCurHidden) {
                        if (highlightOnly) {
                            if (filterCol != -1) {
                                backendRowData = this.bodyDataProvider.getGRITSListDataRow(i);
                                j = this.getSourceIndexFromRowId(backendRowData.getId());
                                rowData = (GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(j);
                                rowData.getDataRow().set(filterCol, 0);
                            }
                        } else {
                            this.getGRITSTableDataObject().setHiddenRow(iParentScanNo, sRowId, sId);
                            if (!bPrevHidden || !bPrevInvisible) {
                                isDirty = true;
                                tdp.addDirtyParentScan(iParentScanNo);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        this.getTableDataProcessor().getProgressBarDialog().getMinorProgressBarListener(0).setProgressValue(iNumRows);
        this.getTableDataProcessor().getProgressBarDialog().getMinorProgressBarListener(0).setProgressMessage("Done!");
        if (this.getTableDataProcessor().getProgressBarDialog().isCanceled()) {
            return false;
        }
        return isDirty;
    }

    private boolean passesFilters(String sequence, FilterSetting filterSetting, int rowId) throws Exception {
        if (sequence != null && !sequence.isEmpty() && filterSetting != null) {
            MSGlycanAnnotationFilterVisitor filterVisitor = new MSGlycanAnnotationFilterVisitor();
            filterVisitor.setFilter(filterSetting.getFilter());
            int iInx1 = sequence.indexOf("~|~");
            if (iInx1 < 0) {
                this.m_gwbUtil.parseGWSSequence(sequence);
                Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                return filterVisitor.evaluate(this, rowId, glycan.toSugar());
            }
            String sRemaining = sequence;
            do {
                String sSeq = iInx1 > 0 ? sRemaining.substring(0, iInx1) : sRemaining;
                this.m_gwbUtil.parseGWSSequence(sSeq);
                Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                if (filterVisitor.evaluate(this, rowId, glycan.toSugar())) {
                    return true;
                }
                sRemaining = iInx1 > 0 ? sRemaining.substring(iInx1 + "~|~".length()) : null;
                int n = iInx1 = sRemaining != null ? sRemaining.indexOf("~|~") : -1;
            } while (sRemaining != null);
        }
        return true;
    }

    protected Entry getNewTableCompatibleEntry(Entry parentEntry) {
        Entry newEntry = MSGlycanAnnotationEntityProperty.getTableCompatibleEntry(parentEntry);
        return newEntry;
    }
}

