/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.dialog;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.dialog.MassSpecPeakIntensityApplyDialog;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MSGlycanAnnotationPeakIntensityApplyDialog
extends MassSpecPeakIntensityApplyDialog {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationPeakIntensityApplyDialog.class);

    public MSGlycanAnnotationPeakIntensityApplyDialog(Shell parentShell, MassSpecMultiPageViewer contextViewer, MassSpecTableDataObject msTableDataObject) {
        super(parentShell, contextViewer, msTableDataObject);
    }

    public MassSpecMultiPageViewer getCurrentViewer() {
        try {
            MSGlycanAnnotationMultiPageViewer viewer;
            EPartService partService = this.getContextViewer().getPartService();
            MPart mPart = partService.getActivePart();
            if (mPart != null && mPart.equals(mPart.getParent().getSelectedElement()) && mPart.getObject() instanceof MSGlycanAnnotationMultiPageViewer && (viewer = (MSGlycanAnnotationMultiPageViewer)((Object)mPart.getObject())).getEntry().getProperty() != null && viewer.getEntry().getProperty() instanceof MSAnnotationEntityProperty) {
                return viewer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Property getEntryParentProperty() {
        try {
            Entry entry = this.getEntryForCurrentViewer();
            MSAnnotationEntityProperty msep = (MSAnnotationEntityProperty)entry.getProperty();
            MassSpecProperty msp = msep.getMassSpecParentProperty();
            return msp;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public MassSpecUISettings getSourceMassSpecEntrySettings() {
        MassSpecProperty msp = (MassSpecProperty)this.getEntryParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        return entrySettings;
    }

    public MassSpecUISettings getEntrySettingsForInternalStandardFiles() {
        Entry entry = this.getEntryForCurrentViewer();
        MSAnnotationEntityProperty msep = (MSAnnotationEntityProperty)entry.getProperty();
        MSAnnotationMetaData entrySettings = msep.getMSAnnotationParentProperty().getMSAnnotationMetaData();
        return entrySettings;
    }

    protected void updateSettings() {
        MassSpecProperty property = (MassSpecProperty)this.getEntryParentProperty();
        try {
            Entry projectEntry = this.getEntryForCurrentViewer();
            Entry topEntry = MSAnnotationProperty.getFirstAnnotEntry((Entry)projectEntry);
            Entry msEntry = topEntry.getParent();
            String settingsFile = String.valueOf(MassSpecProperty.getFullyQualifiedFolderName((Entry)msEntry)) + File.separator + property.getMSSettingsFile().getName();
            property.marshallSettingsFile(settingsFile, property.getMassSpecMetaData());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void updateViewer() {
        try {
            MSGlycanAnnotationMultiPageViewer viewer = (MSGlycanAnnotationMultiPageViewer)this.getCurrentViewer();
            List sKeyVals = this.getColumnKeyLabels();
            viewer.reLoadStructureAnnotationTab(sKeyVals);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

