/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.wizard;

import java.io.File;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.FileSelectionAdapter;

public class PageThree
extends WizardPage {
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private Button msPeakListOptionBtn;
    private Label peakListLabel;
    private Combo peakListTypeList;
    private Label peakListFileLabel;
    private Text peakListFileText;
    private Button peakListFileBtn;
    private String peakListFileName = null;
    private String peakListFileFormat = null;
    private Composite container;

    public PageThree() {
        super("New MS Experiment");
        this.setTitle("New MS Experiment");
        this.setDescription("Create a new MS Experiment.");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = 10;
        this.container.setLayout((Layout)gridLayout);
        this.createPeakListOption(this.container);
        this.createPeakListComponents(this.container);
        this.setPeakListEnabled(false);
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    private void createPeakListOption(Composite container) {
        GridData msDIOptionBtnGridData = new GridData();
        this.msPeakListOptionBtn = new Button(container, 32);
        this.msPeakListOptionBtn.setText("Specify Peak List File");
        this.msPeakListOptionBtn.setLayoutData((Object)msDIOptionBtnGridData);
        msDIOptionBtnGridData.horizontalSpan = 4;
        msDIOptionBtnGridData.grabExcessHorizontalSpace = true;
        this.msPeakListOptionBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PageThree.this.setPeakListEnabled(PageThree.this.msPeakListOptionBtn.getSelection());
                PageThree.this.setPageComplete(PageThree.this.isReadyToFinish());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createPeakListComponents(Composite container) {
        Label label0 = new Label(container, 0);
        label0.setText("    ");
        this.peakListLabel = new Label(container, 0);
        this.peakListLabel.setText("Peak List File Format: ");
        GridData gdLabel = new GridData(768);
        this.peakListLabel.setLayoutData((Object)gdLabel);
        this.peakListLabel.setEnabled(false);
        this.peakListTypeList = new Combo(container, 8);
        GridData gdType = new GridData(768);
        this.peakListTypeList.setLayoutData((Object)gdType);
        this.peakListTypeList.setItems(new String[]{"Thermo Extract (.xml)", "Mascot generic (.mgf)"});
        this.peakListTypeList.select(0);
        this.peakListTypeList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageThree.this.setPageComplete(PageThree.this.isReadyToFinish());
            }
        });
        gdType.horizontalSpan = 2;
        this.peakListTypeList.setEnabled(false);
        Label label1 = new Label(container, 0);
        label1.setText("    ");
        this.peakListFileLabel = new Label(container, 0);
        this.peakListFileLabel.setText("Peak List File");
        this.peakListFileLabel = this.setMandatoryLabel(this.peakListFileLabel);
        this.peakListFileText = new Text(container, 2052);
        this.peakListFileText.setText("");
        GridData gdFileText = new GridData(768);
        this.peakListFileText.setLayoutData((Object)gdFileText);
        GridData peakListBrowseButtonData = new GridData();
        this.peakListFileBtn = new Button(container, 8);
        this.peakListFileBtn.setText("Browse");
        this.peakListFileBtn.setLayoutData((Object)peakListBrowseButtonData);
        FileSelectionAdapter peakListFileBrowserSelectionAdapter = new FileSelectionAdapter();
        peakListFileBrowserSelectionAdapter.setShell(container.getShell());
        peakListFileBrowserSelectionAdapter.setText(this.peakListFileText);
        String sXML = "*.xml";
        String sMGF = "*.mgf";
        peakListFileBrowserSelectionAdapter.setFilterExtensions(new String[]{String.valueOf(sXML) + ";" + sMGF, "*.*"});
        peakListFileBrowserSelectionAdapter.setFilterNames(new String[]{"Peak list files (" + sXML + ";" + sMGF + ")", "All files"});
        this.peakListFileBtn.addSelectionListener((SelectionListener)peakListFileBrowserSelectionAdapter);
        this.peakListFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageThree.this.peakListFileName = null;
                PageThree.this.peakListFileFormat = null;
                if (PageThree.this.msPeakListOptionBtn.getSelection()) {
                    PageThree.this.peakListFileName = PageThree.this.peakListFileText.getText();
                    PageThree.this.peakListFileFormat = null;
                    if (PageThree.this.peakListFileName.endsWith("xml")) {
                        PageThree.this.peakListFileFormat = "ThermoExtract";
                    } else if (PageThree.this.peakListFileName.endsWith("mgf")) {
                        PageThree.this.peakListFileFormat = "MascotGeneric";
                    }
                    if (PageThree.this.peakListTypeList.getText().equals("Thermo Extract (.xml)")) {
                        PageThree.this.peakListFileFormat = "ThermoExtract";
                    } else if (PageThree.this.peakListTypeList.getText().equals("Mascot generic (.mgf)")) {
                        PageThree.this.peakListFileFormat = "MascotGeneric";
                    }
                }
                PageThree.this.setPageComplete(PageThree.this.isReadyToFinish());
            }
        });
    }

    public void setPeakListEnabled(boolean _bVal) {
        this.peakListFileLabel.setEnabled(_bVal);
        this.peakListFileText.setEnabled(_bVal);
        this.peakListFileBtn.setEnabled(_bVal);
        this.peakListLabel.setEnabled(_bVal);
        this.peakListTypeList.setEnabled(_bVal);
    }

    protected Label createSeparator(Composite container, int span) {
        GridData separatorData = new GridData();
        separatorData.grabExcessHorizontalSpace = true;
        separatorData.horizontalAlignment = 4;
        separatorData.horizontalSpan = span;
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)separatorData);
        return separator;
    }

    protected Label setMandatoryLabel(Label lable) {
        lable.setText(String.valueOf(lable.getText()) + "*");
        lable.setFont(this.boldFont);
        return lable;
    }

    private boolean isReadyToFinish() {
        if (this.msPeakListOptionBtn.getSelection()) {
            if (this.msPeakListOptionBtn.getSelection() && this.peakListFileText.getText().isEmpty()) {
                this.setErrorMessage("Peak List option selected, but peak list file not specified.");
                return false;
            }
            if (!this.peakListFileText.getText().isEmpty() && !this.fileExists(this.peakListFileText.getText())) {
                this.setErrorMessage("Specified file for 'Peak List MS File' does not exist.");
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean fileExists(String _sFileName) {
        File file = new File(_sFileName);
        return file.exists();
    }

    public void save() {
        this.peakListFileName = null;
        this.peakListFileFormat = null;
        if (this.msPeakListOptionBtn.getSelection()) {
            this.peakListFileName = this.peakListFileText.getText();
            this.peakListFileFormat = null;
            if (this.peakListFileName.endsWith("xml")) {
                this.peakListFileFormat = "ThermoExtract";
            } else if (this.peakListFileName.endsWith("mgf")) {
                this.peakListFileFormat = "MascotGeneric";
            }
            if (this.peakListTypeList.getText().equals("Thermo Extract (.xml)")) {
                this.peakListFileFormat = "ThermoExtract";
            } else if (this.peakListTypeList.getText().equals("Mascot generic (.mgf)")) {
                this.peakListFileFormat = "MascotGeneric";
            }
        }
    }

    public IWizardPage getNextPage() {
        this.save();
        return super.getNextPage();
    }

    public String getPeakListFileName() {
        return this.peakListFileName;
    }

    public void setPeakListFileName(String peakListFileName) {
        this.peakListFileName = peakListFileName;
    }

    public String getPeakListFileFormat() {
        return this.peakListFileFormat;
    }

    public void setPeakListFileFormat(String peakListFileFormat) {
        this.peakListFileFormat = peakListFileFormat;
    }
}

