/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.dialogs;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.model.PlateLayout;

public class CustomSelectionDialogWithDescription
extends ListDialog {
    Object selection;
    Text name;
    Text description;
    Boolean sublist;
    List<?> input;

    public CustomSelectionDialogWithDescription(Shell parent, boolean sublist, Text name, List<?> input) {
        super(parent);
        this.sublist = sublist;
        this.name = name;
        this.input = input;
    }

    public Text getName() {
        return this.name;
    }

    public Text getDescription() {
        return this.description;
    }

    public Object getSelection() {
        return this.selection;
    }

    protected void okPressed() {
        super.okPressed();
        Object[] result = this.getResult();
        int i = 0;
        while (i < result.length) {
            this.selection = result[i];
            if (this.name != null) {
                if (this.selection instanceof GeneList) {
                    this.name.setText(((GeneList)this.selection).getListName());
                } else if (this.selection instanceof PlateLayout) {
                    this.name.setText(((PlateLayout)this.selection).getName());
                }
            }
            ++i;
        }
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        GridData descriptionTextData = new GridData();
        descriptionTextData.minimumHeight = 80;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.grabExcessVerticalSpace = true;
        descriptionTextData.horizontalAlignment = 4;
        descriptionTextData.horizontalSpan = 3;
        this.description = new Text(parent, 2562);
        this.description.setLayoutData((Object)descriptionTextData);
        this.description.setEditable(false);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object node;
                ISelection object = event.getSelection();
                CustomSelectionDialogWithDescription.this.selection = node = ((StructuredSelection)object).getFirstElement();
                if (node instanceof GeneList) {
                    if (((GeneList)node).getDescription() != null) {
                        CustomSelectionDialogWithDescription.this.description.setText(((GeneList)node).getDescription());
                    } else {
                        CustomSelectionDialogWithDescription.this.description.setText("");
                    }
                } else if (node instanceof PlateLayout) {
                    if (((PlateLayout)node).getDescription() != null) {
                        CustomSelectionDialogWithDescription.this.description.setText(((PlateLayout)node).getDescription());
                    } else {
                        CustomSelectionDialogWithDescription.this.description.setText("");
                    }
                }
            }
        });
        return parent;
    }

    public void initializeGeneListSelectionDialog() {
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.setTitle("Selection");
        this.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof GeneList) {
                    return ((GeneList)element).getListName();
                }
                if (element instanceof PlateLayout) {
                    return ((PlateLayout)element).getName();
                }
                return null;
            }
        });
        this.setInput(this.input);
    }
}

