/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.EntryEditorPart;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.process.TableDataProcessorRunner;
import org.grits.toolbox.display.control.table.tablecore.DelayedResizeListener;
import org.grits.toolbox.display.control.table.tablecore.GRITSTable;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.views.tabbed.IMSPeaksViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecResultsComposite;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecTableBase;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;

public class MassSpecScansView
extends EntryEditorPart
implements IMSPeaksViewer {
    private static final Logger logger = Logger.getLogger(MassSpecScansView.class);
    public static final String VIEW_ID = "plugin.ms.annotation.views.MSAnnotationScansView";
    protected Composite parent = null;
    protected Composite compositeTop = null;
    protected Composite container = null;
    protected MassSpecTableBase viewBase = null;
    protected MassSpecResultsComposite resultsComposite = null;
    protected Property entityProperty = null;
    protected TableDataProcessor dataProcessor = null;
    protected int iMinMSLevel = -1;
    @Inject
    protected IEclipseContext context;

    @Inject
    public MassSpecScansView(Entry entry, Property msEntityProperty, @Named(value="MinMSLevelContext") @Named(value="MinMSLevelContext") int iMinMSLevel) {
        this.entry = entry;
        this.entityProperty = msEntityProperty;
        this.iMinMSLevel = iMinMSLevel;
    }

    public MassSpecResultsComposite getResultsView() {
        return this.resultsComposite;
    }

    public Composite getContainer() {
        return this.container;
    }

    @Override
    public int getStatus() {
        if (this.viewBase == null) {
            return GRITSProcessStatus.ERROR;
        }
        if (this.dataProcessor.isCanceled()) {
            return GRITSProcessStatus.CANCEL;
        }
        return GRITSProcessStatus.OK;
    }

    public int getMinMSLevel() {
        return this.iMinMSLevel;
    }

    public void setMinMSLevel(int iMinMSLevel) {
        this.iMinMSLevel = iMinMSLevel;
    }

    public void setEntityProperty(MassSpecEntityProperty entityProperty) {
        this.entityProperty = entityProperty;
    }

    public String toString() {
        return "MassSpecScansView (" + this.entry + ")";
    }

    protected void initResultsView(Composite parent) throws Exception {
        this.parent = parent.getParent().getParent();
        this.compositeTop = new Composite(parent, 2048);
        this.compositeTop.setLayout((Layout)new GridLayout(1, false));
        try {
            this.resultsComposite = this.getNewResultsComposite(this.compositeTop, 0);
            this.resultsComposite.createPartControl(this.compositeTop, this, this.entityProperty, this.dataProcessor, FillTypes.Scans);
            this.resultsComposite.setLayout((Layout)new FillLayout());
            this.viewBase = this.resultsComposite.getBaseView();
        }
        catch (Exception e) {
            this.viewBase = null;
            this.resultsComposite = null;
            logger.error((Object)"Error in MassSpecScansView: initResultsView");
            throw new Exception(e.getMessage());
        }
    }

    protected void addListeners(Composite container) {
        DelayedResizeListener l = new DelayedResizeListener();
        if (this.resultsComposite != null) {
            l.addTable((GRITSTable)this.resultsComposite.getBaseView().getNatTable());
        }
        container.addControlListener((ControlListener)l);
    }

    protected void createView(Composite container) throws Exception {
        this.initResultsView(container);
    }

    public void createPartControl(Composite parent) {
        try {
            this.container = new Composite(parent, 0);
            this.container.setLayout((Layout)new FillLayout());
            this.createView(this.container);
            this.addListeners(this.container);
        }
        catch (Exception exception) {
            this.viewBase = null;
            this.resultsComposite = null;
        }
    }

    protected MassSpecResultsComposite getNewResultsComposite(Composite composite, int style) {
        return new MassSpecResultsComposite(composite, style);
    }

    @Override
    public MassSpecTableBase getViewBase() {
        return this.viewBase;
    }

    @Override
    public TableDataProcessor getTableDataProcessor() {
        return this.dataProcessor;
    }

    public int setTableDataProcessor(GRITSProgressDialog dtpd) {
        this.dataProcessor = this.getNewTableDataProcessor(this.entityProperty);
        int iStatus = GRITSProcessStatus.OK;
        if (this.dataProcessor == null) {
            try {
                this.dataProcessor = this.getNewTableDataProcessor(this.getEntry(), this.entityProperty);
                this.dataProcessor.setProgressBarDialog(dtpd);
                iStatus = this.openReadWriteDialog(TableDataProcessor.OPEN);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to create XML Extractor.", (Throwable)e);
                return GRITSProcessStatus.ERROR;
            }
        } else {
            this.dataProcessor.setProgressBarDialog(dtpd);
        }
        return iStatus;
    }

    protected int openReadWriteDialog(Integer processType) {
        TableDataProcessorRunner processRunner = new TableDataProcessorRunner((TableDataProcessor)((MassSpecTableDataProcessor)this.getTableDataProcessor()));
        try {
            this.getTableDataProcessor().setProcessType(processType);
            int iStatus = processRunner.startJob();
            return iStatus;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected TableDataProcessor getNewTableDataProcessor(Entry entry, Property entityProperty) {
        MassSpecTableDataProcessor proc = new MassSpecTableDataProcessor(entry, entityProperty, FillTypes.Scans, this.getMinMSLevel());
        proc.initializeTableDataObject(entityProperty);
        return proc;
    }

    protected TableDataProcessor getNewTableDataProcessor(Property entityProperty) {
        MassSpecMultiPageViewer parentViewer = MassSpecMultiPageViewer.getActiveViewerForEntry(this.context, this.getEntry().getParent());
        if (parentViewer == null || parentViewer.getScansView() == null) {
            return null;
        }
        TableDataProcessor parentProc = parentViewer.getScansView().getTableDataProcessor();
        if (parentProc == null) {
            return null;
        }
        if (!parentProc.getSourceProperty().equals(entityProperty)) {
            return null;
        }
        MassSpecTableDataProcessor proc = new MassSpecTableDataProcessor(parentProc, entityProperty, FillTypes.Scans);
        proc.setParentShell(this.parent.getShell());
        proc.initializeTableDataObject(entityProperty);
        return proc;
    }

    protected boolean isRightType(Entry entry) {
        return entry.getProperty().getType().equals(MassSpecEntityProperty.TYPE);
    }

    protected void updateProjectProperty() {
    }

    protected void savePreference() {
    }

    protected Composite getParent() {
        return this.parent;
    }

    public void setParent(Composite parent) {
        this.parent = parent;
    }

    @Focus
    public void setFocus() {
    }

    public void setDirty(boolean d) {
        super.setDirty(d);
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    @Override
    public void reInitializeView() throws Exception {
    }

    @Override
    public void reLoadView() {
        try {
            this.resultsComposite.reInit(this.entityProperty);
        }
        catch (Exception exception) {
            this.viewBase = null;
            this.resultsComposite = null;
            logger.error((Object)"Error in MSAnnotationPeaksView: reInitializeView");
        }
    }
}

