/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.handler;

import java.io.File;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.ms.dialog.SpectraAverageDialog;
import org.grits.toolbox.entry.ms.dialog.process.ProgressReporterDialog;
import org.grits.toolbox.tools.spectrafiltering.dialog.process.ProgressDialogThread;
import org.grits.toolbox.tools.spectrafiltering.om.SpectraFilterSettings;
import org.grits.toolbox.tools.spectrafiltering.process.SpectraAverageThread;

public class SpectraAverageHandler {
    private static final Logger logger = Logger.getLogger(SpectraAverageHandler.class);
    public static final String PARAMETER = "mzXMLFile_Path";
    public static final String PARAMETER2 = "msPath";
    public static final String COMMAND_ID = "org.grits.toolbox.entry.ms.command.spectraaverage";

    @Execute
    public String execute(@Named(value="activeShell") @Named(value="activeShell") Shell shell, @Named(value="mzXMLFile_Path") @Named(value="mzXMLFile_Path") String file, @Named(value="msPath") @Named(value="msPath") String msPath) {
        SpectraFilterSettings filter = new SpectraFilterSettings();
        SpectraAverageDialog dlg = new SpectraAverageDialog(shell, filter);
        if (dlg.open() != 0) {
            return null;
        }
        String suffix = "-avgWith" + filter.getAccuracy();
        suffix = String.valueOf(suffix) + (filter.getPPM() != false ? "PPM" : "Dalton");
        filter.setOpenFrom(String.valueOf(msPath) + File.separator + file);
        filter.setSaveLocation(String.valueOf(msPath) + File.separator + file.substring(0, file.lastIndexOf(".")) + suffix + ".mzXML");
        SpectraAverageThread worker = new SpectraAverageThread(filter);
        ProgressReporterDialog dlgProgress = new ProgressReporterDialog(shell);
        dlgProgress.setWorker((ProgressDialogThread)worker);
        dlgProgress.open();
        if (!new File(filter.getSaveLocation()).exists()) {
            return null;
        }
        return filter.getSaveLocation();
    }
}

