/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering;

import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.ClusterPair;
import com.apporiented.algorithm.clustering.ClusteringAlgorithm;
import com.apporiented.algorithm.clustering.Distance;
import com.apporiented.algorithm.clustering.DistanceMap;
import com.apporiented.algorithm.clustering.HierarchyBuilder;
import com.apporiented.algorithm.clustering.LinkageStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class DefaultClusteringAlgorithm
implements ClusteringAlgorithm {
    @Override
    public Cluster performClustering(double[][] distances, String[] clusterNames, LinkageStrategy linkageStrategy) {
        this.checkArguments(distances, clusterNames, linkageStrategy);
        List<Cluster> clusters = this.createClusters(clusterNames);
        DistanceMap linkages = this.createLinkages(distances, clusters);
        HierarchyBuilder builder = new HierarchyBuilder(clusters, linkages);
        while (!builder.isTreeComplete()) {
            builder.agglomerate(linkageStrategy);
        }
        return builder.getRootCluster();
    }

    private void checkArguments(double[][] distances, String[] clusterNames, LinkageStrategy linkageStrategy) {
        if (distances == null || distances.length == 0 || distances[0].length != distances.length) {
            throw new IllegalArgumentException("Invalid distance matrix");
        }
        if (distances.length != clusterNames.length) {
            throw new IllegalArgumentException("Invalid cluster name array");
        }
        if (linkageStrategy == null) {
            throw new IllegalArgumentException("Undefined linkage strategy");
        }
        int uniqueCount = new HashSet<String>(Arrays.asList(clusterNames)).size();
        if (uniqueCount != clusterNames.length) {
            throw new IllegalArgumentException("Duplicate names");
        }
    }

    @Override
    public Cluster performWeightedClustering(double[][] distances, String[] clusterNames, double[] weights, LinkageStrategy linkageStrategy) {
        this.checkArguments(distances, clusterNames, linkageStrategy);
        if (weights.length != clusterNames.length) {
            throw new IllegalArgumentException("Invalid weights array");
        }
        List<Cluster> clusters = this.createClusters(clusterNames, weights);
        DistanceMap linkages = this.createLinkages(distances, clusters);
        HierarchyBuilder builder = new HierarchyBuilder(clusters, linkages);
        while (!builder.isTreeComplete()) {
            builder.agglomerate(linkageStrategy);
        }
        return builder.getRootCluster();
    }

    private DistanceMap createLinkages(double[][] distances, List<Cluster> clusters) {
        DistanceMap linkages = new DistanceMap();
        int col = 0;
        while (col < clusters.size()) {
            int row = col + 1;
            while (row < clusters.size()) {
                ClusterPair link = new ClusterPair();
                Cluster lCluster = clusters.get(col);
                Cluster rCluster = clusters.get(row);
                link.setLinkageDistance(distances[col][row]);
                link.setlCluster(lCluster);
                link.setrCluster(rCluster);
                linkages.add(link);
                ++row;
            }
            ++col;
        }
        return linkages;
    }

    private List<Cluster> createClusters(String[] clusterNames) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        String[] stringArray = clusterNames;
        int n = clusterNames.length;
        int n2 = 0;
        while (n2 < n) {
            String clusterName = stringArray[n2];
            Cluster cluster = new Cluster(clusterName);
            clusters.add(cluster);
            ++n2;
        }
        return clusters;
    }

    private List<Cluster> createClusters(String[] clusterNames, double[] weights) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        int i = 0;
        while (i < weights.length) {
            Cluster cluster = new Cluster(clusterNames[i]);
            cluster.setDistance(new Distance(0.0, weights[i]));
            clusters.add(cluster);
            ++i;
        }
        return clusters;
    }
}

