/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.views;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.editor.EntryEditorPart;
import org.grits.toolbox.entry.ms.annotation.glycan.report.property.MSGlycanAnnotationReportProperty;
import org.grits.toolbox.merge.om.data.ExperimentAnnotation;
import org.grits.toolbox.merge.om.data.MergeSettings;
import org.grits.toolbox.ms.om.data.Method;

public class MSGlycanAnnotationReportPropertyView
extends EntryEditorPart {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationReportPropertyView.class);
    private Composite parent = null;
    private Composite container = null;
    protected Method msAnnotationMethod = null;
    private MergeSettings mergeSettings = null;
    private Label massIntervalLabel = null;
    private Text massIntervalText = null;
    private Label massIntervalTypeLabel = null;
    private Label descriptionLabel = null;
    private Text descriptionText = null;
    private Label creationDateLabel = null;
    private Text creationDateText = null;
    private Label updateDateLabel = null;
    private Text updateDateText = null;
    private MPart part;

    @Inject
    public MSGlycanAnnotationReportPropertyView(Entry entry) {
        this.entry = entry;
    }

    @PostConstruct
    public void postConstruct(MPart part) {
        this.part = part;
    }

    public void createPartControl(Composite parent) {
        ModifyListener modListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MSGlycanAnnotationReportPropertyView.this.setDirty(true);
            }
        };
        parent.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite(parent, 2560);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite c = new Composite((Composite)sc, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 6;
        c.setLayout((Layout)layout);
        this.parent = parent;
        this.container = c;
        MSGlycanAnnotationReportProperty msgrp = (MSGlycanAnnotationReportProperty)this.entry.getProperty();
        this.part.setLabel(String.valueOf(this.entry.getDisplayName()) + " Properties");
        try {
            this.addDescriptionLine(msgrp, modListener);
            this.addIntervalControls();
            this.addDateControls(msgrp);
            this.addAnnotationEntries();
        }
        catch (Exception e) {
            logger.error((Object)"Error adding property elements.", (Throwable)e);
        }
        sc.setContent((Control)c);
        sc.setMinSize(c.computeSize(-1, -1));
    }

    private void addDescriptionLine(MSGlycanAnnotationReportProperty pp, ModifyListener modListener) {
        this.descriptionLabel = new Label(this.getContainer(), 0);
        this.descriptionLabel.setText("Description");
        GridData descriptionLabelData = new GridData();
        descriptionLabelData.horizontalSpan = 4;
        this.descriptionLabel.setLayoutData((Object)descriptionLabelData);
        GridData descriptionTextData = new GridData();
        descriptionTextData.horizontalAlignment = 4;
        descriptionTextData.grabExcessHorizontalSpace = true;
        this.descriptionText = new Text(this.getContainer(), 2626);
        this.descriptionText.setText(pp.getMsGlycanAnnotReportMetaData().getDescription());
        GridData gdTxtGridData = new GridData();
        gdTxtGridData.grabExcessHorizontalSpace = true;
        gdTxtGridData.horizontalAlignment = 4;
        gdTxtGridData.horizontalSpan = 2;
        gdTxtGridData.heightHint = 100;
        this.descriptionText.setLayoutData((Object)gdTxtGridData);
    }

    private void addDateControls(MSGlycanAnnotationReportProperty pp) {
        if (this.mergeSettings != null) {
            String sCreateDate = pp.getMsGlycanAnnotReportMetaData().getCreationDate() == null ? "" : pp.getMsGlycanAnnotReportMetaData().getCreationDate().toString();
            this.creationDateLabel = new Label(this.getContainer(), 0);
            this.creationDateLabel.setText("Report Creation Date");
            GridData creationDateLabelData = new GridData();
            creationDateLabelData.horizontalSpan = 4;
            this.creationDateLabel.setLayoutData((Object)creationDateLabelData);
            this.creationDateText = new Text(this.getContainer(), 2048);
            this.creationDateText.setText(sCreateDate);
            this.creationDateText.setEnabled(false);
            GridData creationDateTextData = new GridData();
            creationDateTextData.grabExcessHorizontalSpace = true;
            creationDateTextData.horizontalAlignment = 4;
            creationDateTextData.horizontalSpan = 2;
            this.creationDateText.setLayoutData((Object)creationDateTextData);
            String sUpdateDate = pp.getMsGlycanAnnotReportMetaData().getUpdateDate() == null ? "" : pp.getMsGlycanAnnotReportMetaData().getUpdateDate().toString();
            this.updateDateLabel = new Label(this.getContainer(), 0);
            this.updateDateLabel.setText("Report Refresh Date");
            GridData updateDateLabelData = new GridData();
            updateDateLabelData.horizontalSpan = 4;
            this.updateDateLabel.setLayoutData((Object)updateDateLabelData);
            this.updateDateText = new Text(this.getContainer(), 2048);
            this.updateDateText.setText(sUpdateDate);
            this.updateDateText.setEnabled(false);
            GridData updateDateTextData = new GridData();
            updateDateTextData.grabExcessHorizontalSpace = true;
            updateDateTextData.horizontalAlignment = 4;
            updateDateTextData.horizontalSpan = 2;
            this.updateDateText.setLayoutData((Object)updateDateTextData);
        }
    }

    private void addIntervalControls() {
        if (this.mergeSettings != null) {
            double dMassTolerance = this.mergeSettings.getTolerance();
            String sTolType = this.mergeSettings.getToleranceType() != null ? this.mergeSettings.getToleranceType() : "";
            this.massIntervalLabel = new Label(this.getContainer(), 0);
            this.massIntervalLabel.setText("Mass Interval for Merge");
            GridData massIntervalLabelData = new GridData();
            massIntervalLabelData.horizontalSpan = 3;
            this.massIntervalLabel.setLayoutData((Object)massIntervalLabelData);
            this.massIntervalTypeLabel = new Label(this.getContainer(), 0);
            this.massIntervalTypeLabel.setText("(" + sTolType + ")");
            GridData massIntervalTypeData = new GridData();
            massIntervalTypeData.horizontalSpan = 1;
            this.massIntervalTypeLabel.setLayoutData((Object)massIntervalTypeData);
            this.massIntervalText = new Text(this.getContainer(), 2048);
            this.massIntervalText.setText(Double.toString(dMassTolerance));
            this.massIntervalText.setEnabled(false);
            GridData massIntervalTextData = new GridData();
            massIntervalTextData.grabExcessHorizontalSpace = true;
            massIntervalTextData.horizontalAlignment = 4;
            massIntervalTextData.horizontalSpan = 2;
            this.massIntervalText.setLayoutData((Object)massIntervalTextData);
        }
    }

    private void addAnnotationEntries() {
        if (this.mergeSettings != null && this.mergeSettings.getExperimentList() != null) {
            Label lblIons = new Label(this.getContainer(), 16384);
            lblIons.setText("MS Glycan Annotations in this merge report: ");
            GridData gdIonsData = new GridData();
            gdIonsData.horizontalSpan = 6;
            lblIons.setLayoutData((Object)gdIonsData);
            int i = 0;
            while (i < this.mergeSettings.getExperimentList().size()) {
                ExperimentAnnotation expAnnot = (ExperimentAnnotation)this.mergeSettings.getExperimentList().get(i);
                Label lSpacer = new Label(this.getContainer(), 0);
                lSpacer.setText("     ");
                Label lblAnnotation = new Label(this.getContainer(), 0);
                lblAnnotation.setText("MS Glycan Annotation " + (i + 1));
                GridData gdIon = new GridData();
                gdIon.horizontalSpan = 5;
                lblAnnotation.setLayoutData((Object)gdIon);
                lSpacer = new Label(this.getContainer(), 0);
                lSpacer.setText("     ");
                lSpacer = new Label(this.getContainer(), 0);
                lSpacer.setText("     ");
                Label lblResultName = new Label(this.getContainer(), 16384);
                lblResultName.setText("Result name");
                GridData gdResultNameData = new GridData();
                gdResultNameData.horizontalSpan = 2;
                lblResultName.setLayoutData((Object)gdResultNameData);
                Text txtResultName = new Text(this.getContainer(), 2048);
                String sText = expAnnot.getAnnotationDisplayName() != null ? expAnnot.getAnnotationDisplayName() : "";
                txtResultName.setText(sText);
                txtResultName.setEditable(false);
                GridData gdTxtGridData1 = new GridData();
                gdTxtGridData1.grabExcessHorizontalSpace = true;
                gdTxtGridData1.horizontalAlignment = 4;
                gdTxtGridData1.horizontalSpan = 2;
                txtResultName.setLayoutData((Object)gdTxtGridData1);
                lSpacer = new Label(this.getContainer(), 0);
                lSpacer.setText("     ");
                lSpacer = new Label(this.getContainer(), 0);
                lSpacer.setText("     ");
                Label lblAlias = new Label(this.getContainer(), 16384);
                lblAlias.setText("Alias");
                GridData gdAliasNameData = new GridData();
                gdAliasNameData.horizontalSpan = 2;
                lblAlias.setLayoutData((Object)gdAliasNameData);
                Text txtAlias = new Text(this.getContainer(), 2048);
                sText = expAnnot.getAnnotationShortName() != null ? expAnnot.getAnnotationShortName() : "";
                txtAlias.setText(sText);
                txtAlias.setEditable(false);
                GridData gdTxtGridData2 = new GridData();
                gdTxtGridData2.grabExcessHorizontalSpace = true;
                gdTxtGridData2.horizontalAlignment = 4;
                gdTxtGridData2.horizontalSpan = 2;
                txtAlias.setLayoutData((Object)gdTxtGridData2);
                lSpacer = new Label(this.getContainer(), 0);
                lSpacer.setText("     ");
                lSpacer = new Label(this.getContainer(), 0);
                lSpacer.setText("     ");
                Label lblArchive = new Label(this.getContainer(), 16384);
                lblArchive.setText("Result Archive");
                GridData gdArchiveData = new GridData();
                gdArchiveData.horizontalSpan = 2;
                lblArchive.setLayoutData((Object)gdArchiveData);
                Text txtArchive = new Text(this.getContainer(), 2048);
                sText = expAnnot.getAnnotationFileArchive() != null ? expAnnot.getAnnotationFileArchive() : "";
                txtArchive.setText(sText);
                txtArchive.setEditable(false);
                GridData gdTxtGridData3 = new GridData();
                gdTxtGridData3.grabExcessHorizontalSpace = true;
                gdTxtGridData3.horizontalAlignment = 4;
                gdTxtGridData3.horizontalSpan = 2;
                txtArchive.setLayoutData((Object)gdTxtGridData3);
                lSpacer = new Label(this.getContainer(), 0);
                lSpacer.setText("     ");
                lSpacer = new Label(this.getContainer(), 0);
                lSpacer.setText("     ");
                Label lblEntry = new Label(this.getContainer(), 16384);
                lblEntry.setText("Entry ID");
                GridData gdEntryData = new GridData();
                gdEntryData.horizontalSpan = 2;
                lblEntry.setLayoutData((Object)gdEntryData);
                Text txtEntry = new Text(this.getContainer(), 2048);
                sText = expAnnot.getAnnotationEntryId() != null ? Integer.toString(expAnnot.getAnnotationEntryId()) : "";
                txtEntry.setText(sText);
                txtEntry.setEditable(false);
                GridData gdTxtGridData4 = new GridData();
                gdTxtGridData4.grabExcessHorizontalSpace = true;
                gdTxtGridData4.horizontalAlignment = 4;
                gdTxtGridData4.horizontalSpan = 2;
                txtEntry.setLayoutData((Object)gdTxtGridData4);
                ++i;
            }
        }
    }

    protected void updateProjectProperty() {
        Entry projectEntry = DataModelSearch.findParentByType((Entry)this.entry, (String)"org.grits.toolbox.property.project");
        MSGlycanAnnotationReportProperty pp = (MSGlycanAnnotationReportProperty)this.entry.getProperty();
        pp.getMsGlycanAnnotReportMetaData().setDescription(this.descriptionText.getText());
        String settingsFile = pp.getFullyQualifiedMetaDataFileName(projectEntry);
        MSGlycanAnnotationReportProperty.marshallSettingsFile(settingsFile, pp.getMsGlycanAnnotReportMetaData());
    }

    public void setMergeSettings(MergeSettings mergeSettings) {
        this.mergeSettings = mergeSettings;
    }

    public MergeSettings getMergeSettings() {
        return this.mergeSettings;
    }

    @Focus
    public void setFocus() {
        this.descriptionLabel.setFocus();
    }

    protected Composite getParent() {
        return this.parent;
    }

    protected void savePreference() {
    }

    protected Composite getContainer() {
        return this.container;
    }
}

